/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.redis.spring.boot.autoconfigure;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;

class LettuceClientConfiguration {
    private final ClientResources clientResources;
    private final ClientOptions clientOptions;
    private final Duration timeout;

    LettuceClientConfiguration(Builder builder) {
        this.clientResources = builder.clientResources;
        this.clientOptions = builder.clientOptions;
        this.timeout = builder.timeout;
    }

    public ClientResources getClientResources() {
        return this.clientResources;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ClientResources clientResources = ClientResources.create();
        private ClientOptions clientOptions = ClientOptions.builder().timeoutOptions(TimeoutOptions.enabled()).build();
        private Duration timeout = Duration.ofSeconds(60L);

        private Builder() {
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder clientResources(ClientResources clientResources) {
            this.clientResources = clientResources;
            return this;
        }

        public Builder clientOptions(ClientOptions clientOptions) {
            this.clientOptions = clientOptions;
            return this;
        }

        public LettuceClientConfiguration build() {
            return new LettuceClientConfiguration(this);
        }
    }
}

