/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.redis.spring.boot.autoconfigure;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import java.util.Optional;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.iherus.shiro.cache.redis.config.DefaultPoolConfig;
import org.iherus.shiro.cache.redis.config.RedisClusterConfiguration;
import org.iherus.shiro.cache.redis.config.RedisSentinelConfiguration;
import org.iherus.shiro.cache.redis.config.RedisStandaloneConfiguration;
import org.iherus.shiro.cache.redis.connection.RedisConnectionFactory;
import org.iherus.shiro.cache.redis.connection.lettuce.LettuceConnectionFactory;
import org.iherus.shiro.redis.spring.boot.autoconfigure.LettuceClientConfiguration;
import org.iherus.shiro.redis.spring.boot.autoconfigure.LettuceClientConfigurationCustomizer;
import org.iherus.shiro.redis.spring.boot.autoconfigure.RedisConfigurationWrapper;
import org.iherus.shiro.redis.spring.boot.autoconfigure.RedisProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={GenericObjectPool.class, RedisClient.class})
@ConditionalOnMissingClass(value={"org.springframework.data.redis.connection.RedisConnectionFactory"})
public class LettuceConnectionFactoryConfiguration
extends RedisConfigurationWrapper {
    private final RedisProperties properties;
    private final ObjectProvider<LettuceClientConfigurationCustomizer> customizerProvider;

    protected LettuceConnectionFactoryConfiguration(RedisProperties properties, ObjectProvider<RedisStandaloneConfiguration> standaloneConfigProvider, ObjectProvider<RedisSentinelConfiguration> sentinelConfigProvider, ObjectProvider<RedisClusterConfiguration> clusterConfigProvider, ObjectProvider<LettuceClientConfigurationCustomizer> customizerProvider) {
        super(properties, standaloneConfigProvider, sentinelConfigProvider, clusterConfigProvider);
        this.properties = properties;
        this.customizerProvider = customizerProvider;
    }

    @Bean(name={"x_lettuceConnectionFactory"}, initMethod="init", destroyMethod="destroy")
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public LettuceConnectionFactory connectionFactory() {
        return this.createLettuceConnectionFactory();
    }

    private LettuceConnectionFactory createLettuceConnectionFactory() {
        GenericObjectPoolConfig poolConfig = this.createLettucePoolConfig(this.properties.getLettuce().getPool());
        RedisSentinelConfiguration sentinelConfig = null;
        RedisClusterConfiguration clusterConfig = null;
        LettuceConnectionFactory factory = null;
        sentinelConfig = this.getSentinelConfiguration();
        factory = sentinelConfig != null ? new LettuceConnectionFactory(sentinelConfig, poolConfig) : ((clusterConfig = this.getClusterConfiguration()) != null ? new LettuceConnectionFactory(clusterConfig, poolConfig) : new LettuceConnectionFactory(this.getStandaloneConfiguration(), poolConfig));
        this.applyProperties(factory);
        return factory;
    }

    private void applyProperties(LettuceConnectionFactory factory) {
        RedisProperties.LettuceConfig lettuceConfig = this.properties.getLettuce();
        LettuceClientConfiguration clientConfig = this.getLettuceClientConfiguration();
        factory.setClientName(lettuceConfig.getClientName());
        factory.setTimeout(clientConfig.getTimeout());
        factory.setUseSsl(lettuceConfig.isSsl());
        factory.setVerifyPeer(lettuceConfig.isVerifyPeer());
        factory.setStartTls(lettuceConfig.isStartTls());
        factory.setClientResources(clientConfig.getClientResources());
        factory.setClientOptions(clientConfig.getClientOptions());
        Optional.ofNullable(lettuceConfig.getReadFrom()).ifPresent(it -> factory.setReadFrom(ReadFrom.valueOf((String)it)));
    }

    private LettuceClientConfiguration getLettuceClientConfiguration() {
        LettuceClientConfiguration.Builder builder = LettuceClientConfiguration.builder();
        this.customize(builder);
        return builder.build();
    }

    private GenericObjectPoolConfig createLettucePoolConfig(RedisProperties.Pool settingPoolConfig) {
        if (settingPoolConfig == null) {
            return new DefaultPoolConfig();
        }
        DefaultPoolConfig config = new DefaultPoolConfig();
        config.setMinIdle(settingPoolConfig.getMinIdle());
        config.setMaxIdle(settingPoolConfig.getMaxIdle());
        config.setMaxTotal(settingPoolConfig.getMaxTotal());
        config.setMaxWaitMillis(settingPoolConfig.getMaxWaitMillis());
        config.setTestOnBorrow(settingPoolConfig.isTestOnBorrow());
        config.setTestWhileIdle(settingPoolConfig.isTestWhileIdle());
        config.setMinEvictableIdleTimeMillis(settingPoolConfig.getMinEvictableIdleTimeMillis());
        config.setTimeBetweenEvictionRunsMillis(settingPoolConfig.getTimeBetweenEvictionRunsMillis());
        config.setNumTestsPerEvictionRun(settingPoolConfig.getNumTestsPerEvictionRun());
        return config;
    }

    private void customize(LettuceClientConfiguration.Builder builder) {
        this.customizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
    }
}

