/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.redis.spring.boot.autoconfigure;

import org.iherus.shiro.cache.redis.config.RedisClusterConfiguration;
import org.iherus.shiro.cache.redis.config.RedisSentinelConfiguration;
import org.iherus.shiro.cache.redis.config.RedisStandaloneConfiguration;
import org.iherus.shiro.redis.spring.boot.autoconfigure.RedisProperties;
import org.springframework.beans.factory.ObjectProvider;

abstract class RedisConfigurationWrapper {
    private final RedisProperties properties;
    private final RedisStandaloneConfiguration standaloneConfiguration;
    private final RedisSentinelConfiguration sentinelConfiguration;
    private final RedisClusterConfiguration clusterConfiguration;

    protected RedisConfigurationWrapper(RedisProperties properties, ObjectProvider<RedisStandaloneConfiguration> standaloneConfigProvider, ObjectProvider<RedisSentinelConfiguration> sentinelConfigProvider, ObjectProvider<RedisClusterConfiguration> clusterConfigProvider) {
        this.properties = properties;
        this.standaloneConfiguration = (RedisStandaloneConfiguration)standaloneConfigProvider.getIfUnique();
        this.sentinelConfiguration = (RedisSentinelConfiguration)sentinelConfigProvider.getIfUnique();
        this.clusterConfiguration = (RedisClusterConfiguration)clusterConfigProvider.getIfUnique();
    }

    protected final RedisStandaloneConfiguration getStandaloneConfiguration() {
        if (this.standaloneConfiguration != null) {
            return this.standaloneConfiguration;
        }
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHost(this.properties.getHost());
        config.setPort(this.properties.getPort());
        config.setPassword(this.properties.getPassword());
        config.setDatabase(this.properties.getDatabase());
        return config;
    }

    protected final RedisSentinelConfiguration getSentinelConfiguration() {
        if (this.sentinelConfiguration != null) {
            return this.sentinelConfiguration;
        }
        RedisProperties.SentinelConfig setting = this.properties.getSentinel();
        if (setting == null) {
            return null;
        }
        RedisSentinelConfiguration config = new RedisSentinelConfiguration();
        config.setMasterName(setting.getMasterName());
        config.setSentinelsFromText(setting.getNodes());
        config.setDatabase(this.properties.getDatabase());
        config.setPassword(this.properties.getPassword());
        return config;
    }

    protected final RedisClusterConfiguration getClusterConfiguration() {
        if (this.clusterConfiguration != null) {
            return this.clusterConfiguration;
        }
        RedisProperties.ClusterConfig setting = this.properties.getCluster();
        if (setting == null) {
            return null;
        }
        RedisClusterConfiguration config = new RedisClusterConfiguration();
        config.setClusterNodesFromText(setting.getNodes());
        config.setMaxAttempts(setting.getMaxAttempts());
        config.setPassword(this.properties.getPassword());
        return config;
    }
}

