/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.redis.spring.boot.autoconfigure;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="shiro.redis")
public class RedisProperties {
    private String host = "localhost";
    private int port = 6379;
    private int database;
    private String password;
    private SentinelConfig sentinel;
    private ClusterConfig cluster;
    private JedisConfig jedis = new JedisConfig();
    private LettuceConfig lettuce = new LettuceConfig();
    private RedissonConfig redisson = new RedissonConfig();
    private BatchOptionConfig batchOption = new BatchOptionConfig();

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SentinelConfig getSentinel() {
        return this.sentinel;
    }

    public void setSentinel(SentinelConfig sentinel) {
        this.sentinel = sentinel;
    }

    public ClusterConfig getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterConfig cluster) {
        this.cluster = cluster;
    }

    public JedisConfig getJedis() {
        return this.jedis;
    }

    public void setJedis(JedisConfig jedis) {
        this.jedis = jedis;
    }

    public LettuceConfig getLettuce() {
        return this.lettuce;
    }

    public void setLettuce(LettuceConfig lettuce) {
        this.lettuce = lettuce;
    }

    public RedissonConfig getRedisson() {
        return this.redisson;
    }

    public void setRedisson(RedissonConfig redisson) {
        this.redisson = redisson;
    }

    public BatchOptionConfig getBatchOption() {
        return this.batchOption;
    }

    public void setBatchOption(BatchOptionConfig batchOption) {
        this.batchOption = batchOption;
    }

    public static class Pool {
        private int maxTotal = 8;
        private int maxIdle = 8;
        private int minIdle = 3;
        private long maxWaitMillis = 90000L;
        private boolean testOnBorrow = false;
        private boolean testWhileIdle = true;
        private long timeBetweenEvictionRunsMillis = 30000L;
        private long minEvictableIdleTimeMillis = 60000L;
        private int numTestsPerEvictionRun = -1;

        public int getMaxTotal() {
            return this.maxTotal;
        }

        public void setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
        }

        public int getMaxIdle() {
            return this.maxIdle;
        }

        public void setMaxIdle(int maxIdle) {
            this.maxIdle = maxIdle;
        }

        public int getMinIdle() {
            return this.minIdle;
        }

        public void setMinIdle(int minIdle) {
            this.minIdle = minIdle;
        }

        public long getMaxWaitMillis() {
            return this.maxWaitMillis;
        }

        public void setMaxWaitMillis(long maxWaitMillis) {
            this.maxWaitMillis = maxWaitMillis;
        }

        public boolean isTestOnBorrow() {
            return this.testOnBorrow;
        }

        public void setTestOnBorrow(boolean testOnBorrow) {
            this.testOnBorrow = testOnBorrow;
        }

        public boolean isTestWhileIdle() {
            return this.testWhileIdle;
        }

        public void setTestWhileIdle(boolean testWhileIdle) {
            this.testWhileIdle = testWhileIdle;
        }

        public long getTimeBetweenEvictionRunsMillis() {
            return this.timeBetweenEvictionRunsMillis;
        }

        public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
            this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        }

        public long getMinEvictableIdleTimeMillis() {
            return this.minEvictableIdleTimeMillis;
        }

        public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
            this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        }

        public int getNumTestsPerEvictionRun() {
            return this.numTestsPerEvictionRun;
        }

        public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
            this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        }
    }

    public static class BatchOptionConfig {
        private int scanBatchSize = 3000;
        private int deleteBatchSize = 5000;
        private int fetchBatchSize = 50;

        public int getScanBatchSize() {
            return this.scanBatchSize;
        }

        public void setScanBatchSize(int scanBatchSize) {
            this.scanBatchSize = scanBatchSize;
        }

        public int getDeleteBatchSize() {
            return this.deleteBatchSize;
        }

        public void setDeleteBatchSize(int deleteBatchSize) {
            this.deleteBatchSize = deleteBatchSize;
        }

        public int getFetchBatchSize() {
            return this.fetchBatchSize;
        }

        public void setFetchBatchSize(int fetchBatchSize) {
            this.fetchBatchSize = fetchBatchSize;
        }
    }

    public static class RedissonConfig {
        private String clientName;
        private boolean ssl;
        private Duration connectTimeout = Duration.ofMillis(10000L);
        private Duration soTimeout = Duration.ofMillis(3000L);
        private int connectionMinIdleSize = 24;
        private int connectionPoolSize = 64;

        public String getClientName() {
            return this.clientName;
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public boolean isSsl() {
            return this.ssl;
        }

        public void setSsl(boolean ssl) {
            this.ssl = ssl;
        }

        public Duration getSoTimeout() {
            return this.soTimeout;
        }

        public void setSoTimeout(Duration soTimeout) {
            this.soTimeout = soTimeout;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public int getConnectionMinIdleSize() {
            return this.connectionMinIdleSize;
        }

        public void setConnectionMinIdleSize(int connectionMinIdleSize) {
            this.connectionMinIdleSize = connectionMinIdleSize;
        }

        public int getConnectionPoolSize() {
            return this.connectionPoolSize;
        }

        public void setConnectionPoolSize(int connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
        }
    }

    public static class LettuceConfig {
        private String clientName;
        private boolean ssl;
        private boolean verifyPeer = true;
        private boolean startTls;
        private String readFrom;
        private Pool pool = new Pool();

        public String getClientName() {
            return this.clientName;
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public boolean isSsl() {
            return this.ssl;
        }

        public void setSsl(boolean ssl) {
            this.ssl = ssl;
        }

        public boolean isVerifyPeer() {
            return this.verifyPeer;
        }

        public void setVerifyPeer(boolean verifyPeer) {
            this.verifyPeer = verifyPeer;
        }

        public boolean isStartTls() {
            return this.startTls;
        }

        public void setStartTls(boolean startTls) {
            this.startTls = startTls;
        }

        public String getReadFrom() {
            return this.readFrom;
        }

        public void setReadFrom(String readFrom) {
            this.readFrom = readFrom;
        }

        public Pool getPool() {
            return this.pool;
        }

        public void setPool(Pool pool) {
            this.pool = pool;
        }
    }

    public static class JedisConfig {
        private String clientName;
        private Duration soTimeout = Duration.ofMillis(2000L);
        private Duration connectTimeout = Duration.ofMillis(2000L);
        private boolean ssl;
        private Pool pool = new Pool();

        public String getClientName() {
            return this.clientName;
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public Duration getSoTimeout() {
            return this.soTimeout;
        }

        public void setSoTimeout(Duration soTimeout) {
            this.soTimeout = soTimeout;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public boolean isSsl() {
            return this.ssl;
        }

        public void setSsl(boolean ssl) {
            this.ssl = ssl;
        }

        public Pool getPool() {
            return this.pool;
        }

        public void setPool(Pool pool) {
            this.pool = pool;
        }
    }

    public static class ClusterConfig {
        private String nodes;
        private int maxAttempts;

        public String getNodes() {
            return this.nodes;
        }

        public void setNodes(String nodes) {
            this.nodes = nodes;
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }
    }

    public static class SentinelConfig {
        private String masterName;
        private String nodes;

        public String getMasterName() {
            return this.masterName;
        }

        public void setMasterName(String masterName) {
            this.masterName = masterName;
        }

        public String getNodes() {
            return this.nodes;
        }

        public void setNodes(String nodes) {
            this.nodes = nodes;
        }
    }
}

