/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.redis.spring.boot.autoconfigure;

import org.iherus.shiro.cache.redis.config.RedisClusterConfiguration;
import org.iherus.shiro.cache.redis.config.RedisSentinelConfiguration;
import org.iherus.shiro.cache.redis.config.RedisStandaloneConfiguration;
import org.iherus.shiro.cache.redis.connection.RedisConnectionFactory;
import org.iherus.shiro.cache.redis.connection.redisson.RedissonConnectionFactory;
import org.iherus.shiro.redis.spring.boot.autoconfigure.RedisConfigurationWrapper;
import org.iherus.shiro.redis.spring.boot.autoconfigure.RedisProperties;
import org.iherus.shiro.redis.spring.boot.autoconfigure.RedissonSslClientConfiguration;
import org.iherus.shiro.redis.spring.boot.autoconfigure.RedissonSslClientConfigurationCustomizer;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RedissonClient.class})
@ConditionalOnMissingClass(value={"org.springframework.data.redis.connection.RedisConnectionFactory"})
public class RedissonConnectionFactoryConfiguration
extends RedisConfigurationWrapper {
    private final RedisProperties properties;
    private final ObjectProvider<RedissonSslClientConfigurationCustomizer> customizerProvider;

    protected RedissonConnectionFactoryConfiguration(RedisProperties properties, ObjectProvider<RedisStandaloneConfiguration> standaloneConfigProvider, ObjectProvider<RedisSentinelConfiguration> sentinelConfigProvider, ObjectProvider<RedisClusterConfiguration> clusterConfigProvider, ObjectProvider<RedissonSslClientConfigurationCustomizer> customizerProvider) {
        super(properties, standaloneConfigProvider, sentinelConfigProvider, clusterConfigProvider);
        this.properties = properties;
        this.customizerProvider = customizerProvider;
    }

    @Bean(name={"x_redissonConnectionFactory"}, initMethod="init", destroyMethod="destroy")
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public RedissonConnectionFactory connectionFactory() {
        return this.createRedissonConnectionFactory();
    }

    private RedissonConnectionFactory createRedissonConnectionFactory() {
        RedisSentinelConfiguration sentinelConfig = null;
        RedisClusterConfiguration clusterConfig = null;
        RedissonConnectionFactory factory = null;
        sentinelConfig = this.getSentinelConfiguration();
        factory = sentinelConfig != null ? new RedissonConnectionFactory(sentinelConfig) : ((clusterConfig = this.getClusterConfiguration()) != null ? new RedissonConnectionFactory(clusterConfig) : new RedissonConnectionFactory(this.getStandaloneConfiguration()));
        this.applyProperties(factory);
        return factory;
    }

    private void applyProperties(RedissonConnectionFactory factory) {
        RedisProperties.RedissonConfig redissonConfig = this.properties.getRedisson();
        RedissonSslClientConfiguration sslConfig = this.getRedissonSslClientConfiguration();
        factory.setClientName(redissonConfig.getClientName());
        factory.setConnectTimeout(redissonConfig.getConnectTimeout());
        factory.setSoTimeout(redissonConfig.getSoTimeout());
        factory.setConnectionMinIdleSize(Integer.valueOf(redissonConfig.getConnectionMinIdleSize()));
        factory.setConnectionPoolSize(Integer.valueOf(redissonConfig.getConnectionPoolSize()));
        factory.setUseSsl(redissonConfig.isSsl());
        factory.setSslTruststore(sslConfig.getSslTruststore());
        factory.setSslTruststorePassword(sslConfig.getSslTruststorePassword());
        factory.setSslKeystore(sslConfig.getSslKeystore());
        factory.setSslKeystorePassword(sslConfig.getSslKeystorePassword());
    }

    private RedissonSslClientConfiguration getRedissonSslClientConfiguration() {
        RedissonSslClientConfiguration.Builder builder = RedissonSslClientConfiguration.builder();
        this.customize(builder);
        return builder.build();
    }

    private void customize(RedissonSslClientConfiguration.Builder builder) {
        this.customizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
    }
}

