/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.redis.spring.boot.autoconfigure;

import java.net.URL;

class RedissonSslClientConfiguration {
    private final URL sslTruststore;
    private final String sslTruststorePassword;
    private final URL sslKeystore;
    private final String sslKeystorePassword;

    RedissonSslClientConfiguration(Builder builder) {
        this.sslTruststore = builder.sslTruststore;
        this.sslTruststorePassword = builder.sslTruststorePassword;
        this.sslKeystore = builder.sslKeystore;
        this.sslKeystorePassword = builder.sslKeystorePassword;
    }

    public URL getSslTruststore() {
        return this.sslTruststore;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public URL getSslKeystore() {
        return this.sslKeystore;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private URL sslTruststore;
        private String sslTruststorePassword;
        private URL sslKeystore;
        private String sslKeystorePassword;

        private Builder() {
        }

        public Builder sslTruststore(URL sslTruststore) {
            this.sslTruststore = sslTruststore;
            return this;
        }

        public Builder sslTruststorePassword(String sslTruststorePassword) {
            this.sslTruststorePassword = sslTruststorePassword;
            return this;
        }

        public Builder sslKeystore(URL sslKeystore) {
            this.sslKeystore = sslKeystore;
            return this;
        }

        public Builder sslKeystorePassword(String sslKeystorePassword) {
            this.sslKeystorePassword = sslKeystorePassword;
            return this;
        }

        public RedissonSslClientConfiguration build() {
            return new RedissonSslClientConfiguration(this);
        }
    }
}

