/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.redis.spring.boot.autoconfigure;

import java.io.Serializable;
import java.util.Optional;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.JavaUuidSessionIdGenerator;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.apache.shiro.spring.config.web.autoconfigure.ShiroWebAutoConfiguration;
import org.iherus.shiro.cache.redis.RedisCacheManager;
import org.iherus.shiro.cache.redis.RedisSessionDAO;
import org.iherus.shiro.cache.redis.connection.RedisConnectionFactory;
import org.iherus.shiro.redis.spring.boot.autoconfigure.CompatibleRedisConnectionFactoryConfiguration;
import org.iherus.shiro.redis.spring.boot.autoconfigure.JedisConnectionFactoryConfiguration;
import org.iherus.shiro.redis.spring.boot.autoconfigure.LettuceConnectionFactoryConfiguration;
import org.iherus.shiro.redis.spring.boot.autoconfigure.RedisProperties;
import org.iherus.shiro.redis.spring.boot.autoconfigure.RedissonConnectionFactoryConfiguration;
import org.iherus.shiro.redis.spring.boot.autoconfigure.ShiroExtProperties;
import org.iherus.shiro.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureBefore(value={ShiroWebAutoConfiguration.class})
@EnableConfigurationProperties(value={RedisProperties.class})
@Import(value={JedisConnectionFactoryConfiguration.class, LettuceConnectionFactoryConfiguration.class, RedissonConnectionFactoryConfiguration.class, CompatibleRedisConnectionFactoryConfiguration.class, ShiroExtProperties.class})
public class ShiroCacheAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ShiroCacheAutoConfiguration.class);
    private final ShiroExtProperties properties;
    private final RedisProperties.BatchOptionConfig batchOptions;

    public ShiroCacheAutoConfiguration(ShiroExtProperties properties, RedisProperties auxProperties) {
        this.properties = properties;
        this.batchOptions = auxProperties.getBatchOption();
    }

    @Bean(value={"shiroCacheManager"})
    @ConditionalOnMissingBean
    public CacheManager cacheManager(RedisConnectionFactory connectionFactory) {
        RedisCacheManager cacheManager;
        block2: {
            cacheManager = new RedisCacheManager();
            cacheManager.setConnectionFactory(connectionFactory);
            cacheManager.setKeyPrefix(this.properties.getCacheKeyPrefix());
            cacheManager.setExpiration(this.properties.getCacheExpiration());
            cacheManager.setScanBatchSize(this.batchOptions.getScanBatchSize());
            cacheManager.setFetchBatchSize(this.batchOptions.getFetchBatchSize());
            cacheManager.setDeleteBatchSize(this.batchOptions.getDeleteBatchSize());
            try {
                Optional.ofNullable(this.properties.getDatabase()).ifPresent(arg_0 -> ((RedisCacheManager)cacheManager).setDatabase(arg_0));
            }
            catch (UnsupportedOperationException e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Method::setDatabase(int) of class [ {} ] is considered invalid in CompatibleRedisConnectionFactory instance.", (Object)RedisCacheManager.class.getName());
            }
        }
        return cacheManager;
    }

    @Bean(value={"redisSessionDAO"})
    @ConditionalOnMissingBean
    public SessionDAO sessionDAO(CacheManager cacheManager) {
        RedisSessionDAO sessionDAO = new RedisSessionDAO();
        sessionDAO.setMemoryCacheMaxCapacity(this.properties.getMemoryCacheMaxCapacity());
        sessionDAO.setMemorySessionTtl((int)this.properties.getMemorySessionTtl().toMillis());
        sessionDAO.setUpdateAboveDelayTimeMillis(this.properties.getUpdateAboveDelayTime().toMillis());
        sessionDAO.setCacheManager(cacheManager);
        final String sessionIdPrefix = this.properties.getSessionIdPrefix();
        if (Utils.isNotBlank((CharSequence)sessionIdPrefix)) {
            sessionDAO.setSessionIdPrefix(sessionIdPrefix);
            sessionDAO.setSessionIdGenerator((SessionIdGenerator)new JavaUuidSessionIdGenerator(){

                public Serializable generateId(Session session) {
                    return sessionIdPrefix + super.generateId(session);
                }
            });
        }
        return sessionDAO;
    }
}

