/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.redis.spring.boot.autoconfigure;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroExtProperties {
    @Value(value="#{ @environment['shiro.sessionDAO.memoryCacheMaxCapacity'] ?: 131072 }")
    protected long memoryCacheMaxCapacity;
    @DurationUnit(value=ChronoUnit.MILLIS)
    @Value(value="#{ @environment['shiro.sessionDAO.memorySessionTtl'] ?: 1000 }")
    protected Duration memorySessionTtl;
    @DurationUnit(value=ChronoUnit.MILLIS)
    @Value(value="#{ @environment['shiro.sessionDAO.updateAboveDelayTime'] ?: -1 }")
    protected Duration updateAboveDelayTime;
    @Value(value="#{ @environment['shiro.cache.keyPrefix'] ?: T(org.iherus.shiro.cache.redis.Constant).DEFAULT_CACHE_KEY_PREFIX }")
    protected String cacheKeyPrefix;
    @Value(value="#{ @environment['shiro.cache.expiration'] ?: T(org.iherus.shiro.cache.redis.Constant).DEFAULT_CACHE_EXPIRATION }")
    protected Duration cacheExpiration;
    @Value(value="#{ @environment['shiro.cache.database'] }")
    private Integer database;
    @Value(value="#{ @environment['shiro.sessionIdPrefix'] }")
    private String sessionIdPrefix;

    public long getMemoryCacheMaxCapacity() {
        return this.memoryCacheMaxCapacity;
    }

    public void setMemoryCacheMaxCapacity(long memoryCacheMaxCapacity) {
        this.memoryCacheMaxCapacity = memoryCacheMaxCapacity;
    }

    public Duration getMemorySessionTtl() {
        return this.memorySessionTtl;
    }

    public void setMemorySessionTtl(Duration memorySessionTtl) {
        this.memorySessionTtl = memorySessionTtl;
    }

    public Duration getUpdateAboveDelayTime() {
        return this.updateAboveDelayTime;
    }

    public void setUpdateAboveDelayTime(Duration updateAboveDelayTime) {
        this.updateAboveDelayTime = updateAboveDelayTime;
    }

    public String getCacheKeyPrefix() {
        return this.cacheKeyPrefix;
    }

    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }

    public Duration getCacheExpiration() {
        return this.cacheExpiration;
    }

    public void setCacheExpiration(Duration cacheExpiration) {
        this.cacheExpiration = cacheExpiration;
    }

    public Integer getDatabase() {
        return this.database;
    }

    public void setDatabase(Integer database) {
        this.database = database;
    }

    public String getSessionIdPrefix() {
        return this.sessionIdPrefix;
    }

    public void setSessionIdPrefix(String sessionIdPrefix) {
        this.sessionIdPrefix = sessionIdPrefix;
    }
}

