/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.invocation;

import java.lang.reflect.InvocationTargetException;
import org.ijsberg.iglu.Component;
import org.ijsberg.iglu.Configuration;
import org.ijsberg.iglu.util.misc.StringSupport;

public class CommandLineProcessor {
    private Configuration configuration;

    public CommandLineProcessor(Configuration configuration) {
        this.configuration = configuration;
    }

    public static String[] splitCommandLine(String line) {
        return StringSupport.split((String)line, (String)"()", (String)"").toArray(new String[0]);
    }

    public static String[] splitArguments(String line) {
        return StringSupport.split((String)line, (String)", ", (String)"\"").toArray(new String[0]);
    }

    public static String[] splitCommand(String line) {
        return StringSupport.split((String)line, (String)".", (String)"\"").toArray(new String[0]);
    }

    protected Object processCommandLine(String commandLine) throws IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        String[] commandAndArguments = CommandLineProcessor.splitCommandLine(commandLine);
        String[] moduleAndMethodIds = CommandLineProcessor.splitCommand(commandAndArguments[0]);
        Object[] arguments = commandAndArguments.length > 1 ? CommandLineProcessor.splitArguments(commandAndArguments[1]) : new String[]{};
        if (moduleAndMethodIds.length < 2) {
            throw new IllegalArgumentException("can not process command line: '" + commandLine + "'\nmissing method");
        }
        return this.invoke(moduleAndMethodIds[0], moduleAndMethodIds[1], moduleAndMethodIds[2], arguments);
    }

    protected Object invoke(String clusterId, String moduleId, String methodName, Object ... arguments) throws InvocationTargetException, NoSuchMethodException {
        return ((Component)this.configuration.getClusters().get(clusterId).getInternalComponents().get(moduleId)).invoke(methodName, arguments);
    }
}

