/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.invocation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import org.ijsberg.iglu.Configuration;
import org.ijsberg.iglu.exception.ResourceException;
import org.ijsberg.iglu.invocation.CommandLineProcessor;
import org.ijsberg.iglu.logging.Level;
import org.ijsberg.iglu.logging.LogEntry;
import org.ijsberg.iglu.runtime.Startable;
import org.ijsberg.iglu.util.io.FileSupport;

public class RootConsole
extends CommandLineProcessor
implements Startable,
Runnable {
    private Thread thread;
    private boolean isRunning = false;
    private BufferedReader commandLineInput;
    private String baseDir = ".";
    private String inputFileLocation = "console/input.txt";
    private String outputFileLocation = "console/output.txt";
    private String tempOutputFileLocation = "console/temp_output.txt";

    public RootConsole(Configuration configuration) {
        super(configuration);
    }

    public void setProperties(Properties properties) {
        this.baseDir = properties.getProperty("base_dir", this.baseDir);
        this.inputFileLocation = this.baseDir + '/' + properties.getProperty("input_file_location", this.inputFileLocation);
        this.outputFileLocation = this.baseDir + '/' + properties.getProperty("output_file_location", this.outputFileLocation);
        this.tempOutputFileLocation = this.baseDir + '/' + properties.getProperty("temp_output_file_location", this.tempOutputFileLocation);
    }

    @Override
    public void start() {
        System.out.println(new LogEntry("starting root console"));
        try {
            this.openFileReader();
        }
        catch (IOException ioe) {
            throw new ResourceException("can not open file reader", ioe);
        }
        this.thread = new Thread(this);
        this.isRunning = true;
        this.thread.start();
    }

    @Override
    public boolean isStarted() {
        return this.isRunning;
    }

    @Override
    public void stop() {
        this.isRunning = false;
        this.thread.interrupt();
        try {
            this.closeFileReader();
        }
        catch (IOException ioe) {
            System.out.println(new LogEntry(Level.CRITICAL, "I/O exception while closing file reader: " + ioe.getMessage(), ioe));
        }
    }

    private void openFileReader() throws IOException {
        File inputFile = FileSupport.createFile((String)this.inputFileLocation);
        inputFile.delete();
        inputFile.createNewFile();
        this.commandLineInput = new BufferedReader(new FileReader(inputFile));
    }

    private void resetFileReader() throws IOException {
        this.closeFileReader();
        this.openFileReader();
    }

    private void closeFileReader() throws IOException {
        if (this.commandLineInput != null) {
            this.commandLineInput.close();
        }
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (this.isRunning) {
                    String commandLine = this.commandLineInput.readLine();
                    if (commandLine != null) {
                        this.processCommandLineSafely(commandLine);
                    }
                    try {
                        Thread.sleep(25L);
                        continue block4;
                    }
                    catch (InterruptedException ie) {
                        System.out.println(new LogEntry("console interrupted"));
                        this.isRunning = false;
                    }
                }
                break;
            }
            catch (IOException ioe) {
                System.out.println(new LogEntry(Level.CRITICAL, "console interrupted by I/O exception: " + ioe.getMessage(), ioe));
                this.stop();
                break;
            }
        }
    }

    private void processCommandLineSafely(String commandLine) throws IOException {
        Object result;
        try {
            result = this.processCommandLine(commandLine);
            System.out.println(new LogEntry("command line '" + commandLine + "' successfully processed"));
        }
        catch (Throwable t) {
            result = t;
            System.out.println(new LogEntry(Level.CRITICAL, "console can not process command line '" + commandLine + "'", t));
        }
        this.writeResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResult(Object result) throws IOException {
        File outputFile = new File(this.outputFileLocation);
        File tempfile = FileSupport.createFile((String)this.tempOutputFileLocation);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tempfile);
            PrintStream ps = new PrintStream(new FileOutputStream(tempfile));
            if (result != null) {
                if (result instanceof Throwable) {
                    ((Throwable)result).printStackTrace(ps);
                }
                ps.println(result.toString());
            }
            ps.close();
        }
        finally {
            fos.close();
        }
        if (outputFile.exists()) {
            boolean success = outputFile.delete();
        }
        boolean success = tempfile.renameTo(new File(this.outputFileLocation));
    }
}

