/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.invocation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.ijsberg.iglu.Configuration;
import org.ijsberg.iglu.ConfigurationException;
import org.ijsberg.iglu.invocation.CommandLineProcessor;
import org.ijsberg.iglu.logging.Level;
import org.ijsberg.iglu.logging.LogEntry;

public class SimpleScriptRunner
extends CommandLineProcessor {
    private String script = "\n\n";
    private int pageIntervalInMinutes = 0;
    private int pageOffsetInMinutes = 0;

    public SimpleScriptRunner(Configuration configuration) {
        super(configuration);
    }

    public void runScript() {
        if (this.script.trim().length() > 0) {
            BufferedReader reader = new BufferedReader(new StringReader(this.script));
            try {
                List results = this.runScript(reader);
                System.out.println(new LogEntry(Level.CRITICAL, "completed run of script in device '\" + this.deviceId + \"'\""));
            }
            catch (Throwable t) {
                throw new ConfigurationException("failed to complete run of script", t);
            }
        }
    }

    protected List runScript(BufferedReader reader) throws Throwable {
        String line;
        ArrayList<Object> results = new ArrayList<Object>();
        while ((line = this.readLine(reader)) != null) {
            Object result = this.processCommandLine(line);
            results.add(result);
        }
        return results;
    }

    private String readLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException ioe) {
            throw new ConfigurationException("unable to read line from buffer");
        }
    }

    public void setProperties(Properties properties) {
        this.script = properties.getProperty("script", this.script);
        this.pageIntervalInMinutes = Integer.parseInt(properties.getProperty("page_interval_in_minutes", "" + this.pageIntervalInMinutes));
        this.pageOffsetInMinutes = Integer.parseInt(properties.getProperty("page_offset_in_minutes", "" + this.pageOffsetInMinutes));
    }

    protected void _start() {
    }

    protected void _stop() {
    }

    public int getPageIntervalInMinutes() {
        return this.pageIntervalInMinutes;
    }

    public int getPageOffsetInMinutes() {
        return this.pageOffsetInMinutes;
    }

    public void onPageEvent(long officialTime) {
        this.runScript();
    }
}

