/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.logging;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ijsberg.iglu.logging.Level;

public class LogEntry
implements Serializable {
    private Level level = Level.DEBUG;
    private String message;
    private Serializable data;
    public static String DEFAULT_DATE_FORMAT = "yyyyMMdd HH:mm:ss.SSS";
    private long timeInMillis = System.currentTimeMillis();

    public LogEntry(Throwable data) {
        this.data = data;
        this.message = data.getMessage();
    }

    public LogEntry(String message) {
        this.message = message;
    }

    public LogEntry(String message, Serializable data) {
        this(message);
        this.data = data;
    }

    public LogEntry(Level level, String message) {
        this(message);
        this.level = level;
    }

    public LogEntry(Level level, String message, Serializable data) {
        this(message, data);
        this.level = level;
    }

    public String toString() {
        return this.level.getShortDescription() + " " + new SimpleDateFormat(DEFAULT_DATE_FORMAT).format(new Date(this.timeInMillis)) + (this.message != null ? " " + this.message : "") + (this.data != null ? "\n" + this.data + "\n" : "");
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Serializable getData() {
        return this.data;
    }

    public long getTimeInMillis() {
        return this.timeInMillis;
    }
}

