/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.logging.module;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ijsberg.iglu.logging.Level;
import org.ijsberg.iglu.logging.LogEntry;
import org.ijsberg.iglu.logging.LogPrintStream;
import org.ijsberg.iglu.logging.Logger;
import org.ijsberg.iglu.runtime.Startable;

public class SimpleFileLogger
implements Logger,
Startable {
    private boolean isStarted = false;
    private int logLevelOrdinal = Level.DEBUG.ordinal();
    private String dateFormat = LogEntry.DEFAULT_DATE_FORMAT;
    private int entryOriginStackTraceDepth = 0;
    private PrintStream originalSystemOut = System.out;
    private PrintStream filteredSystemOut = new LogPrintStream((OutputStream)this.originalSystemOut, this);
    private PrintStream logFilePrintStream;

    public SimpleFileLogger(String fileName) throws IOException {
        this.logFilePrintStream = new PrintStream(new FileOutputStream(fileName));
    }

    public SimpleFileLogger(PrintStream logFilePrintStream) throws IOException {
        this.logFilePrintStream = logFilePrintStream;
    }

    @Override
    public void log(LogEntry entry) {
        if (entry.getLevel().ordinal() >= this.logLevelOrdinal) {
            this.writeEntry(entry);
        }
    }

    public void writeEntry(LogEntry entry) {
        this.logFilePrintStream.println(entry.getLevel().getShortDescription() + " " + new SimpleDateFormat(this.dateFormat).format(new Date(entry.getTimeInMillis())) + (entry.getMessage() != null ? " " + entry.getMessage() : ""));
        if (entry.getData() != null) {
            this.logFilePrintStream.println(entry.getData());
            if (entry.getData() instanceof Throwable) {
                this.printStackTrace(((Throwable)entry.getData()).getStackTrace());
            }
        }
        if (this.entryOriginStackTraceDepth > 0) {
            this.printStackTrace(SimpleFileLogger.getStackTracePart(3, this.entryOriginStackTraceDepth));
        }
    }

    private void printStackTrace(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length; ++i) {
            this.logFilePrintStream.println("at " + stackTrace[i]);
        }
    }

    public static StackTraceElement[] getStackTracePart(int start, int desiredLength) {
        StackTraceElement[] fullStackTrace = Thread.currentThread().getStackTrace();
        for (int nrofGetSTCalls = 0; nrofGetSTCalls <= fullStackTrace.length; ++nrofGetSTCalls) {
            if ("java.lang.Thread".equals(fullStackTrace[nrofGetSTCalls].getClassName())) continue;
            return SimpleFileLogger.getStackTracePart(fullStackTrace, start + nrofGetSTCalls, desiredLength);
        }
        throw new RuntimeException("stack trace contains only java.lang.Thread.getStackTrace calls");
    }

    public static StackTraceElement[] getStackTracePart(StackTraceElement[] fullStackTrace, int start, int desiredLength) {
        int actualLength = desiredLength;
        if (fullStackTrace.length - start < desiredLength) {
            actualLength = fullStackTrace.length - start;
        }
        if (actualLength < 0) {
            actualLength = 0;
        }
        StackTraceElement[] desiredStackTrace = new StackTraceElement[actualLength];
        if (actualLength == 0) {
            return desiredStackTrace;
        }
        System.arraycopy(fullStackTrace, start, desiredStackTrace, 0, actualLength);
        return desiredStackTrace;
    }

    public static String formatArray(Object[] array) {
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            retval.append(array[i].toString()).append('\n');
        }
        return retval.toString();
    }

    public void setLogLevel(String name) {
        this.logLevelOrdinal = Level.valueOf(name).ordinal();
    }

    public int getLogLevelOrdinal() {
        return this.logLevelOrdinal;
    }

    @Override
    public synchronized void start() {
        System.setOut(this.filteredSystemOut);
        this.isStarted = true;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setEntryOriginStackTraceDepth(int entryOriginStackTraceDepth) {
        this.entryOriginStackTraceDepth = entryOriginStackTraceDepth;
    }

    @Override
    public synchronized void stop() {
        this.isStarted = false;
        System.setOut(this.originalSystemOut);
    }

    @Override
    public synchronized boolean isStarted() {
        return this.isStarted;
    }
}

