/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.runtime.classloading;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ijsberg.iglu.Cluster;
import org.ijsberg.iglu.logging.LogEntry;
import org.ijsberg.iglu.util.io.FileSupport;
import org.ijsberg.iglu.util.io.StreamSupport;
import org.ijsberg.iglu.util.misc.StringSupport;

public class FlexibleClassLoader
extends URLClassLoader {
    private TreeMap classResourceLocations = new TreeMap();
    private HashMap propertiesResourceLocations = new HashMap(10);
    private TreeMap mixedResourceLocations = new TreeMap();
    private String classpath = "./classes:./lib";
    private String enterpriseInterfacePackageName = Cluster.class.getPackage().getName();
    private HashMap fileCreationTimes = new HashMap(10);
    private int nrofResourcesDeleted;
    private int nrofResourcesUpdated;

    public FlexibleClassLoader(String classpath) {
        super(new URL[0]);
        this.classpath = classpath;
        this.init();
    }

    private void init() {
        List paths = StringSupport.split((String)this.classpath, (String)";:", (boolean)false);
        for (String location : paths) {
            if (location.endsWith(".zip") || location.endsWith(".jar")) {
                this.mapFilesInZip(location);
                continue;
            }
            File dir = new File(location);
            if (!dir.isDirectory()) continue;
            if (!location.endsWith("/")) {
                location = location + '/';
            }
            ArrayList classFiles = FileSupport.getFilesInDirectoryTree((File)dir);
            for (File file : classFiles) {
                String fileName = file.getPath();
                if ((fileName.endsWith(".jar") || fileName.endsWith(".zip")) && !file.isHidden()) {
                    this.mapFilesInZip(fileName);
                    continue;
                }
                this.mapClassResourceEntry(file.getPath().substring(location.length()), file);
                this.fileCreationTimes.put(file, new Long(file.lastModified()));
            }
        }
    }

    private static String convertFileNameToClassName(String fileName) {
        String className = fileName;
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex >= 0) {
            className = className.substring(0, dotIndex);
        }
        className = className.replace('/', '.');
        className = className.replace('\\', '.');
        return className;
    }

    private void mapFilesInZip(String fileName) {
        ZipFile zipfile;
        File file = new File(fileName);
        this.fileCreationTimes.put(file, new Long(file.lastModified()));
        try {
            zipfile = new ZipFile(fileName);
        }
        catch (IOException ioe) {
            throw new NoClassDefFoundError("class location '" + fileName + "' can not be accessed by classloader: " + ioe);
        }
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            this.mapClassResourceEntry(entry.getName(), fileName);
        }
        try {
            zipfile.close();
        }
        catch (IOException ioe) {
            throw new NoClassDefFoundError("class fileName '" + fileName + "' can not be accessed by classloader: " + ioe);
        }
    }

    private void mapClassResourceEntry(String fileName, Object value) {
        Object existingValue = this.mixedResourceLocations.get(fileName);
        if (!(existingValue == null || existingValue.equals(value) || fileName.startsWith("META-INF/") || FlexibleClassLoader.resourcesMatchInSize(fileName, existingValue, value))) {
            System.out.println(new LogEntry("WARNING: " + this.getClass().getName() + " found multiple locations for resource '" + fileName + "' ('" + existingValue + "' and '" + value + "')"));
        }
        if (fileName.endsWith(".properties")) {
            String className = FlexibleClassLoader.convertFileNameToClassName(fileName);
            this.propertiesResourceLocations.put(className, fileName);
        } else if (fileName.endsWith(".class")) {
            String className = FlexibleClassLoader.convertFileNameToClassName(fileName);
            this.classResourceLocations.put(className, value);
        }
        this.mixedResourceLocations.put(fileName, value);
    }

    public synchronized Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> retval = super.findLoadedClass(className);
        if (retval == null) {
            try {
                retval = this.findClass(className);
                if (resolve) {
                    this.resolveClass(retval);
                }
                return retval;
            }
            catch (ClassNotFoundException e) {
                retval = super.loadClass(className, true);
            }
        }
        return retval;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        byte[] data;
        Object location = this.classResourceLocations.get(className);
        if (location == null && this.propertiesResourceLocations.containsKey(className)) {
            String fileName = (String)this.propertiesResourceLocations.get(className);
            if (fileName.endsWith(".properties")) {
                return ResourceBundle.class;
            }
            throw new ClassNotFoundException("resource '" + fileName + "' for class '" + className + "' has incompatible format");
        }
        if (location == null) {
            throw new ClassNotFoundException("class '" + className + "' not found in " + this.classpath);
        }
        String fileName = className.replace('.', '/') + ".class";
        try {
            data = FlexibleClassLoader.getData(fileName, location);
        }
        catch (IOException ioe) {
            throw new NoClassDefFoundError("class '" + className + "' could not be loaded from '" + location + "' with message: " + ioe);
        }
        return this.defineClass(className, data, 0, data.length);
    }

    private static boolean resourcesMatchInSize(String filename, Object location1, Object location2) {
        return FlexibleClassLoader.getFileSize(filename, location1) == FlexibleClassLoader.getFileSize(filename, location2);
    }

    private static long getFileSize(String filename, Object location) {
        if (location instanceof File) {
            return ((File)location).length();
        }
        try {
            ZipEntry entry = FileSupport.getZipEntryFromJar((String)filename, (String)((String)location));
            return entry.getSize();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    private static byte[] getData(String fileName, Object location) throws IOException {
        byte[] data;
        if (location instanceof String) {
            data = FileSupport.getBinaryFromJar((String)fileName, (String)((String)location));
        } else if (location instanceof File) {
            FileInputStream in = new FileInputStream((File)location);
            data = StreamSupport.absorbInputStream((InputStream)in);
            ((InputStream)in).close();
        } else {
            throw new NoClassDefFoundError("file '" + fileName + "' could not be loaded from '" + location + '\'');
        }
        return data;
    }

    @Override
    public InputStream getResourceAsStream(String fileName) {
        InputStream retval = super.getResourceAsStream(fileName);
        if (retval == null) {
            byte[] data;
            Object location = this.mixedResourceLocations.get(fileName);
            if (location == null) {
                return null;
            }
            try {
                data = FlexibleClassLoader.getData(fileName, location);
            }
            catch (IOException ioe) {
                return null;
            }
            if (data == null) {
                return null;
            }
            return new ByteArrayInputStream(data);
        }
        return retval;
    }

    public int getNrofResourcesDeleted() {
        return this.nrofResourcesDeleted;
    }

    public int getNrofResourcesUpdated() {
        return this.nrofResourcesUpdated;
    }

    public synchronized boolean checkResources() {
        this.nrofResourcesDeleted = 0;
        this.nrofResourcesUpdated = 0;
        for (File file : this.fileCreationTimes.keySet()) {
            if (!file.exists()) {
                ++this.nrofResourcesDeleted;
                continue;
            }
            if (file.lastModified() == ((Long)this.fileCreationTimes.get(file)).longValue()) continue;
            ++this.nrofResourcesUpdated;
        }
        return this.nrofResourcesDeleted > 0 || this.nrofResourcesUpdated > 0;
    }
}

