/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.runtime.module;

import java.util.HashSet;
import java.util.Set;
import org.ijsberg.iglu.logging.LogEntry;
import org.ijsberg.iglu.runtime.Startable;

public class ModuleStarter
implements Startable {
    protected boolean isStarted = false;
    protected Set<Startable> registeredStartables = new HashSet<Startable>();

    public synchronized void register(Startable startable) {
        System.out.println(new LogEntry("registering " + startable + " with " + this));
        if (this.isStarted && !startable.isStarted()) {
            startable.start();
        }
        this.registeredStartables.add(startable);
    }

    public synchronized void unregister(Startable startable) {
        this.registeredStartables.remove(startable);
    }

    @Override
    public synchronized void start() {
        if (!this.isStarted) {
            this.isStarted = true;
            try {
                for (Startable startable : this.registeredStartables) {
                    if (startable.isStarted()) continue;
                    startable.start();
                }
            }
            catch (Exception e) {
                this.isStarted = false;
            }
        }
    }

    @Override
    public synchronized boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public synchronized void stop() {
        this.isStarted = false;
        Startable[] startables = this.registeredStartables.toArray(new Startable[0]);
        for (int i = startables.length - 1; i >= 0; --i) {
            if (!startables[i].isStarted()) continue;
            startables[i].stop();
        }
    }
}

