/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.runtime.module;

import org.ijsberg.iglu.logging.LogEntry;
import org.ijsberg.iglu.runtime.module.ModuleStarter;

public class ServerEnvironment
extends ModuleStarter
implements Runnable {
    private Thread shutdownHook = new Thread(new ShutdownProcess());
    private boolean isRunning;

    public ServerEnvironment() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    @Override
    public synchronized void start() {
        super.start();
        if (!this.isRunning) {
            new Thread(this).start();
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.isRunning = false;
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                Thread.sleep(333L);
            }
            catch (InterruptedException e) {
                if (!this.isStarted) continue;
                System.out.println(new LogEntry("Keep-alive thread interrupted..."));
                this.stop();
            }
        }
    }

    private class ShutdownProcess
    implements Runnable {
        private ShutdownProcess() {
        }

        @Override
        public void run() {
            System.out.println(new LogEntry("starting " + (ServerEnvironment.this.isRunning ? "forced" : "") + " application shutdown process..."));
            if (ServerEnvironment.this.isStarted) {
                try {
                    ServerEnvironment.this.stop();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            System.out.println(new LogEntry("Application shutdown process completed..."));
        }
    }
}

