/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.server.connection.invocation;

import org.ijsberg.iglu.Configuration;
import org.ijsberg.iglu.invocation.CommandLineProcessor;
import org.ijsberg.iglu.server.connection.CommandLineClientAdapter;
import org.ijsberg.iglu.server.connection.CommandLineInterpreter;
import org.ijsberg.iglu.util.formatting.PatternMatchingSupport;
import org.ijsberg.iglu.util.misc.StringSupport;

public class CommandLineConfigurationInvoker
extends CommandLineProcessor
implements CommandLineInterpreter {
    public static final String CSV_PATTERN = "(|([0-9]+|\".*[^\"]\")(,[0-9]+|,\".*[^\"]\")*)";
    public static final String CL_PATTERN = "[A-Za-z_][A-Za-z0-9_]*\\((|([0-9]+|\".*[^\"]\")(,[0-9]+|,\".*[^\"]\")*)\\)";
    private CommandLineClientAdapter adapter;

    static boolean isCommand(String line) {
        return PatternMatchingSupport.valueMatchesRegularExpression((String)line, (String)CL_PATTERN);
    }

    static boolean isCSVArray(String line) {
        return PatternMatchingSupport.valueMatchesRegularExpression((String)line, (String)CSV_PATTERN);
    }

    public CommandLineConfigurationInvoker(Configuration configuration) {
        super(configuration);
    }

    @Override
    public void initiateSession(CommandLineClientAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public void onAdapterTermination(String string) {
    }

    @Override
    public void processRawInput(byte[] bytes) {
    }

    @Override
    public String processCommandLine(String commandLine) {
        StringBuffer response = new StringBuffer();
        try {
            response.append(super.processCommandLine(commandLine));
        }
        catch (Throwable t) {
            response.append(StringSupport.getStackTrace((Throwable)t, (int)5) + "\n");
        }
        return response.toString();
    }

    @Override
    public void abortSubProcessMode() {
    }

    @Override
    public boolean isInSubProcessMode() {
        return false;
    }

    @Override
    public String completeCommand(String unfinishedCommand) {
        return null;
    }

    @Override
    public synchronized void sendMessage(String message) {
        this.adapter.send(message);
    }

    @Override
    public void terminate() {
        this.adapter.terminateSession();
    }
}

