/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.server.connection.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ijsberg.iglu.invocation.CommandLineProcessor;
import org.ijsberg.iglu.server.connection.ClientSessionAware;
import org.ijsberg.iglu.server.connection.CommandLineClientAdapter;
import org.ijsberg.iglu.server.connection.CommandLineInterpreter;
import org.ijsberg.iglu.util.misc.StringSupport;
import org.ijsberg.iglu.util.reflection.ReflectionSupport;

public class CommandLineObjectInvoker
implements CommandLineInterpreter {
    private Object invokable;
    private CommandLineClientAdapter adapter;

    public CommandLineObjectInvoker(Object invokable) {
        this.invokable = invokable;
    }

    @Override
    public void initiateSession(CommandLineClientAdapter adapter) {
        this.adapter = adapter;
        if (this.invokable instanceof ClientSessionAware) {
            ((ClientSessionAware)this.invokable).setSession(this);
        }
        adapter.send("Welcome. You may invoke public methods on " + this.invokable.toString() + ".\n\r>");
    }

    @Override
    public void onAdapterTermination(String message) {
    }

    @Override
    public void processRawInput(byte[] rawInput) {
    }

    @Override
    public String processCommandLine(String commandLine) {
        String response = "";
        if (!"".equals(commandLine)) {
            try {
                Object returnValue = this.executeCommandLine(commandLine);
                response = (returnValue != null ? returnValue : "ok") + "\r\n";
            }
            catch (NoSuchMethodException e) {
                response = "no such method\r\n";
            }
            catch (Exception e) {
                response = StringSupport.getStackTrace((Throwable)e) + "\r\n";
            }
        }
        return response + ">";
    }

    private Object executeCommandLine(String commandLine) throws NoSuchMethodException, InvocationTargetException {
        String[] commandAndArguments = CommandLineProcessor.splitCommandLine(commandLine);
        String command = commandAndArguments[0];
        Object[] arguments = commandAndArguments.length > 1 ? CommandLineProcessor.splitArguments(commandAndArguments[1]) : new String[]{};
        return ReflectionSupport.invokeMethod((Object)this.invokable, (String)command, (Object[])arguments);
    }

    @Override
    public void abortSubProcessMode() {
    }

    @Override
    public boolean isInSubProcessMode() {
        return false;
    }

    @Override
    public String completeCommand(String unfinishedCommand) {
        Method[] invokableMethods = this.invokable.getClass().getMethods();
        for (int i = 0; i < invokableMethods.length; ++i) {
            if (!invokableMethods[i].getName().startsWith(unfinishedCommand)) continue;
            return invokableMethods[i].getName() + "(";
        }
        return unfinishedCommand;
    }

    @Override
    public void sendMessage(String message) {
        this.adapter.send(message);
    }

    @Override
    public void terminate() {
        this.adapter.terminateSession();
    }
}

