/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.server.connection.socket;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.ijsberg.iglu.logging.Level;
import org.ijsberg.iglu.logging.LogEntry;
import org.ijsberg.iglu.server.connection.CommandLineClientAdapter;
import org.ijsberg.iglu.server.connection.CommandLineInterpreter;
import org.ijsberg.iglu.server.connection.Connection;

public class ByteStreamReadingConnection
implements Connection,
Runnable {
    private DataInputStream is;
    private OutputStream os;
    private Socket socket;
    private String closeMessage;
    private Thread t;
    private int timeout;
    private long lastUpdate = System.currentTimeMillis();
    private CommandLineClientAdapter adapter;
    private CommandLineInterpreter interpreter;

    public ByteStreamReadingConnection(Socket socket, CommandLineClientAdapter adapter, CommandLineInterpreter interpreter, int timeout) throws IOException {
        this.socket = socket;
        this.adapter = adapter;
        this.interpreter = interpreter;
        this.timeout = timeout;
        this.is = new DataInputStream(socket.getInputStream());
        this.os = socket.getOutputStream();
        this.t = new Thread(this);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.adapter.initiateSession(this, this.os, this.interpreter);
            while (this.processingIncomingBytes()) {
            }
        }
        catch (InterruptedException ie) {
            this.adapter.onConnectionClose(this.closeMessage);
        }
        catch (IOException ioe) {
            System.out.println(new LogEntry("", ioe));
        }
        finally {
            try {
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (IOException ioe) {
                System.out.println(new LogEntry(Level.CRITICAL, "unable to close connection", ioe));
            }
        }
    }

    private boolean processingIncomingBytes() throws IOException, InterruptedException {
        int avail = this.is.available();
        if (avail > 0) {
            this.lastUpdate = System.currentTimeMillis();
            byte[] bytes = new byte[avail];
            this.is.read(bytes, 0, avail);
            this.adapter.receive(bytes);
        } else {
            Thread.sleep(25L);
        }
        if (this.timeout > 0 && System.currentTimeMillis() - this.lastUpdate > (long)(this.timeout * 1000)) {
            this.close("connection timed out after " + this.timeout + " seconds");
            return false;
        }
        return true;
    }

    public void send(byte[] message) {
        try {
            this.os.write(message);
        }
        catch (IOException ioe) {
            System.out.println(new LogEntry("closing connection to " + this.socket.getInetAddress() + " due to IO exception " + ioe.getMessage(), ioe));
            this.close("closing connection to due to IO exception");
        }
    }

    @Override
    public void close(String message) {
        this.closeMessage = message;
        this.close();
    }

    @Override
    public void close() {
        this.t.interrupt();
        try {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException ioe) {
            System.out.println(new LogEntry(Level.CRITICAL, "IOException occurred while closing connection to " + this.socket.getInetAddress() + " with message: " + ioe.getMessage(), ioe));
        }
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }
}

