/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.server.connection.socket.module;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.ijsberg.iglu.ConfigurationException;
import org.ijsberg.iglu.logging.Level;
import org.ijsberg.iglu.logging.LogEntry;
import org.ijsberg.iglu.runtime.Startable;
import org.ijsberg.iglu.server.connection.Connection;
import org.ijsberg.iglu.server.connection.ConnectionFactory;
import org.ijsberg.iglu.server.connection.socket.SocketServer;
import org.ijsberg.iglu.util.collection.CollectionSupport;
import org.ijsberg.iglu.util.types.Converter;

public class StandardSocketServer
implements Runnable,
SocketServer,
Startable {
    private Thread serverThread;
    private ServerSocket server;
    private ConnectionFactory connectionFactory;
    private final HashSet<Connection> connectedClients = new HashSet();
    private int port = 17623;
    private boolean keepAlive;
    private int soTimeout;
    private int timeout = 900;
    private boolean soLingerActive;
    private int soLingerTime = 10;

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getReport() {
        StringBuffer sb = new StringBuffer("Connected clients:\n");
        if (this.connectedClients.isEmpty()) {
            sb.append("none...");
        } else {
            sb.append(CollectionSupport.format(new ArrayList<Connection>(this.connectedClients), (String)"\n"));
        }
        return sb.toString();
    }

    @Override
    public void start() throws ConfigurationException {
        if (this.connectionFactory == null) {
            throw new ConfigurationException("can not start without client socket factory");
        }
        try {
            this.server = new ServerSocket(this.port);
        }
        catch (IOException e) {
            System.out.println(new LogEntry(e.getMessage(), e));
            throw new ConfigurationException("Cannot start server at port " + this.port, (Throwable)e);
        }
        this.serverThread = new Thread(this);
        this.serverThread.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket socket = this.server.accept();
                System.out.println(new LogEntry("client (" + socket.getInetAddress().getHostAddress() + ") attempts to connect..."));
                Connection c = this.establishConnection(socket);
                this.updateConnectedClients(c);
            }
        }
        catch (IOException ioe) {
            System.out.println(new LogEntry("server forced to stop with message " + ioe.getClass().getName() + ' ' + ioe.getMessage()));
        }
        catch (Throwable t) {
            System.out.println(new LogEntry(Level.CRITICAL, "server forced to stop with message " + t.getClass().getName() + ' ' + t.getMessage(), t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnectedClients(Connection c) {
        HashSet<Connection> hashSet = this.connectedClients;
        synchronized (hashSet) {
            this.connectedClients.add(c);
            for (Connection client : new HashSet<Connection>(this.connectedClients)) {
                if (!client.isClosed()) continue;
                this.connectedClients.remove(client);
            }
        }
    }

    private Connection establishConnection(Socket socket) throws IOException {
        socket.setSoLinger(this.soLingerActive, this.soLingerTime);
        socket.setSoTimeout(this.soTimeout);
        socket.setKeepAlive(this.keepAlive);
        Connection c = this.connectionFactory.createConnection(socket);
        System.out.println(new LogEntry("client connection established"));
        return c;
    }

    @Override
    public boolean isStarted() {
        return this.serverThread != null;
    }

    @Override
    public void stop() {
        if (this.serverThread != null) {
            try {
                this.server.close();
            }
            catch (IOException ioe) {
                System.out.println(new LogEntry(Level.CRITICAL, ioe.getMessage(), ioe));
            }
        }
        for (Connection client : new HashSet<Connection>(this.connectedClients)) {
            if (client.isClosed()) continue;
            client.close("server shut down...");
        }
    }

    public void setProperties(Properties properties) throws ConfigurationException {
        this.port = Converter.convertToInteger((Object)properties.getProperty("port", "" + this.port));
        this.keepAlive = Converter.convertToBoolean((Object)properties.getProperty("keep_alive", "" + this.keepAlive));
        this.soTimeout = Converter.convertToInteger((Object)properties.getProperty("so_timeout", "" + this.soTimeout));
        this.timeout = Converter.convertToInteger((Object)properties.getProperty("timeout", "" + this.timeout));
        this.soLingerActive = Converter.convertToBoolean((Object)properties.getProperty("so_linger_active", "" + this.soLingerActive));
        this.soLingerTime = Converter.convertToInteger((Object)properties.getProperty("so_linger_time", "" + this.soLingerTime));
    }
}

