/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.server.telnet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.ijsberg.iglu.logging.Level;
import org.ijsberg.iglu.logging.LogEntry;
import org.ijsberg.iglu.server.connection.CommandLineClientAdapter;
import org.ijsberg.iglu.server.connection.CommandLineInterpreter;
import org.ijsberg.iglu.server.connection.Connection;

public class TelnetAdapter
implements CommandLineClientAdapter {
    private OutputStream os;
    private PrintStream ps;
    private ByteArrayOutputStream commandLineBuffer;
    private byte[] controlCharBuffer = new byte[4];
    private boolean echoEnabled = true;
    private CommandLineInterpreter interpreter;
    private boolean adapterTerminating = false;
    public static final byte CTRLC = 3;
    public static final byte BEL = 7;
    public static final byte BACK = 8;
    public static final byte TAB = 9;
    public static final byte NEWLINE = 10;
    public static final byte RETURN = 13;
    public static final byte ESC = 27;
    public static final byte DEL = 127;
    public static final byte IAC = -1;
    public static final byte[] UP = new byte[]{27, 91, 65, 0};
    public static final byte[] DOWN = new byte[]{27, 91, 66, 0};
    public static final byte[] RIGHT = new byte[]{27, 91, 67, 0};
    public static final byte[] LEFT = new byte[]{27, 91, 68, 0};
    public static final byte[] HOME = new byte[]{27, 91, 49, 126};
    public static final byte[] INSERT = new byte[]{27, 91, 50, 126};
    public static final byte[] DELETE = new byte[]{27, 91, 51, 126};
    public static final byte[] END = new byte[]{27, 91, 52, 126};
    public static final byte[] PGUP = new byte[]{27, 91, 53, 126};
    public static final byte[] PGDOWN = new byte[]{27, 91, 54, 126};
    private int HISTORY_SIZE = 25;
    private int controlCharIndex;
    private boolean controlCharCaptureMode;
    private String promptStr = "";
    private int historyIndex;
    private ArrayList history = new ArrayList(10);
    private int curPos;
    private Connection connection;

    @Override
    public void initiateSession(Connection connection, OutputStream os, CommandLineInterpreter interpreter) throws IOException {
        this.connection = connection;
        this.interpreter = interpreter;
        this.os = os;
        this.ps = new PrintStream(os);
        this.commandLineBuffer = new ByteArrayOutputStream();
        os.write(new byte[]{-1, -5, 1, -1, -5, 3});
        interpreter.initiateSession(this);
    }

    @Override
    public void receive(byte[] byteArray) throws IOException {
        if (this.interpreter.isInSubProcessMode()) {
            if (!this.abortSubprocessModeIfNecessary(byteArray)) {
                if (this.echoEnabled) {
                    this.echoBytesToClient(byteArray);
                }
                this.interpreter.processRawInput(byteArray);
            }
        } else {
            this.processInput(byteArray);
        }
    }

    private boolean abortSubprocessModeIfNecessary(byte[] rawInput) {
        for (int i = 0; i < rawInput.length; ++i) {
            if (rawInput[i] != 3) continue;
            this.interpreter.abortSubProcessMode();
            return true;
        }
        return false;
    }

    private void processInput(byte[] byteArray) throws IOException {
        for (int i = 0; i < byteArray.length; ++i) {
            byte b2 = byteArray[i];
            if (!this.controlCharCaptureMode) {
                this.processCommandlineCharacter(b2);
                continue;
            }
            this.processControlCharacter(b2);
        }
    }

    private void processCommandlineCharacter(byte b2) throws IOException {
        switch (b2) {
            case 27: {
                this.switchToControlCharCaptureMode(b2);
                break;
            }
            case -1: {
                this.switchToControlCharCaptureMode(b2);
                break;
            }
            case 9: {
                this.replaceCommandLine(this.interpreter.completeCommand(this.commandLineBuffer.toString()));
                this.curPos = this.commandLineBuffer.size();
                break;
            }
            case 13: {
                this.handleReturn();
                break;
            }
            case 8: {
                this.handleBackKey();
                break;
            }
            case 127: {
                this.handleBackKey();
                break;
            }
            default: {
                if (b2 <= 31) break;
                this.processPrintableCharacter(b2);
            }
        }
    }

    private void handleReturn() throws IOException {
        String result;
        this.ps.write(new byte[]{13, 10});
        String line = this.commandLineBuffer.toString();
        if (this.echoEnabled && !"".equals(line)) {
            this.storeCommandlineInHistory(line);
            this.curPos = 0;
        }
        try {
            result = this.interpreter.processCommandLine(line).replaceAll("\n", "\r\n");
        }
        catch (Exception e) {
            result = "command line could not be interpreted due to exception " + e.getClass().getName() + (e.getMessage() != null ? " with message " + e.getMessage() : "");
        }
        if (result != null && result.length() > 0) {
            this.ps.print(result);
            char prompt = result.charAt(result.length() - 1);
            this.promptStr = result;
            if (prompt == '\r' || prompt == '\n') {
                this.promptStr = "";
            } else if (result.indexOf(13) != -1) {
                this.promptStr = result.substring(result.lastIndexOf(13) + 2);
            }
        }
        this.commandLineBuffer.reset();
    }

    private void storeCommandlineInHistory(String line) {
        this.history.remove("");
        if (this.history.contains(line)) {
            this.history.remove(line);
        }
        if (this.history.size() >= this.HISTORY_SIZE) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(0, line);
        this.history.add(0, "");
        this.historyIndex = 0;
    }

    private void switchToControlCharCaptureMode(byte b2) {
        this.controlCharCaptureMode = true;
        this.controlCharBuffer[0] = b2;
        this.controlCharIndex = 1;
    }

    private void processPrintableCharacter(byte b2) {
        if (this.echoEnabled) {
            this.ps.write(b2);
        }
        if (this.curPos < this.commandLineBuffer.size()) {
            this.insertCharacterInCommandlineBuffer(b2);
        } else {
            this.commandLineBuffer.write(b2);
            ++this.curPos;
        }
    }

    private void insertCharacterInCommandlineBuffer(byte b2) {
        int x;
        String curLine = this.commandLineBuffer.toString();
        this.commandLineBuffer.reset();
        for (x = 0; x < curLine.length(); ++x) {
            if (x == this.curPos) {
                this.commandLineBuffer.write(b2);
            }
            this.commandLineBuffer.write(curLine.charAt(x));
            if (x < this.curPos || !this.echoEnabled) continue;
            this.ps.write(curLine.charAt(x));
        }
        for (x = this.curPos; x < curLine.length(); ++x) {
            if (!this.echoEnabled) continue;
            this.ps.write(8);
        }
        ++this.curPos;
    }

    private void processControlCharacter(byte b2) throws IOException {
        this.controlCharBuffer[this.controlCharIndex++] = b2;
        if (this.controlCharIndex == 3 && this.controlCharBuffer[0] == -1) {
            this.disableControlCharCaptureMode();
        } else if (this.controlCharIndex == 3 && b2 > 64 || this.controlCharIndex == 4) {
            this.handleControlCharSequence();
        }
    }

    private void handleControlCharSequence() throws IOException {
        String controlStr = new String(this.controlCharBuffer);
        if (controlStr.equals(new String(UP)) && this.history.size() > 1 && this.echoEnabled) {
            this.showNextCommandlineFromHistory();
        } else if (controlStr.equals(new String(DOWN)) && this.history.size() > 1 && this.echoEnabled) {
            this.showPreviousCommandlineFromHistory();
        } else if (controlStr.equals(new String(LEFT)) && this.echoEnabled) {
            this.moveCursorToLeft();
        } else if (controlStr.equals(new String(RIGHT)) && this.echoEnabled) {
            this.moveCursorToRight();
        } else if (controlStr.equals(new String(HOME)) && this.echoEnabled) {
            this.moveCursorToLineStart();
        } else if (controlStr.equals(new String(END)) && this.echoEnabled) {
            this.moveCursorToLineEnd();
        } else if (controlStr.equals(new String(DELETE)) && this.echoEnabled) {
            this.handleDeleteKey();
        } else if (!controlStr.equals(new String(PGUP)) || this.echoEnabled) {
            // empty if block
        }
        this.disableControlCharCaptureMode();
    }

    private void moveCursorToLineEnd() {
        byte[] clbuf = this.commandLineBuffer.toByteArray();
        for (int x = this.curPos; x < this.commandLineBuffer.size(); ++x) {
            this.ps.write(clbuf[x]);
        }
        this.curPos = this.commandLineBuffer.size();
    }

    private void moveCursorToLineStart() {
        for (int x = this.curPos; x > 0; --x) {
            this.ps.write(8);
        }
        this.curPos = 0;
    }

    private void moveCursorToRight() {
        if (this.curPos < this.commandLineBuffer.size()) {
            this.ps.write(this.commandLineBuffer.toByteArray()[this.curPos]);
            ++this.curPos;
        }
    }

    private void moveCursorToLeft() {
        if (this.curPos > 0) {
            --this.curPos;
            this.ps.write(8);
        }
    }

    private void showPreviousCommandlineFromHistory() {
        if (this.historyIndex > 0) {
            --this.historyIndex;
        }
        this.replaceCommandLine((String)this.history.get(this.historyIndex));
        this.curPos = this.commandLineBuffer.size();
    }

    private void showNextCommandlineFromHistory() {
        if (this.historyIndex < this.history.size() - 1) {
            ++this.historyIndex;
        }
        this.replaceCommandLine((String)this.history.get(this.historyIndex));
        this.curPos = this.commandLineBuffer.size();
    }

    private void disableControlCharCaptureMode() {
        this.controlCharCaptureMode = false;
        this.controlCharIndex = 0;
        this.controlCharBuffer[3] = 0;
    }

    private void echoBytesToClient(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            this.ps.write(b[i]);
        }
    }

    private void replaceCommandLine(String replacement) {
        int currentCLSize = this.commandLineBuffer.size();
        this.commandLineBuffer = new ByteArrayOutputStream();
        for (int x = 0; x < replacement.length(); ++x) {
            this.commandLineBuffer.write(replacement.charAt(x));
        }
        String replaceString = '\r' + this.promptStr;
        for (int x = 0; x <= currentCLSize; ++x) {
            replaceString = replaceString + ' ';
        }
        replaceString = replaceString + '\r' + this.promptStr + replacement;
        this.ps.print(replaceString);
    }

    @Override
    public void disableEcho() {
        this.echoEnabled = false;
    }

    @Override
    public void enableEcho() {
        this.echoEnabled = true;
    }

    @Override
    public synchronized void send(String message) {
        this.ps.print(message);
    }

    @Override
    public void send(byte[] message) {
        try {
            this.ps.write(message);
        }
        catch (IOException ioe) {
            System.out.println(new LogEntry(Level.CRITICAL, "IO exception occurred while writing to client", ioe));
            this.connection.close("IO exception occurred while writing to client");
        }
    }

    @Override
    public void beep() {
        try {
            this.os.write(7);
        }
        catch (IOException ioe) {
            System.out.println(new LogEntry(Level.CRITICAL, "IO exception occurred while writing to client", ioe));
            this.connection.close("IO exception occurred while writing to client");
        }
    }

    @Override
    public void onConnectionClose(String message) {
        this.interpreter.onAdapterTermination(message);
    }

    @Override
    public void terminateSession() {
        this.connection.close();
    }

    private void handleBackKey() throws IOException {
        if (this.commandLineBuffer.size() > 0 && this.curPos > 0) {
            if (this.echoEnabled) {
                this.ps.write(8);
            }
            String curLine = this.overwriteCommandlineSkippingChar(this.curPos - 1);
            this.eraseLastCharAndMoveBack(curLine, this.curPos);
            --this.curPos;
        }
    }

    private void handleDeleteKey() throws IOException {
        if (this.commandLineBuffer.size() > 0 && this.curPos < this.commandLineBuffer.size()) {
            String curLine = this.overwriteCommandlineSkippingChar(this.curPos);
            this.eraseLastCharAndMoveBack(curLine, this.curPos + 1);
        }
    }

    private void eraseLastCharAndMoveBack(String curLine, int curPos) throws IOException {
        if (this.echoEnabled) {
            this.ps.write(new byte[]{32, 8});
            for (int x = curPos; x < curLine.length(); ++x) {
                this.ps.write(8);
            }
        }
    }

    private String overwriteCommandlineSkippingChar(int curPos) {
        String curLine = this.commandLineBuffer.toString();
        this.commandLineBuffer.reset();
        int len = curLine.length() - 1;
        for (int x = 0; x < len; ++x) {
            if (x == curPos) {
                ++x;
                ++len;
            }
            this.commandLineBuffer.write(curLine.charAt(x));
            if (x < curPos || !this.echoEnabled) continue;
            this.ps.write(curLine.charAt(x));
        }
        return curLine;
    }
}

