/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.ikasan.configurationService.service.ConfiguredResourceConfigurationService;
import org.ikasan.error.reporting.service.ErrorReportingServiceDefaultImpl;
import org.ikasan.error.reporting.service.ErrorReportingServiceFactoryDefaultImpl;
import org.ikasan.exceptionResolver.ExceptionResolver;
import org.ikasan.exclusion.service.ExclusionServiceFactory;
import org.ikasan.flow.event.DefaultReplicationFactory;
import org.ikasan.flow.event.FlowEventFactory;
import org.ikasan.flow.visitorPattern.DefaultExclusionFlowConfiguration;
import org.ikasan.flow.visitorPattern.DefaultFlowConfiguration;
import org.ikasan.flow.visitorPattern.ExclusionFlowConfiguration;
import org.ikasan.flow.visitorPattern.FlowElementImpl;
import org.ikasan.flow.visitorPattern.VisitingInvokerFlow;
import org.ikasan.flow.visitorPattern.invoker.BrokerFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.ConsumerFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.ConverterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.MultiRecipientRouterConfiguration;
import org.ikasan.flow.visitorPattern.invoker.MultiRecipientRouterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.ProducerFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.SequencerFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.SingleRecipientRouterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.TranslatorFlowElementInvoker;
import org.ikasan.recovery.RecoveryManagerFactory;
import org.ikasan.spec.component.endpoint.Broker;
import org.ikasan.spec.component.endpoint.Consumer;
import org.ikasan.spec.component.endpoint.Producer;
import org.ikasan.spec.component.routing.MultiRecipientRouter;
import org.ikasan.spec.component.routing.Router;
import org.ikasan.spec.component.routing.SingleRecipientRouter;
import org.ikasan.spec.component.sequencing.Sequencer;
import org.ikasan.spec.component.transformation.Converter;
import org.ikasan.spec.component.transformation.Translator;
import org.ikasan.spec.configuration.ConfigurationService;
import org.ikasan.spec.error.reporting.ErrorReportingService;
import org.ikasan.spec.error.reporting.ErrorReportingServiceFactory;
import org.ikasan.spec.error.reporting.IsErrorReportingServiceAware;
import org.ikasan.spec.event.EventFactory;
import org.ikasan.spec.exclusion.ExclusionService;
import org.ikasan.spec.flow.Flow;
import org.ikasan.spec.flow.FlowConfiguration;
import org.ikasan.spec.flow.FlowElement;
import org.ikasan.spec.flow.FlowElementInvoker;
import org.ikasan.spec.flow.FlowEventListener;
import org.ikasan.spec.monitor.Monitor;
import org.ikasan.spec.monitor.MonitorSubject;
import org.ikasan.spec.recovery.RecoveryManager;
import org.ikasan.spec.resubmission.ResubmissionService;
import org.ikasan.spec.serialiser.SerialiserFactory;

public class FlowBuilder {
    private static Logger logger = Logger.getLogger(FlowBuilder.class);
    String moduleName;
    String name;
    String description;
    FlowEventListener flowEventListener;
    RecoveryManager recoveryManager;
    ExceptionResolver exceptionResolver;
    ConfigurationService configurationService;
    ExclusionServiceFactory exclusionServiceFactory;
    ExclusionService exclusionService;
    ErrorReportingServiceFactory errorReportingServiceFactory = new ErrorReportingServiceFactoryDefaultImpl();
    ErrorReportingService errorReportingService;
    Monitor monitor;
    FlowConfigurationBuilder flowConfigurationBuilder;
    EventFactory eventFactory = new FlowEventFactory();
    FlowElement<?> exclusionFlowHeadElement;
    ResubmissionService resubmissionService;
    SerialiserFactory serialiserFactory;

    public FlowBuilder(String name, String moduleName) {
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("Flow name cannot be 'null'");
        }
        this.moduleName = moduleName;
        if (moduleName == null) {
            throw new IllegalArgumentException("Flow module name cannot be 'null'");
        }
    }

    public static FlowBuilder newFlow(String name, String moduleName) {
        return new FlowBuilder(name, moduleName);
    }

    public FlowBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public FlowBuilder withFlowListener(FlowEventListener flowEventListener) {
        this.flowEventListener = flowEventListener;
        return this;
    }

    public FlowBuilder withConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
        return this;
    }

    public FlowBuilder withRecoveryManager(RecoveryManager recoveryManager) {
        this.recoveryManager = recoveryManager;
        return this;
    }

    public FlowBuilder withExclusionService(ExclusionService exclusionService) {
        this.exclusionService = exclusionService;
        return this;
    }

    public FlowBuilder withExclusionServiceFactory(ExclusionServiceFactory exclusionServiceFactory) {
        this.exclusionServiceFactory = exclusionServiceFactory;
        return this;
    }

    public FlowBuilder withErrorReportingService(ErrorReportingService errorReportingService) {
        this.errorReportingService = errorReportingService;
        return this;
    }

    public FlowBuilder withExclusionFlowHeadElement(FlowElement<?> exclusionFlowHeadElement) {
        this.exclusionFlowHeadElement = exclusionFlowHeadElement;
        return this;
    }

    public FlowBuilder withSerialiserFactory(SerialiserFactory serialiserFactory) {
        this.serialiserFactory = serialiserFactory;
        return this;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public void setResubmissionService(ResubmissionService resubmissionService) {
        this.resubmissionService = resubmissionService;
    }

    public void setExceptionResolver(ExceptionResolver exceptionResolver) {
        this.exceptionResolver = exceptionResolver;
    }

    public FlowBuilder withEventFactory(EventFactory eventFactory) {
        this.eventFactory = eventFactory;
        return this;
    }

    public FlowConfigurationBuilder consumer(String name, Consumer consumer) {
        return new FlowConfigurationBuilder(this, name, consumer);
    }

    public class FlowConfigurationBuilder {
        FlowBuilder flowBuilder;
        List<FlowElement> flowElements = new ArrayList<FlowElement>();
        FlowElement lastFlowElement;
        Object flowElementInvokerConfiguration;

        private FlowConfigurationBuilder(FlowBuilder flowBuilder2, String name, Consumer consumer) {
            this.flowBuilder = flowBuilder2;
            if (flowBuilder2 == null) {
                throw new IllegalArgumentException("flowBuilder cannot be 'null'");
            }
            this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)consumer, (FlowElementInvoker)new ConsumerFlowElementInvoker()));
        }

        public FlowConfigurationBuilder broker(String name, Broker broker) {
            this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)broker, (FlowElementInvoker)new BrokerFlowElementInvoker()));
            return this;
        }

        public FlowProducerTerminator publisher(String name, Producer producer) {
            this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)producer, (FlowElementInvoker)new ProducerFlowElementInvoker()));
            return new FlowProducerTerminator();
        }

        public FlowConfigurationBuilder translater(String name, Translator translator) {
            this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)translator, (FlowElementInvoker)new TranslatorFlowElementInvoker()));
            return this;
        }

        public FlowConfigurationBuilder converter(String name, Converter converter) {
            this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)converter, (FlowElementInvoker)new ConverterFlowElementInvoker()));
            return this;
        }

        public SequencerRootConfigurationBuilder sequencer(String name, Sequencer sequencer) {
            this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)sequencer, (FlowElementInvoker)new SequencerFlowElementInvoker()));
            return new SequencerRootConfigurationBuilder(this);
        }

        public RouterRootConfigurationBuilder router(String name, Router router) {
            if (this.flowElementInvokerConfiguration == null) {
                this.flowElementInvokerConfiguration = new MultiRecipientRouterConfiguration();
            } else if (!(this.flowElementInvokerConfiguration instanceof MultiRecipientRouterConfiguration)) {
                throw new IllegalArgumentException("Invalid MultiRecipientRouter FlowInvoker Configuration. Requires MultiRecipientRouterConfiguration, but found " + this.flowElementInvokerConfiguration.getClass().getName());
            }
            this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)router, (FlowElementInvoker)new MultiRecipientRouterFlowElementInvoker(DefaultReplicationFactory.getInstance(), (MultiRecipientRouterConfiguration)this.flowElementInvokerConfiguration)));
            return new RouterRootConfigurationBuilder(this);
        }

        public RouterRootConfigurationBuilder singleRecipientRouter(String name, SingleRecipientRouter router) {
            this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)router, (FlowElementInvoker)new SingleRecipientRouterFlowElementInvoker()));
            return new RouterRootConfigurationBuilder(this);
        }

        public RouterRootConfigurationBuilder multiRecipientRouter(String name, MultiRecipientRouter router) {
            if (this.flowElementInvokerConfiguration == null) {
                this.flowElementInvokerConfiguration = new MultiRecipientRouterConfiguration();
            } else if (!(this.flowElementInvokerConfiguration instanceof MultiRecipientRouterConfiguration)) {
                throw new IllegalArgumentException("Invalid MultiRecipientRouter FlowInvoker Configuration. Requires MultiRecipientRouterConfiguration, but found " + this.flowElementInvokerConfiguration.getClass().getName());
            }
            this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)router, (FlowElementInvoker)new MultiRecipientRouterFlowElementInvoker(DefaultReplicationFactory.getInstance(), (MultiRecipientRouterConfiguration)this.flowElementInvokerConfiguration)));
            return new RouterRootConfigurationBuilder(this);
        }

        public class SequencerProducerTerminator
        extends FlowProducerTerminator {
            SequencerRootConfigurationBuilder sequencerRootConfigurationBuilder;

            public SequencerProducerTerminator(SequencerRootConfigurationBuilder sequencerRootConfigurationBuilder) {
                this.sequencerRootConfigurationBuilder = sequencerRootConfigurationBuilder;
            }

            @Override
            public Flow build() {
                return super.build();
            }

            public SequencerConfigurationBuilder sequence() {
                return this.sequencerRootConfigurationBuilder.sequence();
            }

            public SequencerConfigurationBuilder sequence(String sequenceName) {
                return this.sequencerRootConfigurationBuilder.sequence(sequenceName);
            }
        }

        public class FlowProducerTerminator {
            public Flow build() {
                int count = FlowConfigurationBuilder.this.flowElements.size();
                FlowElementImpl nextFlowElement = null;
                HashMap<String, FlowElementImpl> transitions = new HashMap<String, FlowElementImpl>();
                while (count > 0) {
                    FlowElement flowElement;
                    if ((flowElement = FlowConfigurationBuilder.this.flowElements.get(--count)).getFlowComponent() instanceof Consumer) {
                        ((Consumer)flowElement.getFlowComponent()).setEventFactory((Object)FlowBuilder.this.eventFactory);
                        nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), flowElement.getFlowComponent(), flowElement.getFlowElementInvoker(), nextFlowElement);
                        continue;
                    }
                    if (flowElement.getFlowComponent() instanceof RouterRootConfigurationBuilder.When) {
                        transitions.put(((RouterRootConfigurationBuilder.When)flowElement.getFlowComponent()).getResult(), nextFlowElement);
                        continue;
                    }
                    if (flowElement.getFlowComponent() instanceof SequencerRootConfigurationBuilder.Sequence) {
                        transitions.put(flowElement.getComponentName(), nextFlowElement);
                        continue;
                    }
                    if (flowElement.getFlowComponent() instanceof RouterRootConfigurationBuilder.Otherwise) {
                        transitions.put(((RouterRootConfigurationBuilder.Otherwise)flowElement.getFlowComponent()).getResult(), nextFlowElement);
                        continue;
                    }
                    if (flowElement.getFlowComponent() instanceof Router) {
                        nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), flowElement.getFlowComponent(), flowElement.getFlowElementInvoker(), new HashMap(transitions));
                        transitions.clear();
                        continue;
                    }
                    if (flowElement.getFlowComponent() instanceof MultiRecipientRouter) {
                        nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), flowElement.getFlowComponent(), flowElement.getFlowElementInvoker(), new HashMap(transitions));
                        transitions.clear();
                        continue;
                    }
                    if (flowElement.getFlowComponent() instanceof SingleRecipientRouter) {
                        nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), flowElement.getFlowComponent(), flowElement.getFlowElementInvoker(), new HashMap(transitions));
                        transitions.clear();
                        continue;
                    }
                    if (flowElement.getFlowComponent() instanceof Sequencer) {
                        nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), flowElement.getFlowComponent(), flowElement.getFlowElementInvoker(), new HashMap(transitions));
                        transitions.clear();
                        continue;
                    }
                    if (flowElement.getFlowComponent() instanceof Producer) {
                        nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), flowElement.getFlowComponent(), flowElement.getFlowElementInvoker());
                        continue;
                    }
                    nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), flowElement.getFlowComponent(), flowElement.getFlowElementInvoker(), (FlowElement)nextFlowElement);
                }
                if (FlowBuilder.this.configurationService == null) {
                    FlowBuilder.this.configurationService = ConfiguredResourceConfigurationService.getDefaultConfigurationService();
                }
                if (FlowBuilder.this.exclusionService == null) {
                    if (FlowBuilder.this.exclusionServiceFactory == null) {
                        throw new IllegalArgumentException("exclusionServiceFactory cannot be 'null'");
                    }
                    FlowBuilder.this.exclusionService = FlowBuilder.this.exclusionServiceFactory.getExclusionService(FlowBuilder.this.moduleName, FlowBuilder.this.name);
                }
                if (FlowBuilder.this.errorReportingService == null) {
                    FlowBuilder.this.errorReportingService = FlowBuilder.this.errorReportingServiceFactory.getErrorReportingService();
                }
                if (FlowBuilder.this.errorReportingService instanceof ErrorReportingServiceDefaultImpl) {
                    ((ErrorReportingServiceDefaultImpl)FlowBuilder.this.errorReportingService).setModuleName(FlowBuilder.this.moduleName);
                    ((ErrorReportingServiceDefaultImpl)FlowBuilder.this.errorReportingService).setFlowName(FlowBuilder.this.name);
                }
                if (FlowBuilder.this.recoveryManager == null) {
                    FlowBuilder.this.recoveryManager = RecoveryManagerFactory.getInstance().getRecoveryManager(FlowBuilder.this.name, FlowBuilder.this.moduleName, (Consumer)nextFlowElement.getFlowComponent(), FlowBuilder.this.exclusionService, FlowBuilder.this.errorReportingService);
                }
                if (FlowBuilder.this.exceptionResolver != null) {
                    FlowBuilder.this.recoveryManager.setResolver((Object)FlowBuilder.this.exceptionResolver);
                }
                DefaultFlowConfiguration flowConfiguration = new DefaultFlowConfiguration((FlowElement)nextFlowElement, FlowBuilder.this.configurationService, FlowBuilder.this.resubmissionService);
                DefaultExclusionFlowConfiguration exclusionFlowConfiguration = null;
                if (FlowBuilder.this.exclusionFlowHeadElement != null) {
                    exclusionFlowConfiguration = new DefaultExclusionFlowConfiguration(FlowBuilder.this.exclusionFlowHeadElement, FlowBuilder.this.configurationService, FlowBuilder.this.resubmissionService);
                }
                VisitingInvokerFlow flow = new VisitingInvokerFlow(FlowBuilder.this.name, FlowBuilder.this.moduleName, (FlowConfiguration)flowConfiguration, (ExclusionFlowConfiguration)exclusionFlowConfiguration, FlowBuilder.this.recoveryManager, FlowBuilder.this.exclusionService, FlowBuilder.this.serialiserFactory);
                flow.setFlowListener(FlowBuilder.this.flowEventListener);
                if (flow instanceof IsErrorReportingServiceAware) {
                    ((IsErrorReportingServiceAware)flow).setErrorReportingService(FlowBuilder.this.errorReportingService);
                }
                if (FlowBuilder.this.monitor != null && flow instanceof MonitorSubject) {
                    if (FlowBuilder.this.monitor.getEnvironment() == null) {
                        FlowBuilder.this.monitor.setEnvironment("Undefined Environment");
                    }
                    if (FlowBuilder.this.monitor.getModuleName() == null) {
                        FlowBuilder.this.monitor.setModuleName(FlowBuilder.this.moduleName);
                    }
                    if (FlowBuilder.this.monitor.getFlowName() == null) {
                        FlowBuilder.this.monitor.setFlowName(FlowBuilder.this.name);
                    }
                    ((MonitorSubject)flow).setMonitor(FlowBuilder.this.monitor);
                }
                logger.info((Object)("Instantiated flow - name[" + FlowBuilder.this.name + "] module[" + FlowBuilder.this.moduleName + "] with ExclusionService[" + FlowBuilder.this.exclusionService.getClass().getSimpleName() + "] with ErrorReportingService[" + FlowBuilder.this.errorReportingService.getClass().getSimpleName() + "] with RecoveryManager[" + FlowBuilder.this.recoveryManager.getClass().getSimpleName() + "]; ExceptionResolver[" + (FlowBuilder.this.exceptionResolver != null ? FlowBuilder.this.exceptionResolver.getClass().getSimpleName() : "none") + "]; Monitor[" + (FlowBuilder.this.monitor != null && flow instanceof MonitorSubject ? FlowBuilder.this.monitor.getClass().getSimpleName() : "none") + "]"));
                return flow;
            }
        }

        public class RouterConfigurationBuilder {
            RouterRootConfigurationBuilder routerRootConfigurationBuilder;
            FlowConfigurationBuilder flowConfigurationBuilder;
            FlowElement routerFlowElement;

            public RouterConfigurationBuilder(RouterRootConfigurationBuilder routerRootConfigurationBuilder, FlowConfigurationBuilder flowConfigurationBuilder2) {
                this.routerRootConfigurationBuilder = routerRootConfigurationBuilder;
                this.flowConfigurationBuilder = flowConfigurationBuilder2;
            }

            public RouterRootConfigurationBuilder publisher(String name, Producer producer) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)producer, (FlowElementInvoker)new ProducerFlowElementInvoker()));
                return this.routerRootConfigurationBuilder;
            }

            public RouterConfigurationBuilder broker(String name, Broker broker) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)broker, (FlowElementInvoker)new BrokerFlowElementInvoker()));
                return this;
            }

            public RouterConfigurationBuilder translater(String name, Translator translator) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)translator, (FlowElementInvoker)new TranslatorFlowElementInvoker()));
                return this;
            }

            public RouterConfigurationBuilder converter(String name, Converter converter) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)converter, (FlowElementInvoker)new ConverterFlowElementInvoker()));
                return this;
            }

            public SequencerRootConfigurationBuilder sequencer(String name, Sequencer sequencer) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)sequencer, (FlowElementInvoker)new SequencerFlowElementInvoker()));
                return new SequencerRootConfigurationBuilder(this.flowConfigurationBuilder);
            }

            public RouterRootConfigurationBuilder router(String name, Router router) {
                if (FlowConfigurationBuilder.this.flowElementInvokerConfiguration == null) {
                    FlowConfigurationBuilder.this.flowElementInvokerConfiguration = new MultiRecipientRouterConfiguration();
                } else if (!(FlowConfigurationBuilder.this.flowElementInvokerConfiguration instanceof MultiRecipientRouterConfiguration)) {
                    throw new IllegalArgumentException("Invalid MultiRecipientRouter FlowInvoker Configuration. Requires MultiRecipientRouterConfiguration, but found " + FlowConfigurationBuilder.this.flowElementInvokerConfiguration.getClass().getName());
                }
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)router, (FlowElementInvoker)new MultiRecipientRouterFlowElementInvoker(DefaultReplicationFactory.getInstance(), (MultiRecipientRouterConfiguration)FlowConfigurationBuilder.this.flowElementInvokerConfiguration)));
                return new RouterRootConfigurationBuilder(this.flowConfigurationBuilder);
            }

            public RouterRootConfigurationBuilder multiRecipientRouter(String name, MultiRecipientRouter router) {
                if (FlowConfigurationBuilder.this.flowElementInvokerConfiguration == null) {
                    FlowConfigurationBuilder.this.flowElementInvokerConfiguration = new MultiRecipientRouterConfiguration();
                } else if (!(FlowConfigurationBuilder.this.flowElementInvokerConfiguration instanceof MultiRecipientRouterConfiguration)) {
                    throw new IllegalArgumentException("Invalid MultiRecipientRouter FlowInvoker Configuration. Requires MultiRecipientRouterConfiguration, but found " + FlowConfigurationBuilder.this.flowElementInvokerConfiguration.getClass().getName());
                }
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)router, (FlowElementInvoker)new MultiRecipientRouterFlowElementInvoker(DefaultReplicationFactory.getInstance(), (MultiRecipientRouterConfiguration)FlowConfigurationBuilder.this.flowElementInvokerConfiguration)));
                return new RouterRootConfigurationBuilder(this.flowConfigurationBuilder);
            }

            public RouterRootConfigurationBuilder singleRecipientRouter(String name, SingleRecipientRouter router) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)router, (FlowElementInvoker)new SingleRecipientRouterFlowElementInvoker()));
                return new RouterRootConfigurationBuilder(this.flowConfigurationBuilder);
            }
        }

        public class RouterRootConfigurationBuilder {
            FlowConfigurationBuilder flowConfigurationBuilder;
            FlowElement routerFlowElement;

            public RouterRootConfigurationBuilder(FlowConfigurationBuilder flowConfigurationBuilder2) {
                this.flowConfigurationBuilder = flowConfigurationBuilder2;
            }

            public RouterConfigurationBuilder when(String value) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl("when", (Object)new When(value), null));
                return new RouterConfigurationBuilder(this, this.flowConfigurationBuilder);
            }

            public FlowConfigurationBuilder otherise() {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl("otherwise", (Object)new Otherwise(), null));
                return this.flowConfigurationBuilder;
            }

            public class Otherwise {
                String result = "default";

                public String getResult() {
                    return this.result;
                }
            }

            public class When {
                String result;

                public When(String result) {
                    this.result = result;
                }

                public String getResult() {
                    return this.result;
                }
            }
        }

        public class SequencerConfigurationBuilder {
            SequencerRootConfigurationBuilder sequencerRootConfigurationBuilder;
            FlowConfigurationBuilder flowConfigurationBuilder;

            public SequencerConfigurationBuilder(SequencerRootConfigurationBuilder sequencerRootConfigurationBuilder, FlowConfigurationBuilder flowConfigurationBuilder2) {
                this.sequencerRootConfigurationBuilder = sequencerRootConfigurationBuilder;
                this.flowConfigurationBuilder = flowConfigurationBuilder2;
            }

            public SequencerProducerTerminator publisher(String name, Producer producer) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)producer, (FlowElementInvoker)new ProducerFlowElementInvoker()));
                return new SequencerProducerTerminator(this.sequencerRootConfigurationBuilder);
            }

            public SequencerConfigurationBuilder broker(String name, Broker broker) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)broker, (FlowElementInvoker)new BrokerFlowElementInvoker()));
                return this;
            }

            public SequencerConfigurationBuilder translater(String name, Translator translator) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)translator, (FlowElementInvoker)new TranslatorFlowElementInvoker()));
                return this;
            }

            public SequencerConfigurationBuilder converter(String name, Converter converter) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)converter, (FlowElementInvoker)new ConverterFlowElementInvoker()));
                return this;
            }

            public SequencerConfigurationBuilder sequencer(String name, Sequencer sequencer) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)sequencer, (FlowElementInvoker)new SequencerFlowElementInvoker()));
                return this;
            }

            public RouterRootConfigurationBuilder router(String name, Router router) {
                if (FlowConfigurationBuilder.this.flowElementInvokerConfiguration == null) {
                    FlowConfigurationBuilder.this.flowElementInvokerConfiguration = new MultiRecipientRouterConfiguration();
                } else if (!(FlowConfigurationBuilder.this.flowElementInvokerConfiguration instanceof MultiRecipientRouterConfiguration)) {
                    throw new IllegalArgumentException("Invalid MultiRecipientRouter FlowInvoker Configuration. Requires MultiRecipientRouterConfiguration, but found " + FlowConfigurationBuilder.this.flowElementInvokerConfiguration.getClass().getName());
                }
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)router, (FlowElementInvoker)new MultiRecipientRouterFlowElementInvoker(DefaultReplicationFactory.getInstance(), (MultiRecipientRouterConfiguration)FlowConfigurationBuilder.this.flowElementInvokerConfiguration)));
                return new RouterRootConfigurationBuilder(this.flowConfigurationBuilder);
            }

            public RouterRootConfigurationBuilder multiRecipientRouter(String name, MultiRecipientRouter router) {
                if (FlowConfigurationBuilder.this.flowElementInvokerConfiguration == null) {
                    FlowConfigurationBuilder.this.flowElementInvokerConfiguration = new MultiRecipientRouterConfiguration();
                } else if (!(FlowConfigurationBuilder.this.flowElementInvokerConfiguration instanceof MultiRecipientRouterConfiguration)) {
                    throw new IllegalArgumentException("Invalid MultiRecipientRouter FlowInvoker Configuration. Requires MultiRecipientRouterConfiguration, but found " + FlowConfigurationBuilder.this.flowElementInvokerConfiguration.getClass().getName());
                }
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)router, (FlowElementInvoker)new MultiRecipientRouterFlowElementInvoker(DefaultReplicationFactory.getInstance(), (MultiRecipientRouterConfiguration)FlowConfigurationBuilder.this.flowElementInvokerConfiguration)));
                return new RouterRootConfigurationBuilder(this.flowConfigurationBuilder);
            }

            public RouterRootConfigurationBuilder singleRecipientRouter(String name, SingleRecipientRouter router) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(name, (Object)router, (FlowElementInvoker)new SingleRecipientRouterFlowElementInvoker()));
                return new RouterRootConfigurationBuilder(this.flowConfigurationBuilder);
            }
        }

        public class SequencerRootConfigurationBuilder {
            FlowConfigurationBuilder flowConfigurationBuilder;

            public SequencerRootConfigurationBuilder(FlowConfigurationBuilder flowConfigurationBuilder2) {
                this.flowConfigurationBuilder = flowConfigurationBuilder2;
            }

            public SequencerConfigurationBuilder sequence(String sequenceName) {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl(sequenceName, (Object)new Sequence(), null));
                return new SequencerConfigurationBuilder(this, this.flowConfigurationBuilder);
            }

            public SequencerConfigurationBuilder sequence() {
                FlowConfigurationBuilder.this.flowElements.add((FlowElement)new FlowElementImpl("sequence-" + FlowConfigurationBuilder.this.flowElements.size(), (Object)new Sequence(), null));
                return new SequencerConfigurationBuilder(this, this.flowConfigurationBuilder);
            }

            public class Sequence {
            }
        }
    }
}

