/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder;

import java.util.ArrayList;
import java.util.List;
import org.ikasan.module.SimpleModule;
import org.ikasan.spec.flow.Flow;
import org.ikasan.spec.module.Module;

public class ModuleBuilder {
    String name;
    String version;
    String description;
    List<Flow> flows = new ArrayList<Flow>();

    private ModuleBuilder(String name) {
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("module name cannot be 'null'");
        }
    }

    private ModuleBuilder(String name, String version) {
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("module name cannot be 'null'");
        }
        this.version = version;
    }

    public static ModuleBuilder newModule(String name) {
        return new ModuleBuilder(name);
    }

    public static ModuleBuilder newModule(String name, String version) {
        return new ModuleBuilder(name, version);
    }

    public ModuleBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ModuleBuilder addFlow(Flow flow) {
        this.flows.add(flow);
        return this;
    }

    public Module build() {
        SimpleModule module = new SimpleModule(this.name, this.version, this.flows);
        module.setDescription(this.description);
        return module;
    }
}

