/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ikasan.builder.AopProxyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AopProxyProviderSpringImpl
implements AopProxyProvider,
ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(AopProxyProviderSpringImpl.class);
    Map<String, DefaultBeanFactoryPointcutAdvisor> aopFactories;
    List components = new ArrayList();

    @Override
    public <T> T applyPointcut(String name, T component) {
        for (Object processedComponent : this.components) {
            if (processedComponent != component) continue;
            return component;
        }
        List<Class<?>> componentInterfaces = Arrays.asList(component.getClass().getInterfaces());
        if (this.aopFactories != null && !this.aopFactories.isEmpty()) {
            ProxyFactory factory = new ProxyFactory(component);
            for (String key : this.aopFactories.keySet()) {
                DefaultBeanFactoryPointcutAdvisor aopFactory = this.aopFactories.get(key);
                for (Class<?> componentInterface : componentInterfaces) {
                    if (!aopFactory.getPointcut().getClassFilter().matches(componentInterface)) continue;
                    logger.info("Applying pointcut [" + key + "] on component [" + name + "] class [" + component.getClass().getCanonicalName() + "] interface [" + componentInterface.getCanonicalName() + "] Pointcut Expression [" + aopFactory.getPointcut().toString() + "]");
                    factory.addInterface(componentInterface);
                    factory.addAdvice(aopFactory.getAdvice());
                }
            }
            if (factory.getAdvisors().length > 0) {
                Object proxy = factory.getProxy();
                this.components.add(proxy);
                return (T)proxy;
            }
            this.components.add(component);
            return component;
        }
        this.components.add(component);
        return component;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.aopFactories = applicationContext.getBeansOfType(DefaultBeanFactoryPointcutAdvisor.class);
    }
}

