/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ikasan.builder.ExceptionResolverBuilderImpl;
import org.ikasan.builder.FlowBuilder;
import org.ikasan.builder.ModuleBuilder;
import org.ikasan.builder.MonitorBuilder;
import org.ikasan.builder.RouteBuilder;
import org.ikasan.builder.RouteImpl;
import org.ikasan.builder.component.ComponentBuilder;
import org.ikasan.flow.event.FlowEventFactory;
import org.ikasan.monitor.MonitorFactory;
import org.ikasan.monitor.notifier.NotifierFactory;
import org.ikasan.spec.dashboard.DashboardRestService;
import org.ikasan.spec.event.EventFactory;
import org.ikasan.spec.flow.FlowElement;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BuilderFactory
implements ApplicationContextAware {
    ApplicationContext applicationContext;
    EventFactory eventFactory = new FlowEventFactory();
    Map<String, ModuleBuilder> moduleBuilders = new HashMap<String, ModuleBuilder>();

    public ModuleBuilder getModuleBuilder(String moduleName) {
        if (this.moduleBuilders.containsKey(moduleName)) {
            return this.moduleBuilders.get(moduleName);
        }
        ModuleBuilder moduleBuilder = new ModuleBuilder(this.applicationContext, moduleName, this.eventFactory);
        this.moduleBuilders.put(moduleName, moduleBuilder);
        return moduleBuilder;
    }

    public FlowBuilder getFlowBuilder(String moduleName, String flowName) {
        return this.getModuleBuilder(moduleName).getFlowBuilder(flowName);
    }

    public ComponentBuilder getComponentBuilder() {
        return new ComponentBuilder(this.applicationContext);
    }

    public MonitorBuilder getMonitorBuilder() {
        return new MonitorBuilder((MonitorFactory)this.applicationContext.getBean(MonitorFactory.class), (NotifierFactory)this.applicationContext.getBean(NotifierFactory.class), (DashboardRestService)this.applicationContext.getBean("flowCacheStateRestService", DashboardRestService.class));
    }

    public RouteBuilder getRouteBuilder() {
        return new RouteBuilder(new RouteImpl(new ArrayList<FlowElement>()), this.eventFactory);
    }

    public ExceptionResolverBuilderImpl getExceptionResolverBuilder() {
        return new ExceptionResolverBuilderImpl();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

