/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder;

import com.ulisesbocchio.jasyptspringboot.environment.StandardEncryptableEnvironment;
import java.util.List;
import org.ikasan.builder.BuilderFactory;
import org.ikasan.builder.IkasanApplication;
import org.ikasan.spec.module.Module;
import org.ikasan.spec.module.ModuleContainer;
import org.ikasan.spec.module.ModuleInitialisationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public final class DefaultSpringBootIkasanApplication
implements IkasanApplication,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpringBootIkasanApplication.class);
    private ApplicationContext context;

    public static IkasanApplication createDefaultSpringBootIkasanApplication(Class<?> applicationClass, String[] args) {
        logger.debug("Spring boot createDefaultSpringBootIkasanApplication");
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[0]).environment((ConfigurableEnvironment)new StandardEncryptableEnvironment()).sources(new Class[]{applicationClass}).run(args);
        return (IkasanApplication)context.getBean(IkasanApplication.class);
    }

    @Override
    public BuilderFactory getBuilderFactory() {
        return (BuilderFactory)this.context.getBean(BuilderFactory.class);
    }

    @Override
    public void run(Module module) {
        ModuleInitialisationService service = (ModuleInitialisationService)this.context.getBean(ModuleInitialisationService.class);
        service.register(module);
        logger.info("Module [" + module.getName() + "] successfully bootstrapped.");
    }

    @Override
    public void close() {
        SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{new ExitCodeGenerator(){

            public int getExitCode() {
                return 0;
            }
        }});
    }

    @Override
    public Module getModule(String moduleName) {
        ModuleContainer moduleContainer = (ModuleContainer)this.context.getBean(ModuleContainer.class);
        return moduleContainer.getModule(moduleName);
    }

    @Override
    public List<Module> getModules() {
        ModuleContainer moduleContainer = (ModuleContainer)this.context.getBean(ModuleContainer.class);
        return moduleContainer.getModules();
    }

    @Override
    public <COMPONENT> COMPONENT getBean(Class className) {
        return (COMPONENT)this.context.getBean(className);
    }

    @Override
    public <COMPONENT> COMPONENT getBean(String name, Class className) {
        return (COMPONENT)this.context.getBean(name, className);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

