/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.ikasan.builder.AopProxyProvider;
import org.ikasan.builder.Endpoint;
import org.ikasan.builder.EvaluationOtherwise;
import org.ikasan.builder.EvaluationWhen;
import org.ikasan.builder.ExceptionResolverBuilder;
import org.ikasan.builder.MonitorBuilder;
import org.ikasan.builder.Route;
import org.ikasan.builder.RouteImpl;
import org.ikasan.builder.Sequence;
import org.ikasan.builder.component.Builder;
import org.ikasan.builder.conditional.Otherwise;
import org.ikasan.builder.conditional.When;
import org.ikasan.builder.invoker.ConcurrentSplitterInvokerConfigurationBuilder;
import org.ikasan.builder.invoker.FilterInvokerConfigurationBuilder;
import org.ikasan.builder.invoker.MultiRecipientRouterInvokerConfigurationBuilder;
import org.ikasan.builder.invoker.SplitterInvokerConfigurationBuilder;
import org.ikasan.builder.invoker.TranslatorInvokerConfigurationBuilder;
import org.ikasan.builder.invoker.VanillaInvokerConfigurationBuilder;
import org.ikasan.builder.sequential.SequenceName;
import org.ikasan.builder.sequential.SequentialOrder;
import org.ikasan.configurationService.service.ConfiguredResourceConfigurationService;
import org.ikasan.error.reporting.service.ErrorReportingServiceDefaultImpl;
import org.ikasan.exceptionResolver.ExceptionResolver;
import org.ikasan.exclusion.service.ExclusionServiceFactory;
import org.ikasan.flow.configuration.FlowPersistentConfiguration;
import org.ikasan.flow.event.DefaultReplicationFactory;
import org.ikasan.flow.event.ResubmissionEventFactoryImpl;
import org.ikasan.flow.visitorPattern.DefaultExclusionFlowConfiguration;
import org.ikasan.flow.visitorPattern.DefaultFlowConfiguration;
import org.ikasan.flow.visitorPattern.ExclusionFlowConfiguration;
import org.ikasan.flow.visitorPattern.FlowElementImpl;
import org.ikasan.flow.visitorPattern.VisitingInvokerFlow;
import org.ikasan.flow.visitorPattern.invoker.BrokerFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.ConcurrentSplitterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.ConcurrentSplitterInvokerConfiguration;
import org.ikasan.flow.visitorPattern.invoker.ConsumerFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.ConverterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.FilterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.FilterInvokerConfiguration;
import org.ikasan.flow.visitorPattern.invoker.InvokerConfiguration;
import org.ikasan.flow.visitorPattern.invoker.MultiRecipientRouterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.MultiRecipientRouterInvokerConfiguration;
import org.ikasan.flow.visitorPattern.invoker.ProducerFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.SequencerFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.SingleRecipientRouterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.SplitterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.SplitterInvokerConfiguration;
import org.ikasan.flow.visitorPattern.invoker.TranslatorFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.TranslatorInvokerConfiguration;
import org.ikasan.history.listener.MessageHistoryContextListener;
import org.ikasan.spec.component.IsConsumerAware;
import org.ikasan.spec.component.endpoint.Broker;
import org.ikasan.spec.component.endpoint.Consumer;
import org.ikasan.spec.component.endpoint.Producer;
import org.ikasan.spec.component.filter.Filter;
import org.ikasan.spec.component.routing.MultiRecipientRouter;
import org.ikasan.spec.component.routing.SingleRecipientRouter;
import org.ikasan.spec.component.sequencing.Sequencer;
import org.ikasan.spec.component.splitting.Splitter;
import org.ikasan.spec.component.transformation.Converter;
import org.ikasan.spec.component.transformation.Translator;
import org.ikasan.spec.configuration.ConfigurationService;
import org.ikasan.spec.configuration.Configured;
import org.ikasan.spec.configuration.ConfiguredResource;
import org.ikasan.spec.error.reporting.ErrorReportingService;
import org.ikasan.spec.error.reporting.ErrorReportingServiceFactory;
import org.ikasan.spec.error.reporting.IsErrorReportingServiceAware;
import org.ikasan.spec.event.EventFactory;
import org.ikasan.spec.exclusion.ExclusionService;
import org.ikasan.spec.exclusion.IsExclusionServiceAware;
import org.ikasan.spec.flow.Flow;
import org.ikasan.spec.flow.FlowConfiguration;
import org.ikasan.spec.flow.FlowElement;
import org.ikasan.spec.flow.FlowElementInvoker;
import org.ikasan.spec.flow.FlowEventListener;
import org.ikasan.spec.flow.FlowInvocationContextListener;
import org.ikasan.spec.history.MessageHistoryService;
import org.ikasan.spec.monitor.FlowMonitor;
import org.ikasan.spec.monitor.Monitor;
import org.ikasan.spec.monitor.MonitorSubject;
import org.ikasan.spec.recovery.RecoveryManager;
import org.ikasan.spec.recovery.RecoveryManagerFactory;
import org.ikasan.spec.replay.ReplayRecordService;
import org.ikasan.spec.resubmission.ResubmissionEventFactory;
import org.ikasan.spec.resubmission.ResubmissionService;
import org.ikasan.spec.serialiser.SerialiserFactory;
import org.ikasan.spec.trigger.TriggerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FlowBuilder
implements ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(FlowBuilder.class);
    private static String INVOKER = "_I";
    private static String COMPONENT = "_C";
    String moduleName;
    String flowName;
    String description;
    @Autowired
    FlowEventListener flowEventListener;
    @Autowired
    TriggerService triggerService;
    @Autowired
    RecoveryManagerFactory recoveryManagerFactory;
    RecoveryManager recoveryManager;
    @Autowired
    ExceptionResolver exceptionResolver;
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    ExclusionServiceFactory exclusionServiceFactory;
    ExclusionService exclusionService;
    @Autowired
    ErrorReportingServiceFactory errorReportingServiceFactory;
    @Autowired
    ErrorReportingService errorReportingService;
    Long errorReportingServiceTimeToLive;
    @Autowired
    MessageHistoryService messageHistoryService;
    FlowMonitor monitor;
    EventFactory eventFactory;
    FlowElement<?> exclusionFlowHeadElement;
    ResubmissionService resubmissionService;
    @Autowired
    SerialiserFactory serialiserFactory;
    @Autowired
    ReplayRecordService replayRecordService;
    List<FlowInvocationContextListener> flowInvocationContextListeners;
    ApplicationContext context;
    ResubmissionEventFactory resubmissionEventFactory = new ResubmissionEventFactoryImpl();
    @Autowired
    AopProxyProvider aopProxyProvider;
    boolean isRecording = false;

    public FlowBuilder(String name, String moduleName, EventFactory eventFactory) {
        this.flowName = name;
        if (name == null) {
            throw new IllegalArgumentException("flow name cannot be 'null'");
        }
        this.moduleName = moduleName;
        if (moduleName == null) {
            throw new IllegalArgumentException("module name cannot be 'null'");
        }
        this.eventFactory = eventFactory;
        if (eventFactory == null) {
            throw new IllegalArgumentException("eventFactory name cannot be 'null'");
        }
    }

    public FlowBuilder() {
    }

    public FlowBuilder withName(String name) {
        this.flowName = name;
        return this;
    }

    public FlowBuilder withModuleName(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    public FlowBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public FlowBuilder withFlowListener(FlowEventListener flowEventListener) {
        this.flowEventListener = flowEventListener;
        return this;
    }

    public FlowBuilder withTriggerService(TriggerService triggerService) {
        this.triggerService = triggerService;
        return this;
    }

    public FlowBuilder withConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
        return this;
    }

    public FlowBuilder withRecoveryManagerFactory(RecoveryManagerFactory recoveryManagerFactory) {
        this.recoveryManagerFactory = recoveryManagerFactory;
        return this;
    }

    public FlowBuilder withErrorReportingServiceFactory(ErrorReportingServiceFactory errorReportingServiceFactory) {
        this.errorReportingServiceFactory = errorReportingServiceFactory;
        return this;
    }

    public FlowBuilder withExclusionService(ExclusionService exclusionService) {
        this.exclusionService = exclusionService;
        return this;
    }

    public FlowBuilder withExclusionServiceFactory(ExclusionServiceFactory exclusionServiceFactory) {
        this.exclusionServiceFactory = exclusionServiceFactory;
        return this;
    }

    public FlowBuilder withErrorReportingService(ErrorReportingService errorReportingService) {
        this.errorReportingService = errorReportingService;
        return this;
    }

    public FlowBuilder withErrorReportingServiceTimeToLive(Long errorReportingServiceTimeToLive) {
        this.errorReportingServiceTimeToLive = errorReportingServiceTimeToLive;
        return this;
    }

    public FlowBuilder withExclusionFlowHeadElement(FlowElement<?> exclusionFlowHeadElement) {
        this.exclusionFlowHeadElement = exclusionFlowHeadElement;
        return this;
    }

    public FlowBuilder withSerialiserFactory(SerialiserFactory serialiserFactory) {
        this.serialiserFactory = serialiserFactory;
        return this;
    }

    public FlowBuilder withMessageHistoryService(MessageHistoryService messageHistoryService) {
        this.messageHistoryService = messageHistoryService;
        return this;
    }

    public FlowBuilder withFlowInvocationContextListener(FlowInvocationContextListener flowInvocationContextListener) {
        if (this.flowInvocationContextListeners == null) {
            this.flowInvocationContextListeners = new ArrayList<FlowInvocationContextListener>();
        }
        this.flowInvocationContextListeners.add(flowInvocationContextListener);
        return this;
    }

    public FlowBuilder withFlowInvocationContextListeners(List<FlowInvocationContextListener> flowInvocationContextListeners) {
        this.flowInvocationContextListeners = flowInvocationContextListeners;
        return this;
    }

    public FlowBuilder withMonitor(FlowMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public FlowBuilder withMonitor(MonitorBuilder.NotifierBuilder notifierBuilder) {
        this.withMonitor(notifierBuilder.build());
        return this;
    }

    public FlowBuilder withResubmissionService(ResubmissionService resubmissionService) {
        this.resubmissionService = resubmissionService;
        return this;
    }

    public FlowBuilder withRecoveryManager(RecoveryManager recoveryManager) {
        this.recoveryManager = recoveryManager;
        return this;
    }

    public FlowBuilder withReplayRecordService(ReplayRecordService replayRecordService) {
        this.replayRecordService = replayRecordService;
        return this;
    }

    public FlowBuilder withExceptionResolver(ExceptionResolver exceptionResolver) {
        this.exceptionResolver = exceptionResolver;
        return this;
    }

    public FlowBuilder withExceptionResolver(ExceptionResolverBuilder exceptionResolverBuilder) {
        return this.withExceptionResolver((ExceptionResolver)exceptionResolverBuilder.build());
    }

    public FlowBuilder withEventFactory(EventFactory eventFactory) {
        this.eventFactory = eventFactory;
        return this;
    }

    public FlowBuilder isRecording(boolean isRecording) {
        this.isRecording = isRecording;
        return this;
    }

    protected EventFactory getEventFactory() {
        return this.eventFactory;
    }

    public PrimaryRouteBuilder consumer(String name, Consumer consumer) {
        ConsumerFlowElementInvoker invoker = new ConsumerFlowElementInvoker();
        return new PrimaryRouteBuilder(this.newPrimaryRoute((FlowElement<Consumer>)new FlowElementImpl(name, (Object)this.aopProxyProvider.applyPointcut(name, consumer), (FlowElementInvoker)invoker)));
    }

    public PrimaryRouteBuilder consumer(String name, Builder<Consumer> consumerBuilder) {
        return this.consumer(name, consumerBuilder.build());
    }

    public PrimaryRouteBuilder consumer(String name, Builder<Consumer> consumerBuilder, VanillaInvokerConfigurationBuilder consumerInvokerConfigurationBuilder) {
        return this.consumer(name, consumerBuilder.build(), consumerInvokerConfigurationBuilder.build());
    }

    public PrimaryRouteBuilder consumer(String name, Builder<Consumer> consumerBuilder, InvokerConfiguration consumerInvokerConfiguration) {
        return this.consumer(name, consumerBuilder.build(), consumerInvokerConfiguration);
    }

    public PrimaryRouteBuilder consumer(String name, Consumer consumer, VanillaInvokerConfigurationBuilder consumerInvokerConfigurationBuilder) {
        return this.consumer(name, consumer, consumerInvokerConfigurationBuilder.build());
    }

    public PrimaryRouteBuilder consumer(String name, Consumer consumer, InvokerConfiguration consumerInvokerConfiguration) {
        ConsumerFlowElementInvoker invoker = new ConsumerFlowElementInvoker();
        invoker.setConfiguration((Object)consumerInvokerConfiguration);
        return new PrimaryRouteBuilder(this.newPrimaryRoute((FlowElement<Consumer>)new FlowElementImpl(name, (Object)this.aopProxyProvider.applyPointcut(name, consumer), (FlowElementInvoker)invoker)));
    }

    protected Route newPrimaryRoute(FlowElement<Consumer> flowElement) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        flowElements.add(flowElement);
        return new RouteImpl(flowElements);
    }

    protected FlowElement connectElements(List<FlowElement> flowElements, Map<String, FlowElement> transitions) {
        int count = flowElements.size();
        FlowElementImpl nextFlowElement = null;
        while (count > 0) {
            Configured configured;
            String id;
            Object configuration;
            ConfiguredResource configuredResource;
            FlowElement flowElement;
            if ((flowElement = flowElements.get(--count)).getFlowElementInvoker() instanceof ConfiguredResource) {
                configuredResource = (ConfiguredResource)flowElement.getFlowElementInvoker();
                configuration = configuredResource.getConfiguration();
                if (configuredResource.getConfiguredResourceId() == null) {
                    id = this.generateIdentifier(this.moduleName, this.flowName, flowElement.getComponentName(), configuration.getClass().getName(), INVOKER);
                    configuredResource.setConfiguredResourceId(id);
                }
            }
            if (flowElement.getFlowComponent() instanceof ConfiguredResource) {
                configuredResource = (ConfiguredResource)flowElement.getFlowComponent();
                configuration = configuredResource.getConfiguration();
                if (configuredResource.getConfiguredResourceId() == null && configuration != null) {
                    id = this.generateIdentifier(this.moduleName, this.flowName, flowElement.getComponentName(), configuration.getClass().getName(), COMPONENT);
                    configuredResource.setConfiguredResourceId(id);
                }
            }
            if (flowElement.getFlowComponent() instanceof Configured && (configured = (Configured)flowElement.getFlowComponent()).getConfiguration() == null) {
                logger.info(flowElement.getComponentName() + " configured component without a configuration instance set. Will try to create...");
                Object conf = this.generateConfiguredInstance(configured);
                if (conf != null) {
                    configured.setConfiguration(conf);
                    logger.info(conf.getClass().getName() + " configuration created and set on component " + flowElement.getComponentName());
                } else {
                    configured.setConfiguration(conf);
                    logger.info("Failed to create configuration for component " + flowElement.getComponentName());
                }
            }
            if (flowElement.getFlowComponent() instanceof Consumer) {
                Consumer consumer = (Consumer)flowElement.getFlowComponent();
                consumer.setEventFactory((Object)this.eventFactory);
                nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), (Object)consumer, flowElement.getFlowElementInvoker(), nextFlowElement);
                continue;
            }
            if (flowElement.getFlowComponent() instanceof MultiRecipientRouter) {
                nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), this.aopProxyProvider.applyPointcut(flowElement.getComponentName(), flowElement.getFlowComponent()), flowElement.getFlowElementInvoker(), new LinkedHashMap<String, FlowElement>(transitions));
                continue;
            }
            if (flowElement.getFlowComponent() instanceof SingleRecipientRouter) {
                nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), this.aopProxyProvider.applyPointcut(flowElement.getComponentName(), flowElement.getFlowComponent()), flowElement.getFlowElementInvoker(), new LinkedHashMap<String, FlowElement>(transitions));
                continue;
            }
            if (flowElement.getFlowComponent() instanceof Sequencer) {
                nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), this.aopProxyProvider.applyPointcut(flowElement.getComponentName(), flowElement.getFlowComponent()), flowElement.getFlowElementInvoker(), new LinkedHashMap<String, FlowElement>(transitions));
                continue;
            }
            if (flowElement.getFlowComponent() instanceof Producer) {
                nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), this.aopProxyProvider.applyPointcut(flowElement.getComponentName(), flowElement.getFlowComponent()), flowElement.getFlowElementInvoker());
                continue;
            }
            if (flowElement.getFlowComponent() instanceof When || flowElement.getFlowComponent() instanceof Otherwise || flowElement.getFlowComponent() instanceof SequenceName) {
                nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), flowElement.getFlowComponent(), flowElement.getFlowElementInvoker(), (FlowElement)nextFlowElement);
                continue;
            }
            nextFlowElement = new FlowElementImpl(flowElement.getComponentName(), this.aopProxyProvider.applyPointcut(flowElement.getComponentName(), flowElement.getFlowComponent()), flowElement.getFlowElementInvoker(), (FlowElement)nextFlowElement);
        }
        return nextFlowElement;
    }

    protected Object generateConfiguredInstance(Configured configured) {
        Type[] types;
        logger.warn("Component [{}] is configured but has no configuration instance set will attempt to instantiate", (Object)configured.toString());
        for (Type type : types = configured.getClass().getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType) || !Configured.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) continue;
            Type configurationType = ((ParameterizedType)type).getActualTypeArguments()[0];
            try {
                if (!(configurationType instanceof Class)) continue;
                return ((Class)configurationType).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        logger.warn("Unable to instantiate configuration for component [{}]", (Object)configured);
        return null;
    }

    protected String generateIdentifier(String moduleName, String flowName, String componentName, String fqClassName, String type) {
        String id = moduleName + "_" + flowName + "_" + componentName + "_" + fqClassName.hashCode() + type;
        if (id.length() > 255 && (id = moduleName + "_" + flowName + "_" + componentName.hashCode() + "_" + fqClassName.hashCode() + type).length() > 255) {
            id = moduleName + "_" + flowName.hashCode() + "_" + componentName.hashCode() + "_" + fqClassName.hashCode() + type;
            if (id.length() > 255) {
                id = moduleName.hashCode() + "_" + flowName.hashCode() + "_" + componentName.hashCode() + "_" + fqClassName.hashCode() + type;
            }
            if (id.length() > 255) {
                id = id.substring(0, 253) + type;
                logger.warn("Generated Identifier exceeds 255 characters for moduleName[" + moduleName + "] flowName[" + flowName + "] componentName[" + componentName + "] fq classname[" + fqClassName + "] type [" + type + "]. Truncated to 255 -> [" + id + "]");
            }
        }
        return id;
    }

    protected FlowElement connectElements(Route route) {
        List<FlowElement> flowElements = route.getFlowElements();
        if (route.getNestedRoutes().size() > 0) {
            LinkedHashMap<String, FlowElement> transitions = new LinkedHashMap<String, FlowElement>();
            for (Route nestedRoute : route.getNestedRoutes()) {
                FlowElement nestedHead = this.connectElements(nestedRoute);
                if (nestedHead.getFlowComponent() instanceof When) {
                    transitions.put(((When)nestedHead.getFlowComponent()).getResult(), nestedHead.getTransition("default"));
                    continue;
                }
                if (nestedHead.getFlowComponent() instanceof Otherwise) {
                    transitions.put(((Otherwise)nestedHead.getFlowComponent()).getResult(), nestedHead.getTransition("default"));
                    continue;
                }
                if (nestedHead.getFlowComponent() instanceof SequenceName) {
                    transitions.put(((SequenceName)nestedHead.getFlowComponent()).getName(), nestedHead.getTransition("default"));
                    continue;
                }
                throw new IllegalStateException("Unsupported FlowElement encountered in the builder [" + nestedHead.getFlowComponent().getClass() + "]");
            }
            return this.connectElements(flowElements, transitions);
        }
        return this.connectElements(flowElements, null);
    }

    protected Flow _build(Route _route) {
        return this._build(this.connectElements(_route));
    }

    Flow _build(FlowElement headFlowElement) {
        if (this.configurationService == null) {
            this.configurationService = ConfiguredResourceConfigurationService.getDefaultConfigurationService();
        }
        if (this.resubmissionService != null) {
            if (!AopUtils.isJdkDynamicProxy((Object)this.resubmissionService)) {
                Consumer unwrappedConsumer = this.getTargetObject(headFlowElement.getFlowComponent(), Consumer.class);
                if (unwrappedConsumer == this.resubmissionService) {
                    logger.info("ResubmissionService is equal to Proxied Consumer. Setting resubmissionService to Proxy object.");
                    this.resubmissionService = (ResubmissionService)headFlowElement.getFlowComponent();
                } else {
                    logger.info("ResubmissionService is not instance of JdkDynamicProxy. Trying to proxy resubmissionService.");
                    this.resubmissionService = this.aopProxyProvider.applyPointcut(this.flowName + "resubmissionService", this.resubmissionService);
                }
            }
        } else if (headFlowElement.getFlowComponent() instanceof ResubmissionService) {
            this.resubmissionService = (ResubmissionService)headFlowElement.getFlowComponent();
        }
        if (this.replayRecordService == null) {
            logger.info("Record/Replay is not supported for ModuleName[" + this.moduleName + "] Flowname[" + this.flowName + "]");
        }
        if (this.resubmissionService == null) {
            logger.info("Resubmission is not supported for ModuleName[" + this.moduleName + "] Flowname[" + this.flowName + "]");
        } else {
            this.resubmissionService.setResubmissionEventFactory(this.resubmissionEventFactory);
        }
        if (this.exclusionService == null) {
            if (this.exclusionServiceFactory == null) {
                throw new IllegalArgumentException("exclusionServiceFactory cannot be 'null'");
            }
            this.exclusionService = this.exclusionServiceFactory.getExclusionService(this.moduleName, this.flowName);
        }
        if (this.errorReportingService == null) {
            this.errorReportingService = this.errorReportingServiceFactory.getErrorReportingService();
        }
        if (this.errorReportingService instanceof ErrorReportingServiceDefaultImpl) {
            ((ErrorReportingServiceDefaultImpl)this.errorReportingService).setModuleName(this.moduleName);
            ((ErrorReportingServiceDefaultImpl)this.errorReportingService).setFlowName(this.flowName);
        }
        if (this.errorReportingServiceTimeToLive != null) {
            this.errorReportingService.setTimeToLive(this.errorReportingServiceTimeToLive);
        }
        if (this.recoveryManager == null) {
            this.recoveryManager = this.recoveryManagerFactory.getRecoveryManager(this.flowName, this.moduleName);
        }
        if (this.recoveryManager instanceof IsConsumerAware) {
            ((IsConsumerAware)this.recoveryManager).setConsumer((Consumer)headFlowElement.getFlowComponent());
        }
        if (this.recoveryManager instanceof IsExclusionServiceAware) {
            ((IsExclusionServiceAware)this.recoveryManager).setExclusionService(this.exclusionService);
        }
        if (this.recoveryManager instanceof IsErrorReportingServiceAware) {
            ((IsErrorReportingServiceAware)this.recoveryManager).setErrorReportingService(this.errorReportingService);
        }
        if (this.exceptionResolver != null) {
            this.recoveryManager.setResolver((Object)this.exceptionResolver);
        }
        DefaultFlowConfiguration flowConfiguration = new DefaultFlowConfiguration(headFlowElement, this.configurationService, this.resubmissionService, this.replayRecordService);
        DefaultExclusionFlowConfiguration exclusionFlowConfiguration = null;
        if (this.exclusionFlowHeadElement != null) {
            exclusionFlowConfiguration = new DefaultExclusionFlowConfiguration(this.exclusionFlowHeadElement, this.configurationService, this.resubmissionService, this.replayRecordService);
        }
        if (this.flowName == null) {
            throw new IllegalArgumentException("flow name cannot be 'null'");
        }
        if (this.moduleName == null) {
            throw new IllegalArgumentException("module name cannot be 'null'");
        }
        VisitingInvokerFlow flow = new VisitingInvokerFlow(this.flowName, this.moduleName, (FlowConfiguration)flowConfiguration, (ExclusionFlowConfiguration)exclusionFlowConfiguration, this.recoveryManager, this.exclusionService, this.serialiserFactory);
        flow.setFlowListener(this.flowEventListener);
        flow.setTriggerService(this.triggerService);
        if (flow instanceof ConfiguredResource) {
            FlowPersistentConfiguration flowPersistentConfiguration = (FlowPersistentConfiguration)((ConfiguredResource)flow).getConfiguration();
            flowPersistentConfiguration.setIsRecording(Boolean.valueOf(this.isRecording));
        }
        if (flow instanceof IsErrorReportingServiceAware) {
            ((IsErrorReportingServiceAware)flow).setErrorReportingService(this.errorReportingService);
        }
        if (this.monitor == null) {
            this.monitor = (FlowMonitor)this.context.getBean(FlowMonitor.class);
        }
        if (this.monitor != null && flow instanceof MonitorSubject) {
            if (this.monitor.getEnvironment() == null) {
                this.monitor.setEnvironment("Undefined Environment");
            }
            if (this.monitor.getModuleName() == null) {
                this.monitor.setModuleName(this.moduleName);
            }
            if (this.monitor.getFlowName() == null) {
                this.monitor.setFlowName(this.flowName);
            }
            ((MonitorSubject)flow).setMonitor((Monitor)this.monitor);
        }
        if (this.flowInvocationContextListeners == null) {
            this.flowInvocationContextListeners = new ArrayList<FlowInvocationContextListener>();
            MessageHistoryContextListener listener = new MessageHistoryContextListener(this.messageHistoryService, this.moduleName, this.flowName);
            this.flowInvocationContextListeners.add((FlowInvocationContextListener)listener);
        }
        flow.setFlowInvocationContextListeners(this.flowInvocationContextListeners);
        logger.info("Instantiated flow - name[" + this.flowName + "] module[" + this.moduleName + "] with RecoveryManager[" + (this.recoveryManager != null ? this.recoveryManager.getClass().getSimpleName() : "none") + "] with ErrorReportingService[" + (this.errorReportingService != null ? this.errorReportingService.getClass().getSimpleName() : "none") + "] with ResubmissionService[" + (this.resubmissionService != null ? this.resubmissionService.getClass().getSimpleName() : "none") + "] with ExceptionResolver[" + (this.exceptionResolver != null ? this.exceptionResolver.getClass().getSimpleName() : "none") + "] with ExclusionService[" + (this.exclusionService != null ? this.exclusionService.getClass().getSimpleName() : "none") + "] with ConfigurationService[" + (this.configurationService != null ? this.configurationService.getClass().getSimpleName() : "none") + "] with RecordReplayService[" + (this.replayRecordService != null ? this.replayRecordService.getClass().getSimpleName() : "none") + "] with FlowEventListener[" + (this.flowEventListener != null ? this.flowEventListener.getClass().getSimpleName() : "none") + "] with Monitor[" + (this.monitor != null && flow instanceof MonitorSubject ? this.monitor.getClass().getSimpleName() : "none") + "]");
        return flow;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    private <T> T getTargetObject(Object proxy, Class<T> targetClass) {
        try {
            if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
                return (T)((Advised)proxy).getTargetSource().getTarget();
            }
            return (T)proxy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class PrimarySequenceImpl
    implements Sequence<Flow> {
        Route route;

        public PrimarySequenceImpl(Route route) {
            this.route = route;
            if (route == null) {
                throw new IllegalArgumentException("route cannot be 'null'");
            }
        }

        @Override
        public Sequence<Flow> route(String name, Route sequencedRoute) {
            RouteImpl shallowCopy = new RouteImpl(sequencedRoute);
            shallowCopy.addFlowElementAsFirst((FlowElement)new FlowElementImpl(this.getClass().getName(), (Object)SequentialOrder.to(name), null));
            this.route.addNestedRoute(shallowCopy);
            return new PrimarySequenceImpl(this.route);
        }

        @Override
        public Flow build() {
            return FlowBuilder.this._build(this.route);
        }
    }

    public class PrimaryEvaluationOtherwiseImpl
    implements EvaluationOtherwise<Flow> {
        Route route;

        public PrimaryEvaluationOtherwiseImpl(Route route) {
            this.route = route;
            if (route == null) {
                throw new IllegalArgumentException("route cannot be 'null'");
            }
        }

        @Override
        public EvaluationOtherwise<Flow> when(String name, Route evaluatedRoute) {
            RouteImpl shallowCopy = new RouteImpl(evaluatedRoute);
            shallowCopy.addFlowElementAsFirst((FlowElement)new FlowElementImpl(this.getClass().getName(), (Object)new When(name), null));
            this.route.addNestedRoute(shallowCopy);
            return new PrimaryEvaluationOtherwiseImpl(this.route);
        }

        @Override
        public EvaluationOtherwise<Flow> otherwise(Route evaluatedRoute) {
            RouteImpl shallowCopy = new RouteImpl(evaluatedRoute);
            shallowCopy.addFlowElementAsFirst((FlowElement)new FlowElementImpl(this.getClass().getName(), (Object)new Otherwise(), null));
            this.route.addNestedRoute(shallowCopy);
            return new PrimaryEvaluationOtherwiseImpl(this.route);
        }

        @Override
        public Flow build() {
            return FlowBuilder.this._build(this.route);
        }
    }

    public class PrimaryEvaluationWhenImpl
    implements EvaluationWhen<Flow> {
        Route route;

        public PrimaryEvaluationWhenImpl(Route route) {
            this.route = route;
            if (route == null) {
                throw new IllegalArgumentException("route cannot be 'null'");
            }
        }

        @Override
        public EvaluationWhen<Flow> when(String name, Route evaluatedRoute) {
            RouteImpl shallowCopy = new RouteImpl(evaluatedRoute);
            shallowCopy.addFlowElementAsFirst((FlowElement)new FlowElementImpl(this.getClass().getName(), (Object)new When(name), null));
            this.route.addNestedRoute(shallowCopy);
            return new PrimaryEvaluationWhenImpl(this.route);
        }

        public EvaluationWhen<Flow> otherwise(Route evaluatedRoute) {
            RouteImpl shallowCopy = new RouteImpl(evaluatedRoute);
            shallowCopy.addFlowElementAsFirst((FlowElement)new FlowElementImpl(this.getClass().getName(), (Object)new Otherwise(), null));
            this.route.addNestedRoute(shallowCopy);
            return new PrimaryEvaluationWhenImpl(this.route);
        }

        @Override
        public Flow build() {
            return FlowBuilder.this._build(this.route);
        }
    }

    public class PrimaryRouteBuilder {
        Route route;

        public PrimaryRouteBuilder(Route route) {
            this.route = route;
            if (route == null) {
                throw new IllegalArgumentException("route cannot be 'null'");
            }
        }

        public PrimaryRouteBuilder converter(String name, Converter converter) {
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)converter, (FlowElementInvoker)new ConverterFlowElementInvoker()));
            return this;
        }

        public PrimaryRouteBuilder converter(String name, Builder<Converter> converterBuilder) {
            return this.converter(name, converterBuilder.build());
        }

        public PrimaryRouteBuilder converter(String name, Builder<Converter> converterBuilder, InvokerConfiguration converterInvokerConfiguration) {
            return this.converter(name, converterBuilder.build(), converterInvokerConfiguration);
        }

        public PrimaryRouteBuilder converter(String name, Builder<Converter> converterBuilder, VanillaInvokerConfigurationBuilder converterInvokerConfigurationBuilder) {
            return this.converter(name, converterBuilder.build(), converterInvokerConfigurationBuilder.build());
        }

        public PrimaryRouteBuilder converter(String name, Converter converter, InvokerConfiguration converterInvokerConfiguration) {
            ConverterFlowElementInvoker converterFlowElementInvoker = new ConverterFlowElementInvoker();
            converterFlowElementInvoker.setConfiguration((Object)converterInvokerConfiguration);
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)converter, (FlowElementInvoker)converterFlowElementInvoker));
            return this;
        }

        public PrimaryRouteBuilder converter(String name, Converter converter, VanillaInvokerConfigurationBuilder converterInvokerConfigurationBuilder) {
            return this.converter(name, converter, converterInvokerConfigurationBuilder.build());
        }

        public PrimaryRouteBuilder translator(String name, Translator translator) {
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)translator, (FlowElementInvoker)new TranslatorFlowElementInvoker()));
            return this;
        }

        public PrimaryRouteBuilder translator(String name, Builder<Translator> translatorBuilder) {
            return this.translator(name, translatorBuilder.build());
        }

        public PrimaryRouteBuilder translator(String name, Translator translator, TranslatorInvokerConfiguration translatorInvokerConfiguration) {
            TranslatorFlowElementInvoker translatorFlowElementInvoker = new TranslatorFlowElementInvoker();
            translatorFlowElementInvoker.setConfiguration((Object)translatorInvokerConfiguration);
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)translator, (FlowElementInvoker)translatorFlowElementInvoker));
            return this;
        }

        public PrimaryRouteBuilder translator(String name, Builder<Translator> translatorBuilder, TranslatorInvokerConfigurationBuilder translatorInvokerConfigurationBuilder) {
            return this.translator(name, translatorBuilder.build(), translatorInvokerConfigurationBuilder.build());
        }

        public PrimaryRouteBuilder translator(String name, Translator translator, TranslatorInvokerConfigurationBuilder translatorInvokerConfigurationBuilder) {
            return this.translator(name, translator, translatorInvokerConfigurationBuilder.build());
        }

        public PrimaryRouteBuilder translator(String name, Builder<Translator> translatorBuilder, TranslatorInvokerConfiguration translatorInvokerConfiguration) {
            return this.translator(name, translatorBuilder.build(), translatorInvokerConfiguration);
        }

        public PrimaryRouteBuilder splitter(String name, Splitter splitter) {
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)splitter, (FlowElementInvoker)new SplitterFlowElementInvoker(FlowBuilder.this.eventFactory)));
            return this;
        }

        public PrimaryRouteBuilder splitter(String name, Builder<Splitter> splitterBuilder) {
            return this.splitter(name, splitterBuilder.build());
        }

        public PrimaryRouteBuilder splitter(String name, Splitter splitter, SplitterInvokerConfigurationBuilder splitterInvokerConfigurationBuilder) {
            return this.splitter(name, splitter, splitterInvokerConfigurationBuilder.build());
        }

        public PrimaryRouteBuilder splitter(String name, Splitter splitter, SplitterInvokerConfiguration splitterInvokerConfiguration) {
            SplitterFlowElementInvoker splitterFlowElementInvoker = new SplitterFlowElementInvoker(FlowBuilder.this.eventFactory);
            splitterFlowElementInvoker.setConfiguration((Object)splitterInvokerConfiguration);
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)splitter, (FlowElementInvoker)splitterFlowElementInvoker));
            return this;
        }

        public PrimaryRouteBuilder splitter(String name, Builder<Splitter> splitterBuilder, SplitterInvokerConfiguration splitterInvokerConfiguration) {
            return this.splitter(name, splitterBuilder.build(), splitterInvokerConfiguration);
        }

        public PrimaryRouteBuilder splitter(String name, Builder<Splitter> splitterBuilder, SplitterInvokerConfigurationBuilder splitterInvokerConfigurationBuilder) {
            return this.splitter(name, splitterBuilder.build(), splitterInvokerConfigurationBuilder.build());
        }

        public PrimaryRouteBuilder concurrentSplitter(String name, Splitter splitter) {
            ConcurrentSplitterInvokerConfiguration concurrentSplitterInvokerConfiguration = new ConcurrentSplitterInvokerConfiguration();
            ExecutorService executorService = Executors.newFixedThreadPool(concurrentSplitterInvokerConfiguration.getConcurrentThreads());
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)splitter, (FlowElementInvoker)new ConcurrentSplitterFlowElementInvoker(executorService)));
            return this;
        }

        public PrimaryRouteBuilder concurrentSplitter(String name, Builder<Splitter> concurrentSplitterBuilder) {
            return this.concurrentSplitter(name, concurrentSplitterBuilder.build());
        }

        public PrimaryRouteBuilder concurrentSplitter(String name, Splitter splitter, ConcurrentSplitterInvokerConfigurationBuilder concurrentSplitterInvokerConfigurationBuilder) {
            return this.concurrentSplitter(name, splitter, concurrentSplitterInvokerConfigurationBuilder.build());
        }

        public PrimaryRouteBuilder concurrentSplitter(String name, Splitter splitter, ConcurrentSplitterInvokerConfiguration concurrentSplitterInvokerConfiguration) {
            ExecutorService executorService = Executors.newFixedThreadPool(concurrentSplitterInvokerConfiguration.getConcurrentThreads());
            ConcurrentSplitterFlowElementInvoker concurrentSplitterFlowElementInvoker = new ConcurrentSplitterFlowElementInvoker(executorService);
            concurrentSplitterFlowElementInvoker.setConfiguration((Object)concurrentSplitterInvokerConfiguration);
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)splitter, (FlowElementInvoker)concurrentSplitterFlowElementInvoker));
            return this;
        }

        public PrimaryRouteBuilder concurrentSplitter(String name, Builder<Splitter> concurrentSplitterBuilder, ConcurrentSplitterInvokerConfiguration concurrentSplitterInvokerConfiguration) {
            return this.concurrentSplitter(name, concurrentSplitterBuilder.build(), concurrentSplitterInvokerConfiguration);
        }

        public PrimaryRouteBuilder concurrentSplitter(String name, Builder<Splitter> concurrentSplitterBuilder, ConcurrentSplitterInvokerConfigurationBuilder concurrentSplitterInvokerConfigurationBuilder) {
            return this.concurrentSplitter(name, concurrentSplitterBuilder.build(), concurrentSplitterInvokerConfigurationBuilder.build());
        }

        public PrimaryRouteBuilder filter(String name, Filter filter) {
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)filter, (FlowElementInvoker)new FilterFlowElementInvoker()));
            return this;
        }

        public PrimaryRouteBuilder filter(String name, Builder<Filter> filterBuilder) {
            return this.filter(name, filterBuilder.build());
        }

        public PrimaryRouteBuilder filter(String name, Filter filter, FilterInvokerConfiguration filterInvokerConfiguration) {
            FilterFlowElementInvoker filterFlowElementInvoker = new FilterFlowElementInvoker();
            filterFlowElementInvoker.setConfiguration(filterInvokerConfiguration);
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)filter, (FlowElementInvoker)filterFlowElementInvoker));
            return this;
        }

        public PrimaryRouteBuilder filter(String name, Filter filter, FilterInvokerConfigurationBuilder filterInvokerConfigurationBuilder) {
            return this.filter(name, filter, filterInvokerConfigurationBuilder.build());
        }

        public PrimaryRouteBuilder filter(String name, Builder<Filter> filterBuilder, FilterInvokerConfiguration filterInvokerConfiguration) {
            return this.filter(name, filterBuilder.build(), filterInvokerConfiguration);
        }

        public PrimaryRouteBuilder filter(String name, Builder<Filter> filterBuilder, FilterInvokerConfigurationBuilder filterInvokerConfigurationBuilder) {
            return this.filter(name, filterBuilder.build(), filterInvokerConfigurationBuilder.build());
        }

        public Sequence<Flow> sequencer(String name, Sequencer sequencer) {
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)sequencer, (FlowElementInvoker)new SequencerFlowElementInvoker()));
            return new PrimarySequenceImpl(this.route);
        }

        public Sequence<Flow> sequencer(String name, Builder<Sequencer> sequencerBuilder) {
            return this.sequencer(name, sequencerBuilder.build());
        }

        public Sequence<Flow> sequencer(String name, Sequencer sequencer, InvokerConfiguration sequencerInvokerConfiguration) {
            SequencerFlowElementInvoker sequencerFlowElementInvoker = new SequencerFlowElementInvoker();
            sequencerFlowElementInvoker.setConfiguration((Object)sequencerInvokerConfiguration);
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)sequencer, (FlowElementInvoker)sequencerFlowElementInvoker));
            return new PrimarySequenceImpl(this.route);
        }

        public Sequence<Flow> sequencer(String name, Builder<Sequencer> sequencerBuilder, InvokerConfiguration sequencerInvokerConfiguration) {
            return this.sequencer(name, sequencerBuilder.build(), sequencerInvokerConfiguration);
        }

        public Sequence<Flow> sequencer(String name, Builder<Sequencer> sequencerBuilder, VanillaInvokerConfigurationBuilder sequencerInvokerConfigurationBuilder) {
            return this.sequencer(name, sequencerBuilder.build(), sequencerInvokerConfigurationBuilder.build());
        }

        public Sequence<Flow> sequencer(String name, Sequencer sequencer, VanillaInvokerConfigurationBuilder sequencerInvokerConfigurationBuilder) {
            return this.sequencer(name, sequencer, sequencerInvokerConfigurationBuilder.build());
        }

        public PrimaryRouteBuilder broker(String name, Broker broker) {
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)broker, (FlowElementInvoker)new BrokerFlowElementInvoker()));
            return this;
        }

        public PrimaryRouteBuilder broker(String name, Builder<Broker> brokerBuilder) {
            return this.broker(name, brokerBuilder.build());
        }

        public PrimaryRouteBuilder broker(String name, Broker broker, InvokerConfiguration brokerInvokerConfiguration) {
            BrokerFlowElementInvoker brokerFlowElementInvoker = new BrokerFlowElementInvoker();
            brokerFlowElementInvoker.setConfiguration((Object)brokerInvokerConfiguration);
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)broker, (FlowElementInvoker)brokerFlowElementInvoker));
            return this;
        }

        public PrimaryRouteBuilder broker(String name, Builder<Broker> brokerBuilder, InvokerConfiguration brokerInvokerConfiguration) {
            return this.broker(name, brokerBuilder.build(), brokerInvokerConfiguration);
        }

        public PrimaryRouteBuilder broker(String name, Builder<Broker> brokerBuilder, VanillaInvokerConfigurationBuilder brokerInvokerConfigurationBuilder) {
            return this.broker(name, brokerBuilder.build(), brokerInvokerConfigurationBuilder.build());
        }

        public PrimaryRouteBuilder broker(String name, Broker broker, VanillaInvokerConfigurationBuilder brokerInvokerConfigurationBuilder) {
            return this.broker(name, broker, brokerInvokerConfigurationBuilder.build());
        }

        public EvaluationOtherwise<Flow> singleRecipientRouter(String name, SingleRecipientRouter singleRecipientRouter) {
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)singleRecipientRouter, (FlowElementInvoker)new SingleRecipientRouterFlowElementInvoker()));
            return new PrimaryEvaluationOtherwiseImpl(this.route);
        }

        public EvaluationOtherwise<Flow> singleRecipientRouter(String name, SingleRecipientRouter singleRecipientRouter, InvokerConfiguration invokerConfiguration) {
            SingleRecipientRouterFlowElementInvoker singleRecipientRouterFlowElementInvoker = new SingleRecipientRouterFlowElementInvoker();
            singleRecipientRouterFlowElementInvoker.setConfiguration((Object)invokerConfiguration);
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)singleRecipientRouter, (FlowElementInvoker)singleRecipientRouterFlowElementInvoker));
            return new PrimaryEvaluationOtherwiseImpl(this.route);
        }

        public EvaluationOtherwise<Flow> singleRecipientRouter(String name, Builder<SingleRecipientRouter> singleRecipientRouterBuilder) {
            return this.singleRecipientRouter(name, singleRecipientRouterBuilder.build());
        }

        public EvaluationOtherwise<Flow> singleRecipientRouter(String name, Builder<SingleRecipientRouter> singleRecipientRouterBuilder, InvokerConfiguration invokerConfiguration) {
            return this.singleRecipientRouter(name, singleRecipientRouterBuilder.build(), invokerConfiguration);
        }

        public EvaluationOtherwise<Flow> singleRecipientRouter(String name, Builder<SingleRecipientRouter> singleRecipientRouterBuilder, VanillaInvokerConfigurationBuilder invokerConfigurationBuilder) {
            return this.singleRecipientRouter(name, singleRecipientRouterBuilder.build(), invokerConfigurationBuilder.build());
        }

        public EvaluationOtherwise<Flow> singleRecipientRouter(String name, SingleRecipientRouter singleRecipientRouter, VanillaInvokerConfigurationBuilder invokerConfigurationBuilder) {
            return this.singleRecipientRouter(name, singleRecipientRouter, invokerConfigurationBuilder.build());
        }

        public EvaluationWhen<Flow> multiRecipientRouter(String name, MultiRecipientRouter multiRecipientRouter) {
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)multiRecipientRouter, (FlowElementInvoker)new MultiRecipientRouterFlowElementInvoker(DefaultReplicationFactory.getInstance(), new MultiRecipientRouterInvokerConfiguration())));
            return new PrimaryEvaluationWhenImpl(this.route);
        }

        public EvaluationWhen<Flow> multiRecipientRouter(String name, Builder<MultiRecipientRouter> multiRecipientRouterBuilder) {
            return this.multiRecipientRouter(name, multiRecipientRouterBuilder.build());
        }

        public EvaluationWhen<Flow> multiRecipientRouter(String name, MultiRecipientRouter multiRecipientRouter, MultiRecipientRouterInvokerConfiguration invokerConfiguration) {
            MultiRecipientRouterFlowElementInvoker multiRecipientRouterFlowElementInvoker = new MultiRecipientRouterFlowElementInvoker(DefaultReplicationFactory.getInstance(), invokerConfiguration);
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)multiRecipientRouter, (FlowElementInvoker)multiRecipientRouterFlowElementInvoker));
            return new PrimaryEvaluationWhenImpl(this.route);
        }

        public EvaluationWhen<Flow> multiRecipientRouter(String name, Builder<MultiRecipientRouter> multiRecipientRouterBuilder, MultiRecipientRouterInvokerConfiguration invokerConfiguration) {
            return this.multiRecipientRouter(name, multiRecipientRouterBuilder.build(), invokerConfiguration);
        }

        public EvaluationWhen<Flow> multiRecipientRouter(String name, MultiRecipientRouter multiRecipientRouter, MultiRecipientRouterInvokerConfigurationBuilder invokerConfigurationBuilder) {
            return this.multiRecipientRouter(name, multiRecipientRouter, invokerConfigurationBuilder.build());
        }

        public EvaluationWhen<Flow> multiRecipientRouter(String name, Builder<MultiRecipientRouter> multiRecipientRouterBuilder, MultiRecipientRouterInvokerConfigurationBuilder invokerConfigurationBuilder) {
            return this.multiRecipientRouter(name, multiRecipientRouterBuilder.build(), invokerConfigurationBuilder.build());
        }

        public Endpoint<Flow> producer(String name, Producer producer) {
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)producer, (FlowElementInvoker)new ProducerFlowElementInvoker()));
            return new EndpointImpl();
        }

        public Endpoint<Flow> producer(String name, Builder<Producer> producerBuilder) {
            return this.producer(name, producerBuilder.build());
        }

        public Endpoint<Flow> producer(String name, Producer producer, InvokerConfiguration producerInvokerConfiguration) {
            ProducerFlowElementInvoker producerFlowElementInvoker = new ProducerFlowElementInvoker();
            producerFlowElementInvoker.setConfiguration((Object)producerInvokerConfiguration);
            this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)producer, (FlowElementInvoker)producerFlowElementInvoker));
            return new EndpointImpl();
        }

        public Endpoint<Flow> producer(String name, Builder<Producer> producerBuilder, InvokerConfiguration producerInvokerConfiguration) {
            return this.producer(name, producerBuilder.build(), producerInvokerConfiguration);
        }

        public Endpoint<Flow> producer(String name, Producer producer, VanillaInvokerConfigurationBuilder producerInvokerConfigurationBuilder) {
            return this.producer(name, producer, producerInvokerConfigurationBuilder.build());
        }

        public Endpoint<Flow> producer(String name, Builder<Producer> producerBuilder, VanillaInvokerConfigurationBuilder producerInvokerConfigurationBuilder) {
            return this.producer(name, producerBuilder.build(), producerInvokerConfigurationBuilder.build());
        }

        class EndpointImpl
        implements Endpoint<Flow> {
            EndpointImpl() {
            }

            @Override
            public Flow build() {
                return FlowBuilder.this._build(PrimaryRouteBuilder.this.route);
            }
        }
    }
}

