/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder;

import org.ikasan.builder.AopProxyProvider;
import org.ikasan.builder.AopProxyProviderSpringImpl;
import org.ikasan.builder.BuilderFactory;
import org.ikasan.builder.ExceptionResolverBuilderImpl;
import org.ikasan.exceptionResolver.ExceptionConfig;
import org.ikasan.exceptionResolver.ExceptionResolver;
import org.ikasan.exceptionResolver.action.ExceptionAction;
import org.ikasan.exceptionResolver.action.ExcludeEventAction;
import org.ikasan.exceptionResolver.action.IgnoreAction;
import org.ikasan.exceptionResolver.action.RetryAction;
import org.ikasan.exceptionResolver.action.ScheduledRetryAction;
import org.ikasan.module.IkasanModuleAutoConfiguration;
import org.ikasan.monitor.IkasanMonitorAutoConfiguration;
import org.ikasan.rest.module.IkasanRestAutoConfiguration;
import org.ikasan.transaction.IkasanTransactionConfiguration;
import org.ikasan.web.IkasanWebAutoConfiguration;
import org.ikasan.web.WebSecurityConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ImportResource(value={"classpath:ikasan-transaction-conf.xml", "classpath:ikasan-transaction-pointcut-resubmission.xml", "classpath:ikasan-transaction-pointcut-quartz.xml", "classpath:serialiser-service-conf.xml", "classpath:scheduler-service-conf.xml", "classpath:error-reporting-service-conf.xml", "classpath:recoveryManager-service-conf.xml", "classpath:filter-service-conf.xml", "classpath:configuration-service-conf.xml", "classpath:systemevent-service-conf.xml", "classpath:replay-service-conf.xml", "classpath:wiretap-service-conf.xml", "classpath:hospital-conf.xml", "classpath:exclusion-service-conf.xml", "classpath:topology-conf.xml", "classpath:datasource-conf.xml", "classpath:security-service-boot-conf.xml", "classpath:springapp-servlet-boot.xml"})
@Import(value={ExceptionConfig.class, IkasanTransactionConfiguration.class, IkasanWebAutoConfiguration.class, IkasanModuleAutoConfiguration.class, WebSecurityConfig.class, IkasanRestAutoConfiguration.class, IkasanMonitorAutoConfiguration.class})
public class IkasanBaseAutoConfiguration {
    @Bean
    public BuilderFactory builderFactory() {
        return new BuilderFactory();
    }

    @Bean
    public AopProxyProvider aopProxyProvider() {
        return new AopProxyProviderSpringImpl();
    }

    @Bean
    @ConfigurationProperties(prefix="ikasan.exceptions")
    public ExceptionConfig exceptionConfig() {
        return new ExceptionConfig();
    }

    @Bean
    public ExceptionResolver exceptionResolver(BuilderFactory builderFactory, ExceptionConfig exceptionConfig) {
        ExceptionResolverBuilderImpl builder = builderFactory.getExceptionResolverBuilder();
        if (exceptionConfig.getExcludedClasses() != null) {
            exceptionConfig.getExcludedClasses().stream().forEach(exclusion -> builder.addExceptionToAction((Class)exclusion, (ExceptionAction)ExcludeEventAction.instance()));
        }
        if (exceptionConfig.getIgnoredClasses() != null) {
            exceptionConfig.getIgnoredClasses().stream().forEach(ignore -> builder.addExceptionToAction((Class)ignore, (ExceptionAction)IgnoreAction.instance()));
        }
        if (exceptionConfig.getRetryConfigs() != null) {
            exceptionConfig.getRetryConfigs().stream().forEach(r -> builder.addExceptionToAction(r.getClassName(), (ExceptionAction)new RetryAction(r.getDelayInMillis(), r.getMaxRetries())));
        }
        if (exceptionConfig.getScheduledRetryConfigs() != null) {
            exceptionConfig.getScheduledRetryConfigs().stream().forEach(r -> builder.addExceptionToAction(r.getClassName(), (ExceptionAction)new ScheduledRetryAction(r.getCronExpression(), r.getMaxRetries())));
        }
        return (ExceptionResolver)builder.build();
    }
}

