/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import org.ikasan.builder.FlowBuilder;
import org.ikasan.module.ConfiguredModuleConfiguration;
import org.ikasan.module.ConfiguredModuleImpl;
import org.ikasan.module.SimpleModule;
import org.ikasan.spec.configuration.ConfiguredResource;
import org.ikasan.spec.event.EventFactory;
import org.ikasan.spec.flow.Flow;
import org.ikasan.spec.flow.FlowFactory;
import org.ikasan.spec.module.Module;
import org.ikasan.spec.module.ModuleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class ModuleBuilder {
    public static final String SERVER_PORT = "server.port";
    public static final String SERVER_ADDRESS = "server.address";
    public static final String SERVER_PROTOCOL = "server.protocol";
    public static final String PUBLIC_SERVICE_PORT = "public.service.port";
    public static final String PUBLIC_SERVICE_ADDRESS = "public.service.address";
    public static final String PUBLIC_SERVICE_PROTOCOL = "public.service.protocol";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_HOST = "localhost";
    private static final Logger logger = LoggerFactory.getLogger(ModuleBuilder.class);
    ModuleType moduleType;
    String name;
    String version;
    String description = "Unspecified";
    List<Flow> flows = new ArrayList<Flow>();
    ApplicationContext context;
    EventFactory eventFactory;
    FlowFactory flowFactory;
    ConfiguredModuleConfiguration configuration;

    ModuleBuilder(ApplicationContext context, String name, EventFactory eventFactory) {
        this.context = context;
        if (context == null) {
            throw new IllegalArgumentException("context cannot be 'null'");
        }
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("module name cannot be 'null'");
        }
        this.eventFactory = eventFactory;
        if (eventFactory == null) {
            throw new IllegalArgumentException("eventFactory name cannot be 'null'");
        }
    }

    ModuleBuilder(String name) {
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("module name cannot be 'null'");
        }
    }

    public ModuleBuilder withType(ModuleType type) {
        this.moduleType = type;
        return this;
    }

    public ModuleBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ModuleBuilder withFlowFactory(FlowFactory flowFactory) {
        this.flowFactory = flowFactory;
        return this;
    }

    public ModuleBuilder setConfiguration(ConfiguredModuleConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ModuleBuilder withVersion(String version) {
        this.version = version;
        return this;
    }

    public ModuleBuilder addFlow(Flow flow) {
        this.flows.add(flow);
        return this;
    }

    public Module build() {
        ConfiguredModuleImpl module;
        if (this.flowFactory != null) {
            module = new ConfiguredModuleImpl(this.name, this.version, this.flowFactory, this.getUrl());
            if (module instanceof ConfiguredResource) {
                ((ConfiguredResource)module).setConfiguredResourceId(this.name);
                if (this.configuration != null) {
                    ((ConfiguredResource)module).setConfiguration((Object)this.configuration);
                } else {
                    ((ConfiguredResource)module).setConfiguration((Object)new ConfiguredModuleConfiguration());
                }
            }
        } else {
            module = new SimpleModule(this.name, this.version, this.flows, this.getUrl());
        }
        module.setDescription(this.description);
        if (this.moduleType != null) {
            module.setType(this.moduleType);
        }
        return module;
    }

    public FlowBuilder getFlowBuilder(String flowName) {
        AutowireCapableBeanFactory beanFactory = this.context.getAutowireCapableBeanFactory();
        FlowBuilder flowBuilder = new FlowBuilder(flowName, this.name, this.eventFactory);
        beanFactory.autowireBean((Object)flowBuilder);
        flowBuilder.setApplicationContext(this.context);
        return flowBuilder;
    }

    private String getUrl() {
        String host = this.getHost();
        Integer port = this.getPort();
        String pid = ModuleBuilder.getPid();
        String protocol = this.getProtocol();
        String context = this.context.getApplicationName();
        String serverUrl = protocol + "://" + host + ":" + port + context;
        logger.info("Module url [" + serverUrl + "] running with PID [" + pid + "]");
        return serverUrl;
    }

    private Integer getPort() {
        try {
            String port = this.context.getEnvironment().getProperty(PUBLIC_SERVICE_PORT);
            if (port != null) {
                return Integer.valueOf(port);
            }
            port = this.context.getEnvironment().getProperty(SERVER_PORT);
            if (port != null) {
                return Integer.valueOf(port);
            }
            return 8080;
        }
        catch (Throwable ex) {
            return 8080;
        }
    }

    private String getHost() {
        try {
            String host = this.context.getEnvironment().getProperty(PUBLIC_SERVICE_ADDRESS);
            if (host != null) {
                return host;
            }
            host = this.context.getEnvironment().getProperty(SERVER_ADDRESS);
            if (host != null) {
                return host;
            }
            return DEFAULT_HOST;
        }
        catch (Throwable ex) {
            return DEFAULT_HOST;
        }
    }

    private String getProtocol() {
        try {
            String protocol = this.context.getEnvironment().getProperty(PUBLIC_SERVICE_PROTOCOL);
            if (protocol != null) {
                return protocol;
            }
            protocol = this.context.getEnvironment().getProperty(SERVER_PROTOCOL);
            if (protocol != null) {
                return protocol;
            }
            return DEFAULT_PROTOCOL;
        }
        catch (Throwable ex) {
            return DEFAULT_PROTOCOL;
        }
    }

    private static String getPid() {
        try {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            return jvmName.split("@")[0];
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

