/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder;

import java.util.ArrayList;
import java.util.List;
import org.ikasan.monitor.MonitorFactory;
import org.ikasan.monitor.notifier.EmailNotifierConfiguration;
import org.ikasan.monitor.notifier.NotifierFactory;
import org.ikasan.spec.configuration.Configured;
import org.ikasan.spec.configuration.ConfiguredResource;
import org.ikasan.spec.dashboard.DashboardRestService;
import org.ikasan.spec.monitor.FlowMonitor;
import org.ikasan.spec.monitor.FlowNotifier;
import org.ikasan.spec.monitor.Notifier;

public class MonitorBuilder {
    MonitorFactory monitorFactory;
    NotifierFactory notifierFactory;
    FlowMonitor monitor;
    DashboardRestService flowCacheStateRestService;

    public MonitorBuilder(MonitorFactory monitorFactory, NotifierFactory notifierFactory, DashboardRestService flowCacheStateRestService) {
        this.monitorFactory = monitorFactory;
        if (monitorFactory == null) {
            throw new IllegalArgumentException("monitorFactory cannot be 'null'");
        }
        this.notifierFactory = notifierFactory;
        if (notifierFactory == null) {
            throw new IllegalArgumentException("notifierFactory cannot be 'null'");
        }
        this.flowCacheStateRestService = flowCacheStateRestService;
        if (flowCacheStateRestService == null) {
            throw new IllegalArgumentException("flowCacheStateRestService cannot be 'null'");
        }
    }

    public NotifierBuilder withMonitor(FlowMonitor monitor) {
        this.monitor = monitor;
        return new NotifierBuilder();
    }

    public NotifierBuilder withFlowStateChangeMonitor() {
        this.monitor = this.monitorFactory.getFlowMonitor();
        return new NotifierBuilder();
    }

    public class NotifierBuilder {
        List<Notifier> notifiers = new ArrayList<Notifier>();

        public NotifierBuilder withNotifier(Notifier notifier) {
            this.notifiers.add(notifier);
            return this;
        }

        public NotifierBuilder withNotifiers(List<Notifier> notifiers) {
            this.notifiers = notifiers;
            return this;
        }

        public NotifierBuilder withEmailNotifier(EmailNotifierConfiguration emailNotifierConfiguration) {
            FlowNotifier notifier = MonitorBuilder.this.notifierFactory.getEmailFlowNotifier();
            if (notifier instanceof ConfiguredResource) {
                ((Configured)notifier).setConfiguration((Object)emailNotifierConfiguration);
            }
            return this.withNotifier((Notifier)notifier);
        }

        public NotifierBuilder withDashboardNotifier() {
            FlowNotifier notifier = MonitorBuilder.this.notifierFactory.getDashboardFlowNotifier(MonitorBuilder.this.flowCacheStateRestService);
            return this.withNotifier((Notifier)notifier);
        }

        public FlowMonitor build() {
            if (MonitorBuilder.this.monitor == null) {
                MonitorBuilder.this.monitor = MonitorBuilder.this.monitorFactory.getFlowMonitor();
            }
            MonitorBuilder.this.monitor.setNotifiers(this.notifiers);
            return MonitorBuilder.this.monitor;
        }
    }
}

