/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.ikasan.builder.EvaluationOtherwise;
import org.ikasan.builder.EvaluationOtherwiseImpl;
import org.ikasan.builder.EvaluationWhen;
import org.ikasan.builder.EvaluationWhenImpl;
import org.ikasan.builder.Route;
import org.ikasan.builder.Sequence;
import org.ikasan.builder.SequenceImpl;
import org.ikasan.builder.component.Builder;
import org.ikasan.builder.invoker.ConcurrentSplitterInvokerConfigurationBuilder;
import org.ikasan.builder.invoker.FilterInvokerConfigurationBuilder;
import org.ikasan.builder.invoker.MultiRecipientRouterInvokerConfigurationBuilder;
import org.ikasan.builder.invoker.SplitterInvokerConfigurationBuilder;
import org.ikasan.builder.invoker.TranslatorInvokerConfigurationBuilder;
import org.ikasan.builder.invoker.VanillaInvokerConfigurationBuilder;
import org.ikasan.flow.event.DefaultReplicationFactory;
import org.ikasan.flow.visitorPattern.FlowElementImpl;
import org.ikasan.flow.visitorPattern.invoker.BrokerFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.ConcurrentSplitterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.ConcurrentSplitterInvokerConfiguration;
import org.ikasan.flow.visitorPattern.invoker.ConverterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.FilterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.FilterInvokerConfiguration;
import org.ikasan.flow.visitorPattern.invoker.InvokerConfiguration;
import org.ikasan.flow.visitorPattern.invoker.MultiRecipientRouterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.MultiRecipientRouterInvokerConfiguration;
import org.ikasan.flow.visitorPattern.invoker.ProducerFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.SequencerFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.SingleRecipientRouterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.SplitterFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.SplitterInvokerConfiguration;
import org.ikasan.flow.visitorPattern.invoker.TranslatorFlowElementInvoker;
import org.ikasan.flow.visitorPattern.invoker.TranslatorInvokerConfiguration;
import org.ikasan.spec.component.endpoint.Broker;
import org.ikasan.spec.component.endpoint.Producer;
import org.ikasan.spec.component.filter.Filter;
import org.ikasan.spec.component.routing.MultiRecipientRouter;
import org.ikasan.spec.component.routing.SingleRecipientRouter;
import org.ikasan.spec.component.sequencing.Sequencer;
import org.ikasan.spec.component.splitting.Splitter;
import org.ikasan.spec.component.transformation.Converter;
import org.ikasan.spec.component.transformation.Translator;
import org.ikasan.spec.event.EventFactory;
import org.ikasan.spec.flow.FlowElement;
import org.ikasan.spec.flow.FlowElementInvoker;

public class RouteBuilder {
    Route route;
    EventFactory eventFactory;

    public RouteBuilder(Route route, EventFactory eventFactory) {
        this.route = route;
        if (route == null) {
            throw new IllegalArgumentException("route cannot be 'null'");
        }
        this.eventFactory = eventFactory;
        if (eventFactory == null) {
            throw new IllegalArgumentException("eventFactory cannot be 'null'");
        }
    }

    public RouteBuilder converter(String name, Converter converter) {
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)converter, (FlowElementInvoker)new ConverterFlowElementInvoker()));
        return this;
    }

    public RouteBuilder converter(String name, Builder<Converter> converterBuilder, InvokerConfiguration converterInvokerConfiguration) {
        return this.converter(name, converterBuilder.build(), converterInvokerConfiguration);
    }

    public RouteBuilder converter(String name, Converter converter, InvokerConfiguration converterInvokerConfiguration) {
        ConverterFlowElementInvoker converterFlowElementInvoker = new ConverterFlowElementInvoker();
        converterFlowElementInvoker.setConfiguration((Object)converterInvokerConfiguration);
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)converter, (FlowElementInvoker)converterFlowElementInvoker));
        return this;
    }

    public RouteBuilder converter(String name, Builder<Converter> converterBuilder, VanillaInvokerConfigurationBuilder converterInvokerConfigurationBuilder) {
        return this.converter(name, converterBuilder.build(), converterInvokerConfigurationBuilder.build());
    }

    public RouteBuilder converter(String name, Converter converter, VanillaInvokerConfigurationBuilder converterInvokerConfigurationBuilder) {
        return this.converter(name, converter, converterInvokerConfigurationBuilder.build());
    }

    public RouteBuilder converter(String name, Builder<Converter> converterBuilder) {
        return this.converter(name, converterBuilder.build());
    }

    public RouteBuilder translator(String name, Translator translator) {
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)translator, (FlowElementInvoker)new TranslatorFlowElementInvoker()));
        return this;
    }

    public RouteBuilder translator(String name, Builder<Translator> translatorBuilder) {
        return this.translator(name, translatorBuilder.build());
    }

    public RouteBuilder translator(String name, Translator translator, TranslatorInvokerConfiguration translatorInvokerConfiguration) {
        TranslatorFlowElementInvoker translatorFlowElementInvoker = new TranslatorFlowElementInvoker();
        translatorFlowElementInvoker.setConfiguration((Object)translatorInvokerConfiguration);
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)translator, (FlowElementInvoker)translatorFlowElementInvoker));
        return this;
    }

    public RouteBuilder translator(String name, Builder<Translator> translatorBuilder, TranslatorInvokerConfiguration translatorInvokerConfiguration) {
        return this.translator(name, translatorBuilder.build(), translatorInvokerConfiguration);
    }

    public RouteBuilder translator(String name, Builder<Translator> translatorBuilder, TranslatorInvokerConfigurationBuilder translatorInvokerConfigurationBuilder) {
        return this.translator(name, translatorBuilder.build(), translatorInvokerConfigurationBuilder.build());
    }

    public RouteBuilder translator(String name, Translator translator, TranslatorInvokerConfigurationBuilder translatorInvokerConfigurationBuilder) {
        return this.translator(name, translator, translatorInvokerConfigurationBuilder.build());
    }

    public RouteBuilder splitter(String name, Splitter splitter) {
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)splitter, (FlowElementInvoker)new SplitterFlowElementInvoker(this.eventFactory)));
        return this;
    }

    public RouteBuilder splitter(String name, Builder<Splitter> splitterBuilder) {
        return this.splitter(name, splitterBuilder.build());
    }

    public RouteBuilder splitter(String name, Splitter splitter, SplitterInvokerConfiguration splitterInvokerConfiguration) {
        SplitterFlowElementInvoker splitterFlowElementInvoker = new SplitterFlowElementInvoker(this.eventFactory);
        splitterFlowElementInvoker.setConfiguration((Object)splitterInvokerConfiguration);
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)splitter, (FlowElementInvoker)splitterFlowElementInvoker));
        return this;
    }

    public RouteBuilder splitter(String name, Builder<Splitter> splitterBuilder, SplitterInvokerConfiguration splitterInvokerConfiguration) {
        return this.splitter(name, splitterBuilder.build(), splitterInvokerConfiguration);
    }

    public RouteBuilder splitter(String name, Builder<Splitter> splitterBuilder, SplitterInvokerConfigurationBuilder splitterInvokerConfigurationBuilder) {
        return this.splitter(name, splitterBuilder.build(), splitterInvokerConfigurationBuilder.build());
    }

    public RouteBuilder splitter(String name, Splitter splitter, SplitterInvokerConfigurationBuilder splitterInvokerConfigurationBuilder) {
        return this.splitter(name, splitter, splitterInvokerConfigurationBuilder.build());
    }

    public RouteBuilder concurrentSplitter(String name, Splitter splitter) {
        ConcurrentSplitterInvokerConfiguration concurrentSplitterInvokerConfiguration = new ConcurrentSplitterInvokerConfiguration();
        ExecutorService executorService = Executors.newFixedThreadPool(concurrentSplitterInvokerConfiguration.getConcurrentThreads());
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)splitter, (FlowElementInvoker)new ConcurrentSplitterFlowElementInvoker(executorService)));
        return this;
    }

    public RouteBuilder concurrentSplitter(String name, Builder<Splitter> concurrentSplitterBuilder) {
        return this.concurrentSplitter(name, concurrentSplitterBuilder.build());
    }

    public RouteBuilder concurrentSplitter(String name, Splitter splitter, ConcurrentSplitterInvokerConfiguration concurrentSplitterInvokerConfiguration) {
        ExecutorService executorService = Executors.newFixedThreadPool(concurrentSplitterInvokerConfiguration.getConcurrentThreads());
        ConcurrentSplitterFlowElementInvoker concurrentSplitterFlowElementInvoker = new ConcurrentSplitterFlowElementInvoker(executorService);
        concurrentSplitterFlowElementInvoker.setConfiguration((Object)concurrentSplitterInvokerConfiguration);
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)splitter, (FlowElementInvoker)concurrentSplitterFlowElementInvoker));
        return this;
    }

    public RouteBuilder concurrentSplitter(String name, Builder<Splitter> concurrentSplitterBuilder, ConcurrentSplitterInvokerConfiguration concurrentSplitterInvokerConfiguration) {
        return this.concurrentSplitter(name, concurrentSplitterBuilder.build(), concurrentSplitterInvokerConfiguration);
    }

    public RouteBuilder concurrentSplitter(String name, Builder<Splitter> splitterBuilder, ConcurrentSplitterInvokerConfigurationBuilder concurrentSplitterInvokerConfigurationBuilder) {
        return this.concurrentSplitter(name, splitterBuilder.build(), concurrentSplitterInvokerConfigurationBuilder.build());
    }

    public RouteBuilder concurrentSplitter(String name, Splitter splitter, ConcurrentSplitterInvokerConfigurationBuilder concurrentSplitterInvokerConfigurationBuilder) {
        return this.concurrentSplitter(name, splitter, concurrentSplitterInvokerConfigurationBuilder.build());
    }

    public RouteBuilder filter(String name, Filter filter) {
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)filter, (FlowElementInvoker)new FilterFlowElementInvoker()));
        return this;
    }

    public RouteBuilder filter(String name, Builder<Filter> filterBuilder) {
        return this.filter(name, filterBuilder.build());
    }

    public RouteBuilder filter(String name, Filter filter, FilterInvokerConfiguration filterInvokerConfiguration) {
        FilterFlowElementInvoker filterFlowElementInvoker = new FilterFlowElementInvoker();
        filterFlowElementInvoker.setConfiguration(filterInvokerConfiguration);
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)filter, (FlowElementInvoker)filterFlowElementInvoker));
        return this;
    }

    public RouteBuilder filter(String name, Builder<Filter> filterBuilder, FilterInvokerConfiguration filterInvokerConfiguration) {
        return this.filter(name, filterBuilder.build(), filterInvokerConfiguration);
    }

    public RouteBuilder filter(String name, Builder<Filter> filterBuilder, FilterInvokerConfigurationBuilder filterInvokerConfigurationBuilder) {
        return this.filter(name, filterBuilder.build(), filterInvokerConfigurationBuilder.build());
    }

    public RouteBuilder filter(String name, Filter filter, FilterInvokerConfigurationBuilder filterInvokerConfigurationBuilder) {
        return this.filter(name, filter, filterInvokerConfigurationBuilder.build());
    }

    public Sequence<Route> sequencer(String name, Sequencer sequencer) {
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)sequencer, (FlowElementInvoker)new SequencerFlowElementInvoker()));
        return new SequenceImpl(this.route);
    }

    public Sequence<Route> sequencer(String name, Builder<Sequencer> sequencerBuilder) {
        return this.sequencer(name, sequencerBuilder.build());
    }

    public Sequence<Route> sequencer(String name, Sequencer sequencer, InvokerConfiguration sequencerInvokerConfiguration) {
        SequencerFlowElementInvoker sequencerFlowElementInvoker = new SequencerFlowElementInvoker();
        sequencerFlowElementInvoker.setConfiguration((Object)sequencerInvokerConfiguration);
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)sequencer, (FlowElementInvoker)sequencerFlowElementInvoker));
        return new SequenceImpl(this.route);
    }

    public Sequence<Route> sequencer(String name, Builder<Sequencer> sequencerBuilder, InvokerConfiguration sequencerInvokerConfiguration) {
        return this.sequencer(name, sequencerBuilder.build(), sequencerInvokerConfiguration);
    }

    public Sequence<Route> sequencer(String name, Builder<Sequencer> sequencerBuilder, VanillaInvokerConfigurationBuilder sequencerInvokerConfigurationBuilder) {
        return this.sequencer(name, sequencerBuilder.build(), sequencerInvokerConfigurationBuilder.build());
    }

    public Sequence<Route> sequencer(String name, Sequencer sequencer, VanillaInvokerConfigurationBuilder sequencerInvokerConfigurationBuilder) {
        return this.sequencer(name, sequencer, sequencerInvokerConfigurationBuilder.build());
    }

    public RouteBuilder broker(String name, Broker broker) {
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)broker, (FlowElementInvoker)new BrokerFlowElementInvoker()));
        return this;
    }

    public RouteBuilder broker(String name, Builder<Broker> brokerBuilder) {
        return this.broker(name, brokerBuilder.build());
    }

    public RouteBuilder broker(String name, Broker broker, InvokerConfiguration brokerInvokerConfiguration) {
        BrokerFlowElementInvoker brokerFlowElementInvoker = new BrokerFlowElementInvoker();
        brokerFlowElementInvoker.setConfiguration((Object)brokerInvokerConfiguration);
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)broker, (FlowElementInvoker)brokerFlowElementInvoker));
        return this;
    }

    public RouteBuilder broker(String name, Builder<Broker> brokerBuilder, InvokerConfiguration brokerInvokerConfiguration) {
        return this.broker(name, brokerBuilder.build(), brokerInvokerConfiguration);
    }

    public RouteBuilder broker(String name, Builder<Broker> brokerBuilder, VanillaInvokerConfigurationBuilder brokerInvokerConfigurationBuilder) {
        return this.broker(name, brokerBuilder.build(), brokerInvokerConfigurationBuilder.build());
    }

    public RouteBuilder broker(String name, Broker broker, VanillaInvokerConfigurationBuilder brokerInvokerConfigurationBuilder) {
        return this.broker(name, broker, brokerInvokerConfigurationBuilder.build());
    }

    public EvaluationOtherwise<Route> singleRecipientRouter(String name, SingleRecipientRouter singleRecipientRouter) {
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)singleRecipientRouter, (FlowElementInvoker)new SingleRecipientRouterFlowElementInvoker()));
        return new EvaluationOtherwiseImpl(this.route);
    }

    public EvaluationOtherwise<Route> singleRecipientRouter(String name, SingleRecipientRouter singleRecipientRouter, InvokerConfiguration singleRecipientRouterInvokerConfiguration) {
        SingleRecipientRouterFlowElementInvoker singleRecipientRouterFlowElementInvoker = new SingleRecipientRouterFlowElementInvoker();
        singleRecipientRouterFlowElementInvoker.setConfiguration((Object)singleRecipientRouterInvokerConfiguration);
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)singleRecipientRouter, (FlowElementInvoker)singleRecipientRouterFlowElementInvoker));
        return new EvaluationOtherwiseImpl(this.route);
    }

    public EvaluationOtherwise<Route> singleRecipientRouter(String name, Builder<SingleRecipientRouter> singleRecipientRouterBuilder) {
        return this.singleRecipientRouter(name, singleRecipientRouterBuilder.build());
    }

    public EvaluationOtherwise<Route> singleRecipientRouter(String name, Builder<SingleRecipientRouter> singleRecipientRouterBuilder, InvokerConfiguration singleRecipientRouterInvokerConfiguration) {
        return this.singleRecipientRouter(name, singleRecipientRouterBuilder.build(), singleRecipientRouterInvokerConfiguration);
    }

    public EvaluationOtherwise<Route> singleRecipientRouter(String name, SingleRecipientRouter singleRecipientRouter, VanillaInvokerConfigurationBuilder singleRecipientRouterInvokerConfigurationBuilder) {
        return this.singleRecipientRouter(name, singleRecipientRouter, singleRecipientRouterInvokerConfigurationBuilder.build());
    }

    public EvaluationOtherwise<Route> singleRecipientRouter(String name, Builder<SingleRecipientRouter> singleRecipientRouterBuilder, VanillaInvokerConfigurationBuilder singleRecipientRouterInvokerConfigurationBuilder) {
        return this.singleRecipientRouter(name, singleRecipientRouterBuilder.build(), singleRecipientRouterInvokerConfigurationBuilder.build());
    }

    public EvaluationWhen<Route> multiRecipientRouter(String name, MultiRecipientRouter multiRecipientRouter) {
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)multiRecipientRouter, (FlowElementInvoker)new MultiRecipientRouterFlowElementInvoker(DefaultReplicationFactory.getInstance(), new MultiRecipientRouterInvokerConfiguration())));
        return new EvaluationWhenImpl(this.route);
    }

    public EvaluationWhen<Route> multiRecipientRouter(String name, Builder<MultiRecipientRouter> multiRecipientRouterBuilder) {
        return this.multiRecipientRouter(name, multiRecipientRouterBuilder.build());
    }

    public EvaluationWhen<Route> multiRecipientRouter(String name, MultiRecipientRouter multiRecipientRouter, MultiRecipientRouterInvokerConfiguration invokerConfiguration) {
        MultiRecipientRouterFlowElementInvoker multiRecipientRouterFlowElementInvoker = new MultiRecipientRouterFlowElementInvoker(DefaultReplicationFactory.getInstance(), invokerConfiguration);
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)multiRecipientRouter, (FlowElementInvoker)multiRecipientRouterFlowElementInvoker));
        return new EvaluationWhenImpl(this.route);
    }

    public EvaluationWhen<Route> multiRecipientRouter(String name, Builder<MultiRecipientRouter> multiRecipientRouterBuilder, MultiRecipientRouterInvokerConfiguration invokerConfiguration) {
        return this.multiRecipientRouter(name, multiRecipientRouterBuilder.build(), invokerConfiguration);
    }

    public EvaluationWhen<Route> multiRecipientRouter(String name, Builder<MultiRecipientRouter> multiRecipientRouterBuilder, MultiRecipientRouterInvokerConfigurationBuilder invokerConfigurationBuilder) {
        return this.multiRecipientRouter(name, multiRecipientRouterBuilder.build(), invokerConfigurationBuilder.build());
    }

    public EvaluationWhen<Route> multiRecipientRouter(String name, MultiRecipientRouter multiRecipientRouter, MultiRecipientRouterInvokerConfigurationBuilder invokerConfigurationBuilder) {
        return this.multiRecipientRouter(name, multiRecipientRouter, invokerConfigurationBuilder.build());
    }

    public Route producer(String name, Producer producer) {
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)producer, (FlowElementInvoker)new ProducerFlowElementInvoker()));
        return this.route;
    }

    public Route producer(String name, Builder<Producer> producerBuilder) {
        return this.producer(name, producerBuilder.build());
    }

    public Route producer(String name, Producer producer, InvokerConfiguration producerInvokerConfiguration) {
        ProducerFlowElementInvoker producerFlowElementInvoker = new ProducerFlowElementInvoker();
        producerFlowElementInvoker.setConfiguration((Object)producerInvokerConfiguration);
        this.route.addFlowElement((FlowElement)new FlowElementImpl(name, (Object)producer, (FlowElementInvoker)producerFlowElementInvoker));
        return this.route;
    }

    public Route producer(String name, Builder<Producer> producerBuilder, InvokerConfiguration producerInvokerConfiguration) {
        return this.producer(name, producerBuilder.build(), producerInvokerConfiguration);
    }

    public Route producer(String name, Builder<Producer> producerBuilder, VanillaInvokerConfigurationBuilder producerInvokerConfigurationBuilder) {
        return this.producer(name, producerBuilder.build(), producerInvokerConfigurationBuilder.build());
    }

    public Route producer(String name, Producer producer, VanillaInvokerConfigurationBuilder producerInvokerConfigurationBuilder) {
        return this.producer(name, producer, producerInvokerConfigurationBuilder.build());
    }
}

