/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder;

import java.util.ArrayList;
import java.util.List;
import org.ikasan.builder.Route;
import org.ikasan.spec.flow.FlowElement;

public class RouteImpl
implements Route {
    List<FlowElement> flowElements;
    List<Route> nestedRoutes;

    RouteImpl(List<FlowElement> flowElements) {
        this.flowElements = flowElements;
        if (flowElements == null) {
            throw new IllegalArgumentException("flowELements cannot be 'null'");
        }
        this.nestedRoutes = new ArrayList<Route>();
    }

    RouteImpl(Route existingRoute) {
        this.flowElements = new ArrayList<FlowElement>(existingRoute.getFlowElements());
        this.nestedRoutes = new ArrayList<Route>(existingRoute.getNestedRoutes());
    }

    @Override
    public void addFlowElement(FlowElement flowElement) {
        this.flowElements.add(flowElement);
    }

    @Override
    public void addFlowElementAsFirst(FlowElement flowElement) {
        this.flowElements.add(0, flowElement);
    }

    @Override
    public void addNestedRoute(Route route) {
        this.nestedRoutes.add(route);
    }

    @Override
    public List<FlowElement> getFlowElements() {
        return this.flowElements;
    }

    @Override
    public List<Route> getNestedRoutes() {
        return this.nestedRoutes;
    }
}

