/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder.component;

import java.util.ArrayList;
import org.ikasan.builder.AopProxyProvider;
import org.ikasan.builder.component.Builder;
import org.ikasan.builder.component.converter.ObjectToXmlStringConverterBuilder;
import org.ikasan.builder.component.converter.ObjectToXmlStringConverterBuilderImpl;
import org.ikasan.builder.component.converter.XmlStringToObjectConverterBuilder;
import org.ikasan.builder.component.converter.XmlStringToObjectConverterBuilderImpl;
import org.ikasan.builder.component.endpoint.DbConsumerBuilder;
import org.ikasan.builder.component.endpoint.DbConsumerBuilderImpl;
import org.ikasan.builder.component.endpoint.DevNullProducerBuilderImpl;
import org.ikasan.builder.component.endpoint.EmailProducerBuilder;
import org.ikasan.builder.component.endpoint.EventGeneratingConsumerBuilder;
import org.ikasan.builder.component.endpoint.EventGeneratingConsumerBuilderImpl;
import org.ikasan.builder.component.endpoint.FileConsumerBuilder;
import org.ikasan.builder.component.endpoint.FileConsumerBuilderImpl;
import org.ikasan.builder.component.endpoint.FileProducerBuilder;
import org.ikasan.builder.component.endpoint.FileProducerBuilderImpl;
import org.ikasan.builder.component.endpoint.FtpConsumerBuilder;
import org.ikasan.builder.component.endpoint.FtpConsumerBuilderImpl;
import org.ikasan.builder.component.endpoint.FtpProducerBuilder;
import org.ikasan.builder.component.endpoint.FtpProducerBuilderImpl;
import org.ikasan.builder.component.endpoint.JmsConsumerBuilder;
import org.ikasan.builder.component.endpoint.JmsConsumerBuilderImpl;
import org.ikasan.builder.component.endpoint.JmsProducerBuilder;
import org.ikasan.builder.component.endpoint.JmsProducerBuilderImpl;
import org.ikasan.builder.component.endpoint.LogProducerBuilder;
import org.ikasan.builder.component.endpoint.LogProducerBuilderImpl;
import org.ikasan.builder.component.endpoint.ScheduledConsumerBuilder;
import org.ikasan.builder.component.endpoint.ScheduledConsumerBuilderImpl;
import org.ikasan.builder.component.endpoint.SftpConsumerBuilder;
import org.ikasan.builder.component.endpoint.SftpConsumerBuilderImpl;
import org.ikasan.builder.component.endpoint.SftpProducerBuilder;
import org.ikasan.builder.component.endpoint.SftpProducerBuilderImpl;
import org.ikasan.builder.component.filter.MessageFilterBuilder;
import org.ikasan.builder.component.filter.MessageFilterBuilderImpl;
import org.ikasan.builder.component.splitting.ListSplitterBuilderImpl;
import org.ikasan.component.converter.xml.XmlConfiguration;
import org.ikasan.component.converter.xml.XmlStringToObjectConfiguration;
import org.ikasan.component.endpoint.db.messageprovider.DbMessageProvider;
import org.ikasan.component.endpoint.filesystem.messageprovider.FileMessageProvider;
import org.ikasan.component.endpoint.jms.spring.consumer.JmsContainerConsumer;
import org.ikasan.component.endpoint.quartz.consumer.MessageProvider;
import org.ikasan.component.endpoint.util.producer.LogProducer;
import org.ikasan.component.splitter.DefaultListSplitter;
import org.ikasan.connector.base.command.TransactionalResourceCommandDAO;
import org.ikasan.connector.basefiletransfer.outbound.persistence.BaseFileTransferDao;
import org.ikasan.connector.util.chunking.model.dao.FileChunkDao;
import org.ikasan.filter.duplicate.service.DuplicateFilterService;
import org.ikasan.scheduler.ScheduledJobFactory;
import org.ikasan.spec.component.endpoint.Producer;
import org.ikasan.spec.component.splitting.Splitter;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.jms.core.IkasanJmsTemplate;
import org.springframework.transaction.jta.JtaTransactionManager;

public class ComponentBuilder {
    private static Logger logger = LoggerFactory.getLogger(ComponentBuilder.class);
    ApplicationContext applicationContext;

    public ComponentBuilder(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (applicationContext == null) {
            throw new IllegalArgumentException("applicationContext cannot be 'null'");
        }
    }

    public ScheduledConsumerBuilder scheduledConsumer() {
        ScheduledConsumerBuilderImpl scheduledConsumerBuilder = new ScheduledConsumerBuilderImpl((Scheduler)this.applicationContext.getBean(Scheduler.class), (ScheduledJobFactory)this.applicationContext.getBean(ScheduledJobFactory.class), (AopProxyProvider)this.applicationContext.getBean(AopProxyProvider.class));
        return scheduledConsumerBuilder;
    }

    public ScheduledConsumerBuilder scheduledConsumer(String scheduledJobName) {
        ScheduledConsumerBuilderImpl scheduledConsumerBuilder = new ScheduledConsumerBuilderImpl((Scheduler)this.applicationContext.getBean(Scheduler.class), (ScheduledJobFactory)this.applicationContext.getBean(ScheduledJobFactory.class), (AopProxyProvider)this.applicationContext.getBean(AopProxyProvider.class));
        scheduledConsumerBuilder.setScheduledJobName(scheduledJobName);
        scheduledConsumerBuilder.setScheduledJobGroupName(scheduledJobName + "_group");
        return scheduledConsumerBuilder;
    }

    public SftpConsumerBuilder sftpConsumer() {
        SftpConsumerBuilderImpl sftpConsumerBuilder = new SftpConsumerBuilderImpl((Scheduler)this.applicationContext.getBean(Scheduler.class), (ScheduledJobFactory)this.applicationContext.getBean(ScheduledJobFactory.class), (AopProxyProvider)this.applicationContext.getBean(AopProxyProvider.class), (JtaTransactionManager)this.applicationContext.getBean("transactionManager", JtaTransactionManager.class), (BaseFileTransferDao)this.applicationContext.getBean(BaseFileTransferDao.class), (FileChunkDao)this.applicationContext.getBean(FileChunkDao.class), (TransactionalResourceCommandDAO)this.applicationContext.getBean(TransactionalResourceCommandDAO.class));
        return sftpConsumerBuilder;
    }

    public SftpProducerBuilder sftpProducer() {
        SftpProducerBuilderImpl sftpProducerBuilder = new SftpProducerBuilderImpl((JtaTransactionManager)this.applicationContext.getBean("transactionManager", JtaTransactionManager.class), (BaseFileTransferDao)this.applicationContext.getBean(BaseFileTransferDao.class), (FileChunkDao)this.applicationContext.getBean(FileChunkDao.class), (TransactionalResourceCommandDAO)this.applicationContext.getBean(TransactionalResourceCommandDAO.class));
        return sftpProducerBuilder;
    }

    public FtpConsumerBuilder ftpConsumer() {
        return new FtpConsumerBuilderImpl((Scheduler)this.applicationContext.getBean(Scheduler.class), (ScheduledJobFactory)this.applicationContext.getBean(ScheduledJobFactory.class), (AopProxyProvider)this.applicationContext.getBean(AopProxyProvider.class), (JtaTransactionManager)this.applicationContext.getBean("transactionManager", JtaTransactionManager.class), (BaseFileTransferDao)this.applicationContext.getBean(BaseFileTransferDao.class), (FileChunkDao)this.applicationContext.getBean(FileChunkDao.class), (TransactionalResourceCommandDAO)this.applicationContext.getBean(TransactionalResourceCommandDAO.class));
    }

    public FtpProducerBuilder ftpProducer() {
        FtpProducerBuilderImpl ftpProducerBuilder = new FtpProducerBuilderImpl((JtaTransactionManager)this.applicationContext.getBean("transactionManager", JtaTransactionManager.class), (BaseFileTransferDao)this.applicationContext.getBean(BaseFileTransferDao.class), (FileChunkDao)this.applicationContext.getBean(FileChunkDao.class), (TransactionalResourceCommandDAO)this.applicationContext.getBean(TransactionalResourceCommandDAO.class));
        return ftpProducerBuilder;
    }

    public FileConsumerBuilder fileConsumer() {
        FileConsumerBuilderImpl fileConsumerBuilder = new FileConsumerBuilderImpl((Scheduler)this.applicationContext.getBean(Scheduler.class), (ScheduledJobFactory)this.applicationContext.getBean(ScheduledJobFactory.class), (AopProxyProvider)this.applicationContext.getBean(AopProxyProvider.class), new FileMessageProvider());
        return fileConsumerBuilder;
    }

    public FileProducerBuilder fileProducer() {
        return new FileProducerBuilderImpl();
    }

    public JmsConsumerBuilder jmsConsumer() {
        JmsContainerConsumer jmsConsumer = new JmsContainerConsumer();
        JmsConsumerBuilderImpl jmsConsumerBuilder = new JmsConsumerBuilderImpl(jmsConsumer, (JtaTransactionManager)this.applicationContext.getBean("transactionManager", JtaTransactionManager.class), (AopProxyProvider)this.applicationContext.getBean(AopProxyProvider.class));
        return jmsConsumerBuilder;
    }

    public JmsProducerBuilder jmsProducer() {
        JmsProducerBuilderImpl jmsProducerBuilder = new JmsProducerBuilderImpl(new IkasanJmsTemplate(), (JtaTransactionManager)this.applicationContext.getBean("transactionManager", JtaTransactionManager.class));
        return jmsProducerBuilder;
    }

    public LogProducerBuilder logProducer() {
        return new LogProducerBuilderImpl(new LogProducer());
    }

    public Builder<Producer<?>> devNullProducer() {
        return new DevNullProducerBuilderImpl();
    }

    public Builder<Splitter> listSplitter() {
        return new ListSplitterBuilderImpl((Splitter)new DefaultListSplitter());
    }

    public MessageFilterBuilder messageFilter() {
        return new MessageFilterBuilderImpl((DuplicateFilterService)this.applicationContext.getBean(DuplicateFilterService.class));
    }

    public EmailProducerBuilder emailProducer() {
        return EmailProducerBuilder.getInstance();
    }

    public DbConsumerBuilder dbConsumer() {
        return new DbConsumerBuilderImpl((Scheduler)this.applicationContext.getBean(Scheduler.class), (ScheduledJobFactory)this.applicationContext.getBean(ScheduledJobFactory.class), (AopProxyProvider)this.applicationContext.getBean(AopProxyProvider.class), (MessageProvider)new DbMessageProvider());
    }

    public EventGeneratingConsumerBuilder eventGeneratingConsumer() {
        try {
            return new EventGeneratingConsumerBuilderImpl((AopProxyProvider)this.applicationContext.getBean(AopProxyProvider.class));
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Check your pom.xml dependencies to ensure you include\n<dependency>\n  <groupId>org.ikasan</groupId>\n  <artifactId>ikasan-test-endpoint</artifactId>\n</dependency>\n", e);
        }
    }

    public ObjectToXmlStringConverterBuilder objectToXmlStringConverter() {
        try {
            return new ObjectToXmlStringConverterBuilderImpl(new ArrayList<Class>(), new XmlConfiguration());
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Check your pom.xml dependencies to ensure you include\n<dependency>\n  <groupId>org.ikasan</groupId>\n  <artifactId>ikasan-component-converter</artifactId>\n</dependency>\n", e);
        }
    }

    public XmlStringToObjectConverterBuilder xmlStringToObjectConverter() {
        try {
            return new XmlStringToObjectConverterBuilderImpl(new XmlStringToObjectConfiguration());
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Check your pom.xml dependencies to ensure you include\n<dependency>\n  <groupId>org.ikasan</groupId>\n  <artifactId>ikasan-component-converter</artifactId>\n</dependency>\n", e);
        }
    }
}

