/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder.component.endpoint;

import java.util.Map;
import org.ikasan.builder.AopProxyProvider;
import org.ikasan.builder.component.RequiresAopProxy;
import org.ikasan.builder.component.endpoint.AbstractScheduledConsumerBuilder;
import org.ikasan.component.endpoint.quartz.consumer.CallBackMessageProvider;
import org.ikasan.component.endpoint.quartz.consumer.CallBackScheduledConsumer;
import org.ikasan.component.endpoint.quartz.consumer.MessageProvider;
import org.ikasan.component.endpoint.quartz.consumer.ScheduledConsumer;
import org.ikasan.component.endpoint.quartz.consumer.ScheduledConsumerConfiguration;
import org.ikasan.scheduler.ScheduledJobFactory;
import org.ikasan.spec.event.EventFactory;
import org.ikasan.spec.event.ManagedEventIdentifierService;
import org.ikasan.spec.management.ManagedResourceRecoveryManager;
import org.quartz.Job;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScheduledConsumerBuilderImpl<BUILDER>
implements AbstractScheduledConsumerBuilder<BUILDER>,
RequiresAopProxy {
    private static Logger logger = LoggerFactory.getLogger(AbstractScheduledConsumerBuilderImpl.class);
    Scheduler scheduler;
    MessageProvider messageProvider;
    String configuredResourceId;
    ScheduledConsumerConfiguration configuration;
    Boolean criticalOnStartup;
    ManagedEventIdentifierService managedEventIdentifierService;
    ManagedResourceRecoveryManager managedResourceRecoveryManager;
    EventFactory eventFactory;
    ScheduledJobFactory scheduledJobFactory;
    AopProxyProvider aopProxyProvider;
    String scheduledJobName;
    String scheduledJobGroupName;
    String cronExpression;
    Boolean eager;
    Boolean ignoreMisfire;
    Integer maxEagerCallbacks;
    String timezone;
    String description;
    Map<String, String> passthroughProperties;

    public AbstractScheduledConsumerBuilderImpl(Scheduler scheduler, ScheduledJobFactory scheduledJobFactory, AopProxyProvider aopProxyProvider) {
        this.scheduler = scheduler;
        if (scheduler == null) {
            throw new IllegalArgumentException("scheduler cannot be 'null'");
        }
        this.scheduledJobFactory = scheduledJobFactory;
        this.aopProxyProvider = aopProxyProvider;
    }

    @Override
    public BUILDER setCriticalOnStartup(boolean criticalOnStartup) {
        this.criticalOnStartup = criticalOnStartup;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setConfiguredResourceId(String configuredResourceId) {
        this.configuredResourceId = configuredResourceId;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setMessageProvider(MessageProvider messageProvider) {
        this.messageProvider = messageProvider;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setManagedEventIdentifierService(ManagedEventIdentifierService managedEventIdentifierService) {
        this.managedEventIdentifierService = managedEventIdentifierService;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setManagedResourceRecoveryManager(ManagedResourceRecoveryManager managedResourceRecoveryManager) {
        this.managedResourceRecoveryManager = managedResourceRecoveryManager;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setEventFactory(EventFactory eventFactory) {
        this.eventFactory = eventFactory;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setEager(boolean eager) {
        this.eager = eager;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setMaxEagerCallbacks(int maxEagerCallbacks) {
        this.maxEagerCallbacks = maxEagerCallbacks;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setIgnoreMisfire(boolean ignoreMisfire) {
        this.ignoreMisfire = ignoreMisfire;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setTimezone(String timezone) {
        this.timezone = timezone;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setScheduledJobGroupName(String scheduledJobGroupName) {
        this.scheduledJobGroupName = scheduledJobGroupName;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setScheduledJobName(String scheduledJobName) {
        this.scheduledJobName = scheduledJobName;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setDescription(String description) {
        this.description = description;
        return (BUILDER)this;
    }

    @Override
    public BUILDER setPassthroughProperties(Map<String, String> passthroughProperties) {
        this.passthroughProperties = passthroughProperties;
        return (BUILDER)this;
    }

    protected ScheduledConsumer getScheduledConsumer() {
        return new ScheduledConsumer(this.scheduler);
    }

    protected ScheduledConsumer getCallbackScheduledConsumer() {
        return new CallBackScheduledConsumer(this.scheduler);
    }

    protected ScheduledConsumer _build() {
        ScheduledConsumer scheduledConsumer;
        if (this.messageProvider == null) {
            scheduledConsumer = this.getScheduledConsumer();
        } else {
            scheduledConsumer = this.messageProvider instanceof CallBackMessageProvider ? this.getCallbackScheduledConsumer() : this.getScheduledConsumer();
            scheduledConsumer.setMessageProvider(this.messageProvider);
        }
        return scheduledConsumer;
    }

    protected abstract ScheduledConsumerConfiguration createConfiguration();

    @Override
    public ScheduledConsumer build() {
        ScheduledConsumer scheduledConsumer = this._build();
        if (this.criticalOnStartup != null) {
            scheduledConsumer.setCriticalOnStartup(this.criticalOnStartup.booleanValue());
        }
        if (this.configuredResourceId != null) {
            scheduledConsumer.setConfiguredResourceId(this.configuredResourceId);
        }
        if (this.managedEventIdentifierService != null) {
            scheduledConsumer.setManagedEventIdentifierService(this.managedEventIdentifierService);
        }
        if (this.managedResourceRecoveryManager != null) {
            scheduledConsumer.setManagedResourceRecoveryManager(this.managedResourceRecoveryManager);
        }
        if (this.eventFactory != null) {
            scheduledConsumer.setEventFactory(this.eventFactory);
        }
        if (this.configuration != null) {
            scheduledConsumer.setConfiguration(this.configuration);
        }
        if (scheduledConsumer.getConfiguration() == null) {
            scheduledConsumer.setConfiguration(this.createConfiguration());
        }
        if (this.cronExpression != null) {
            scheduledConsumer.getConfiguration().setCronExpression(this.cronExpression);
        }
        if (this.maxEagerCallbacks != null) {
            scheduledConsumer.getConfiguration().setMaxEagerCallbacks(this.maxEagerCallbacks.intValue());
        }
        if (this.eager != null) {
            scheduledConsumer.getConfiguration().setEager(this.eager.booleanValue());
        }
        if (this.ignoreMisfire != null) {
            scheduledConsumer.getConfiguration().setIgnoreMisfire(this.ignoreMisfire.booleanValue());
        }
        if (this.timezone != null) {
            scheduledConsumer.getConfiguration().setTimezone(this.timezone);
        }
        if (this.scheduledJobName == null) {
            this.scheduledJobName = scheduledConsumer.getConfiguration().hashCode() + "-" + System.currentTimeMillis();
            logger.info("scheduledJobName not specified. Defaulted to '" + this.scheduledJobName + "'");
        }
        if (this.scheduledJobGroupName == null) {
            this.scheduledJobGroupName = scheduledConsumer.getConfiguration().hashCode() + "-" + System.currentTimeMillis();
            logger.info("scheduledJobGroupName not specified. Defaulted to '" + this.scheduledJobGroupName + "'");
        }
        if (this.description != null) {
            scheduledConsumer.getConfiguration().setDescription(this.description);
        }
        if (this.passthroughProperties != null) {
            scheduledConsumer.getConfiguration().setPassthroughProperties(this.passthroughProperties);
        }
        if (this.aopProxyProvider == null) {
            scheduledConsumer.setJobDetail(this.scheduledJobFactory.createJobDetail((Job)scheduledConsumer, ScheduledConsumer.class, this.scheduledJobName, this.scheduledJobGroupName));
        } else {
            Job pointcutJob = (Job)this.aopProxyProvider.applyPointcut(this.scheduledJobName, scheduledConsumer);
            scheduledConsumer.setJobDetail(this.scheduledJobFactory.createJobDetail(pointcutJob, ScheduledConsumer.class, this.scheduledJobName, this.scheduledJobGroupName));
        }
        return scheduledConsumer;
    }

    @Override
    public void setAopProxyProvider(AopProxyProvider aopProxyProvider) {
        this.aopProxyProvider = aopProxyProvider;
    }
}

