/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder.component.endpoint;

import org.ikasan.builder.AopProxyProvider;
import org.ikasan.builder.component.RequiresAopProxy;
import org.ikasan.builder.component.endpoint.AbstractScheduledConsumerBuilderImpl;
import org.ikasan.builder.component.endpoint.DbConsumerBuilder;
import org.ikasan.component.endpoint.db.messageprovider.DbConsumerConfiguration;
import org.ikasan.component.endpoint.quartz.consumer.MessageProvider;
import org.ikasan.component.endpoint.quartz.consumer.ScheduledConsumer;
import org.ikasan.scheduler.ScheduledJobFactory;
import org.quartz.Scheduler;

public class DbConsumerBuilderImpl
extends AbstractScheduledConsumerBuilderImpl<DbConsumerBuilder>
implements DbConsumerBuilder,
RequiresAopProxy {
    String driver;
    String url;
    String username;
    String password;
    String sqlStatement;

    public DbConsumerBuilderImpl(Scheduler scheduler, ScheduledJobFactory scheduledJobFactory, AopProxyProvider aopProxyProvider, MessageProvider messageProvider) {
        super(scheduler, scheduledJobFactory, aopProxyProvider);
        this.messageProvider = messageProvider;
    }

    @Override
    public DbConsumerBuilder setConfiguration(DbConsumerConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    @Override
    public DbConsumerBuilder setDriver(String driver) {
        this.driver = driver;
        return this;
    }

    @Override
    public DbConsumerBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public DbConsumerBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    @Override
    public DbConsumerBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public DbConsumerBuilder setSqlStatement(String sqlStatement) {
        this.sqlStatement = sqlStatement;
        return this;
    }

    protected DbConsumerConfiguration createConfiguration() {
        return DbConsumerBuilder.newConfiguration();
    }

    @Override
    public ScheduledConsumer build() {
        ScheduledConsumer scheduledConsumer = super.build();
        DbConsumerConfiguration configuration = (DbConsumerConfiguration)scheduledConsumer.getConfiguration();
        if (this.driver != null) {
            configuration.setDriver(this.driver);
        }
        if (this.url != null) {
            configuration.setUrl(this.url);
        }
        if (this.username != null) {
            configuration.setUsername(this.username);
        }
        if (this.password != null) {
            configuration.setPassword(this.password);
        }
        if (this.sqlStatement != null) {
            configuration.setSqlStatement(this.sqlStatement);
        }
        return scheduledConsumer;
    }
}

