/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder.component.endpoint;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ikasan.builder.component.endpoint.EmailProducerBuilder;
import org.ikasan.component.endpoint.email.producer.EmailProducer;
import org.ikasan.component.endpoint.email.producer.EmailProducerConfiguration;
import org.ikasan.spec.component.endpoint.Producer;

public class EmailProducerBuilderImpl
implements EmailProducerBuilder {
    EmailProducer emailProducer;

    public EmailProducerBuilderImpl(EmailProducer emailProducer) {
        this.emailProducer = emailProducer;
        if (emailProducer == null) {
            throw new IllegalArgumentException("emailProducer cannot be 'null");
        }
    }

    @Override
    public EmailProducerBuilder setCriticalOnStartup(boolean criticalOnStartup) {
        this.emailProducer.setCriticalOnStartup(criticalOnStartup);
        return this;
    }

    @Override
    public EmailProducerBuilder setConfiguredResourceId(String configuredResourceId) {
        this.emailProducer.setConfiguredResourceId(configuredResourceId);
        return this;
    }

    @Override
    public EmailProducerBuilder setConfiguration(EmailProducerConfiguration emailProducerConfiguration) {
        this.emailProducer.setConfiguration(emailProducerConfiguration);
        return this;
    }

    @Override
    public EmailProducerBuilder setToRecipient(String recipient) {
        return this.setToRecipients(Arrays.asList(recipient));
    }

    @Override
    public EmailProducerBuilder setToRecipients(List<String> recipients) {
        this.emailProducer.getConfiguration().setToRecipients(recipients);
        return this;
    }

    @Override
    public EmailProducerBuilder setCcRecipient(String recipient) {
        return this.setCcRecipients(Arrays.asList(recipient));
    }

    @Override
    public EmailProducerBuilder setCcRecipients(List<String> recipients) {
        this.emailProducer.getConfiguration().setCcRecipients(recipients);
        return this;
    }

    @Override
    public EmailProducerBuilder setBccRecipient(String recipient) {
        return this.setBccRecipients(Arrays.asList(recipient));
    }

    @Override
    public EmailProducerBuilder setBccRecipients(List<String> recipients) {
        this.emailProducer.getConfiguration().setBccRecipients(recipients);
        return this;
    }

    @Override
    public EmailProducerBuilder setEmailBody(String emailBody) {
        this.emailProducer.getConfiguration().setEmailBody(emailBody);
        return this;
    }

    @Override
    public EmailProducerBuilder setEmailFormat(String emailFormat) {
        this.emailProducer.getConfiguration().setEmailFormat(emailFormat);
        return this;
    }

    @Override
    public EmailProducerBuilder setExtendedMailSessionProperties(Map<String, String> extendedMailSessionProperties) {
        this.emailProducer.getConfiguration().setExtendedMailSessionProperties(extendedMailSessionProperties);
        return this;
    }

    @Override
    public EmailProducerBuilder setHasAttachment(boolean hasAttachment) {
        this.emailProducer.getConfiguration().setHasAttachment(hasAttachment);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailDebug(boolean mailDebug) {
        this.emailProducer.getConfiguration().setMailDebug(mailDebug);
        return this;
    }

    @Override
    public EmailProducerBuilder setFrom(String from) {
        this.emailProducer.getConfiguration().setMailFrom(from);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailhost(String mailhost) {
        this.emailProducer.getConfiguration().setMailHost(mailhost);
        return this;
    }

    @Override
    public EmailProducerBuilder setUser(String user) {
        this.emailProducer.getConfiguration().setUser(user);
        return this;
    }

    @Override
    public EmailProducerBuilder setPassword(String password) {
        this.emailProducer.getConfiguration().setPassword(password);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailMimeAddressStrict(boolean mailMimeAddressStrict) {
        this.emailProducer.getConfiguration().setMailMimeAddressStrict(mailMimeAddressStrict);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailPopClass(String mailPopClass) {
        this.emailProducer.getConfiguration().setMailPopClass(mailPopClass);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailPopHost(String mailPopHost) {
        this.emailProducer.getConfiguration().setMailPopHost(mailPopHost);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailPopPort(int mailPopPort) {
        this.emailProducer.getConfiguration().setMailPopPort(mailPopPort);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailPopUser(String mailPopUser) {
        this.emailProducer.getConfiguration().setMailPopUser(mailPopUser);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailSmtpClass(String mailSmtpClass) {
        this.emailProducer.getConfiguration().setMailSmtpClass(mailSmtpClass);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailSmtpHost(String mailSmtpHost) {
        this.emailProducer.getConfiguration().setMailSmtpHost(mailSmtpHost);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailSmtpUser(String mailSmtpUser) {
        this.emailProducer.getConfiguration().setMailSmtpUser(mailSmtpUser);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailSmtpPort(int mailSmtpPort) {
        this.emailProducer.getConfiguration().setMailSmtpPort(mailSmtpPort);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailStoreProtocol(String mailStoreProtocol) {
        this.emailProducer.getConfiguration().setMailStoreProtocol(mailStoreProtocol);
        return this;
    }

    @Override
    public EmailProducerBuilder setMailSubject(String subject) {
        this.emailProducer.getConfiguration().setSubject(subject);
        return this;
    }

    @Override
    public EmailProducerBuilder setRuntimeEnvironment(String runtimeEnvironment) {
        this.emailProducer.getConfiguration().setRuntimeEnvironment(runtimeEnvironment);
        return this;
    }

    @Override
    public EmailProducerBuilder setTransportProtocol(String transportProtocol) {
        this.emailProducer.getConfiguration().setMailTransportProtocol(transportProtocol);
        return this;
    }

    @Override
    public Producer build() {
        this.validate();
        return this.emailProducer;
    }

    protected void validate() {
        if (!(this.emailProducer.getConfiguration().getToRecipients() != null && this.emailProducer.getConfiguration().getToRecipients().size() != 0 || this.emailProducer.getConfiguration().getCcRecipients() != null && this.emailProducer.getConfiguration().getCcRecipients().size() != 0 || this.emailProducer.getConfiguration().getBccRecipients() != null && this.emailProducer.getConfiguration().getBccRecipients().size() != 0)) {
            throw new IllegalArgumentException("Email must have at least 1 recipient of 'to', 'cc', or 'bcc'");
        }
    }
}

