/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder.component.endpoint;

import java.util.concurrent.Executors;
import org.ikasan.builder.AopProxyProvider;
import org.ikasan.builder.component.endpoint.EventGeneratingConsumerBuilder;
import org.ikasan.component.endpoint.consumer.EventGeneratingConsumer;
import org.ikasan.component.endpoint.consumer.api.endpoint.TechEndpointRunnableThread;
import org.ikasan.component.endpoint.consumer.api.spec.Endpoint;
import org.ikasan.component.endpoint.consumer.api.spec.EndpointEventProvider;
import org.ikasan.spec.component.endpoint.Consumer;
import org.ikasan.spec.event.ExceptionListener;
import org.ikasan.spec.event.ManagedEventIdentifierService;
import org.ikasan.spec.event.MessageListener;

public class EventGeneratingConsumerBuilderImpl
implements EventGeneratingConsumerBuilder {
    private AopProxyProvider aopProxyProvider;
    private EndpointEventProvider endpointEventProvider = EndpointEventProvider.defaultInstance();
    private Endpoint techEndpoint = new TechEndpointRunnableThread();
    private ManagedEventIdentifierService managedEventIdentifierService;

    public EventGeneratingConsumerBuilderImpl(AopProxyProvider aopProxyProvider) {
        this.aopProxyProvider = aopProxyProvider;
        if (aopProxyProvider == null) {
            throw new IllegalArgumentException("aopProxyProvider cannot be 'null'");
        }
    }

    @Override
    public Consumer build() {
        EventGeneratingConsumer eventConsumer = new EventGeneratingConsumer(Executors.newSingleThreadExecutor(), this.techEndpoint);
        MessageListener messageListener = (MessageListener)this.aopProxyProvider.applyPointcut("eventConsumer", eventConsumer);
        this.techEndpoint.setMessageListener(messageListener);
        if (messageListener instanceof ExceptionListener) {
            this.techEndpoint.setExceptionListener((ExceptionListener)messageListener);
        }
        this.techEndpoint.setEventProvider(this.endpointEventProvider);
        if (this.managedEventIdentifierService != null) {
            eventConsumer.setManagedIdentifierService(this.managedEventIdentifierService);
        }
        return eventConsumer;
    }

    @Override
    public EventGeneratingConsumerBuilder setEndpointEventProvider(EndpointEventProvider endpointEventProvider) {
        this.endpointEventProvider = endpointEventProvider;
        return this;
    }

    @Override
    public EventGeneratingConsumerBuilder setManagedEventIdentifierService(ManagedEventIdentifierService managedEventIdentifierService) {
        this.managedEventIdentifierService = managedEventIdentifierService;
        return this;
    }
}

