/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder.component.endpoint;

import java.util.List;
import org.ikasan.builder.AopProxyProvider;
import org.ikasan.builder.component.RequiresAopProxy;
import org.ikasan.builder.component.endpoint.AbstractScheduledConsumerBuilderImpl;
import org.ikasan.builder.component.endpoint.FileConsumerBuilder;
import org.ikasan.component.endpoint.filesystem.messageprovider.FileConsumerConfiguration;
import org.ikasan.component.endpoint.filesystem.messageprovider.FileMessageProvider;
import org.ikasan.component.endpoint.filesystem.messageprovider.MessageProviderPostProcessor;
import org.ikasan.component.endpoint.quartz.consumer.ScheduledConsumer;
import org.ikasan.scheduler.ScheduledJobFactory;
import org.quartz.Scheduler;

public class FileConsumerBuilderImpl
extends AbstractScheduledConsumerBuilderImpl<FileConsumerBuilder>
implements FileConsumerBuilder,
RequiresAopProxy {
    List<String> filenames;
    String encoding;
    Boolean includeHeader;
    Boolean includeTrailer;
    Boolean sortByModifiedDateTime;
    Boolean sortAscending;
    Integer directoryDepth;
    Boolean logMatchedFilenames;
    Boolean ignoreFileRenameWhilstScanning;

    public FileConsumerBuilderImpl(Scheduler scheduler, ScheduledJobFactory scheduledJobFactory, AopProxyProvider aopProxyProvider, FileMessageProvider messageProvider) {
        super(scheduler, scheduledJobFactory, aopProxyProvider);
        this.messageProvider = messageProvider;
        if (messageProvider == null) {
            throw new IllegalArgumentException("fileMessageProvider cannot be 'null'");
        }
    }

    @Override
    public FileConsumerBuilder setConfiguration(FileConsumerConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    protected FileConsumerConfiguration createConfiguration() {
        return FileConsumerBuilder.newConfiguration();
    }

    @Override
    public FileConsumerBuilder setFilenames(List<String> filenames) {
        this.filenames = filenames;
        return this;
    }

    @Override
    public FileConsumerBuilder setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @Override
    public FileConsumerBuilder setIncludeHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
        return this;
    }

    @Override
    public FileConsumerBuilder setIncludeTrailer(boolean includeTrailer) {
        this.includeTrailer = includeTrailer;
        return this;
    }

    @Override
    public FileConsumerBuilder setSortByModifiedDateTime(boolean sortByModifiedDateTime) {
        this.sortByModifiedDateTime = sortByModifiedDateTime;
        return this;
    }

    @Override
    public FileConsumerBuilder setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
        return this;
    }

    @Override
    public FileConsumerBuilder setDirectoryDepth(int directoryDepth) {
        this.directoryDepth = directoryDepth;
        return this;
    }

    @Override
    public FileConsumerBuilder setLogMatchedFilenames(boolean logMatchedFilenames) {
        this.logMatchedFilenames = logMatchedFilenames;
        return this;
    }

    @Override
    public FileConsumerBuilder setIgnoreFileRenameWhilstScanning(boolean ignoreFileRenameWhilstScanning) {
        this.ignoreFileRenameWhilstScanning = ignoreFileRenameWhilstScanning;
        return this;
    }

    @Override
    public FileConsumerBuilder setMessageProviderPostProcessor(MessageProviderPostProcessor messageProviderPostProcessor) {
        ((FileMessageProvider)this.messageProvider).setMessageProviderPostProcessor(messageProviderPostProcessor);
        return this;
    }

    @Override
    public ScheduledConsumer build() {
        ScheduledConsumer scheduledConsumer = super.build();
        FileConsumerConfiguration configuration = (FileConsumerConfiguration)scheduledConsumer.getConfiguration();
        if (this.filenames != null) {
            configuration.setFilenames(this.filenames);
        }
        if (this.encoding != null) {
            configuration.setEncoding(this.encoding);
        }
        if (this.includeHeader != null) {
            configuration.setIncludeHeader(this.includeHeader.booleanValue());
        }
        if (this.includeTrailer != null) {
            configuration.setIncludeTrailer(this.includeTrailer.booleanValue());
        }
        if (this.sortByModifiedDateTime != null) {
            configuration.setSortByModifiedDateTime(this.sortByModifiedDateTime.booleanValue());
        }
        if (this.sortAscending != null) {
            configuration.setSortAscending(this.sortAscending.booleanValue());
        }
        if (this.directoryDepth != null) {
            configuration.setDirectoryDepth(this.directoryDepth.intValue());
        }
        if (this.logMatchedFilenames != null) {
            configuration.setLogMatchedFilenames(this.logMatchedFilenames.booleanValue());
        }
        if (this.ignoreFileRenameWhilstScanning != null) {
            configuration.setIgnoreFileRenameWhilstScanning(this.ignoreFileRenameWhilstScanning.booleanValue());
        }
        return scheduledConsumer;
    }
}

