/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder.component.endpoint;

import org.ikasan.builder.component.endpoint.FtpProducerBuilder;
import org.ikasan.connector.base.command.TransactionalResourceCommandDAO;
import org.ikasan.connector.basefiletransfer.outbound.persistence.BaseFileTransferDao;
import org.ikasan.connector.util.chunking.model.dao.FileChunkDao;
import org.ikasan.endpoint.ftp.producer.FtpProducer;
import org.ikasan.endpoint.ftp.producer.FtpProducerConfiguration;
import org.ikasan.endpoint.ftp.util.FileBasedPasswordHelper;
import org.ikasan.spec.management.ManagedResourceRecoveryManager;
import org.springframework.transaction.jta.JtaTransactionManager;

public class FtpProducerBuilderImpl
implements FtpProducerBuilder {
    private TransactionalResourceCommandDAO transactionalResourceCommandDAO;
    private FileChunkDao fileChunkDao;
    private BaseFileTransferDao baseFileTransferDao;
    private JtaTransactionManager transactionManager;
    private FileBasedPasswordHelper fileBasedPasswordHelper;
    private FtpProducerConfiguration configuration;
    private ManagedResourceRecoveryManager managedResourceRecoveryManager;
    private String configuredResourceId;
    private boolean criticalOnStartup;

    public FtpProducerBuilderImpl(JtaTransactionManager transactionManager, BaseFileTransferDao baseFileTransferDao, FileChunkDao fileChunkDao, TransactionalResourceCommandDAO transactionalResourceCommandDAO) {
        this.transactionManager = transactionManager;
        this.baseFileTransferDao = baseFileTransferDao;
        this.fileChunkDao = fileChunkDao;
        this.transactionalResourceCommandDAO = transactionalResourceCommandDAO;
    }

    @Override
    public FtpProducerBuilder setCriticalOnStartup(boolean criticalOnStartup) {
        this.criticalOnStartup = criticalOnStartup;
        return this;
    }

    @Override
    public FtpProducerBuilder setConfiguredResourceId(String configuredResourceId) {
        this.configuredResourceId = configuredResourceId;
        return this;
    }

    @Override
    public FtpProducerBuilder setConfiguration(FtpProducerConfiguration ftpProducerConfiguration) {
        this.configuration = ftpProducerConfiguration;
        return this;
    }

    @Override
    public FtpProducerBuilder setTransactionManager(JtaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        return this;
    }

    @Override
    public FtpProducerBuilder setManagedResourceRecoveryManager(ManagedResourceRecoveryManager managedResourceRecoveryManager) {
        this.managedResourceRecoveryManager = managedResourceRecoveryManager;
        return this;
    }

    public FtpProducerBuilder setFileBasedPasswordHelper(FileBasedPasswordHelper fileBasedPasswordHelper) {
        this.fileBasedPasswordHelper = fileBasedPasswordHelper;
        return this;
    }

    @Override
    public FtpProducerBuilder setOutputDirectory(String outputDirectory) {
        this.getConfiguration().setOutputDirectory(outputDirectory);
        return this;
    }

    @Override
    public FtpProducerBuilder setRenameExtension(String renameExtension) {
        this.getConfiguration().setRenameExtension(renameExtension);
        return this;
    }

    @Override
    public FtpProducerBuilder setTempFileName(String tempFileName) {
        this.getConfiguration().setTempFileName(tempFileName);
        return this;
    }

    @Override
    public FtpProducerBuilder setChecksumDelivered(Boolean checksumDelivered) {
        this.getConfiguration().setChecksumDelivered(checksumDelivered);
        return this;
    }

    @Override
    public FtpProducerBuilder setClientID(String clientID) {
        this.getConfiguration().setClientID(clientID);
        return this;
    }

    @Override
    public FtpProducerBuilder setCleanupJournalOnComplete(Boolean cleanupJournalOnComplete) {
        this.getConfiguration().setCleanupJournalOnComplete(cleanupJournalOnComplete);
        return this;
    }

    @Override
    public FtpProducerBuilder setCreateParentDirectory(Boolean createParentDirectory) {
        this.getConfiguration().setCreateParentDirectory(createParentDirectory);
        return this;
    }

    @Override
    public FtpProducerBuilder setOverwrite(Boolean overwrite) {
        this.getConfiguration().setOverwrite(overwrite);
        return this;
    }

    @Override
    public FtpProducerBuilder setActive(Boolean active) {
        this.getConfiguration().setActive(active);
        return this;
    }

    @Override
    public FtpProducerBuilder setUnzip(Boolean unzip) {
        this.getConfiguration().setUnzip(unzip);
        return this;
    }

    @Override
    public FtpProducerBuilder setRemoteHost(String remoteHost) {
        this.getConfiguration().setRemoteHost(remoteHost);
        return this;
    }

    @Override
    public FtpProducerBuilder setMaxRetryAttempts(Integer maxRetryAttempts) {
        this.getConfiguration().setMaxRetryAttempts(maxRetryAttempts);
        return this;
    }

    @Override
    public FtpProducerBuilder setRemotePort(Integer remotePort) {
        this.getConfiguration().setRemotePort(remotePort);
        return this;
    }

    @Override
    public FtpProducerBuilder setUsername(String username) {
        this.getConfiguration().setUsername(username);
        return this;
    }

    @Override
    public FtpProducerBuilder setPassword(String password) {
        this.getConfiguration().setPassword(password);
        return this;
    }

    @Override
    public FtpProducerBuilder setConnectionTimeout(Integer connectionTimeout) {
        this.getConfiguration().setConnectionTimeout(connectionTimeout);
        return this;
    }

    @Override
    public FtpProducerBuilder setSystemKey(String systemKey) {
        this.getConfiguration().setSystemKey(systemKey);
        return this;
    }

    @Override
    public FtpProducerBuilder setSocketTimeout(Integer socketTimeout) {
        this.getConfiguration().setSocketTimeout(socketTimeout);
        return this;
    }

    @Override
    public FtpProducerBuilder setDataTimeout(Integer dataTimeout) {
        this.getConfiguration().setDataTimeout(dataTimeout);
        return this;
    }

    @Override
    public FtpProducerBuilder setFTPS(Boolean FTPS) {
        this.getConfiguration().setFTPS(FTPS);
        return this;
    }

    @Override
    public FtpProducerBuilder setFtpsPort(Integer ftpsPort) {
        this.getConfiguration().setFtpsPort(ftpsPort);
        return this;
    }

    @Override
    public FtpProducerBuilder setFtpsProtocol(String ftpsProtocol) {
        this.getConfiguration().setFtpsProtocol(ftpsProtocol);
        return this;
    }

    @Override
    public FtpProducerBuilder setFtpsIsImplicit(Boolean ftpsIsImplicit) {
        this.getConfiguration().setFtpsIsImplicit(ftpsIsImplicit);
        return this;
    }

    @Override
    public FtpProducerBuilder setFtpsKeyStoreFilePath(String ftpsKeyStoreFilePath) {
        this.getConfiguration().setFtpsKeyStoreFilePath(ftpsKeyStoreFilePath);
        return this;
    }

    @Override
    public FtpProducerBuilder setFtpsKeyStoreFilePassword(String ftpsKeyStoreFilePassword) {
        this.getConfiguration().setFtpsKeyStoreFilePassword(ftpsKeyStoreFilePassword);
        return this;
    }

    private FtpProducerConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new FtpProducerConfiguration();
        }
        return this.configuration;
    }

    @Override
    public FtpProducer build() {
        if (this.fileBasedPasswordHelper == null) {
            this.fileBasedPasswordHelper = new FileBasedPasswordHelper();
        }
        FtpProducer ftpProducer = new FtpProducer(this.transactionManager, this.baseFileTransferDao, this.fileChunkDao, this.transactionalResourceCommandDAO, this.fileBasedPasswordHelper);
        ftpProducer.setConfiguration(this.configuration);
        ftpProducer.setConfiguredResourceId(this.configuredResourceId);
        if (this.criticalOnStartup) {
            ftpProducer.setCriticalOnStartup(this.criticalOnStartup);
        }
        if (this.managedResourceRecoveryManager != null) {
            ftpProducer.setManagedResourceRecoveryManager(this.managedResourceRecoveryManager);
        }
        return ftpProducer;
    }
}

