/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder.component.endpoint;

import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.MessageListener;
import javax.transaction.TransactionManager;
import org.ikasan.builder.AopProxyProvider;
import org.ikasan.builder.component.RequiresAopProxy;
import org.ikasan.builder.component.endpoint.JmsConsumerBuilder;
import org.ikasan.component.endpoint.jms.consumer.MessageProvider;
import org.ikasan.component.endpoint.jms.spring.consumer.JmsContainerConsumer;
import org.ikasan.component.endpoint.jms.spring.consumer.SpringMessageConsumerConfiguration;
import org.ikasan.component.endpoint.jms.spring.listener.ArjunaIkasanMessageListenerContainer;
import org.ikasan.spec.event.EventFactory;
import org.ikasan.spec.event.ManagedRelatedEventIdentifierService;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jms.listener.IkasanMessageListenerContainer;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.ErrorHandler;

public class JmsConsumerBuilderImpl
implements JmsConsumerBuilder,
RequiresAopProxy {
    JmsContainerConsumer jmsConsumer;
    ConnectionFactory connectionFactory;
    MessageProvider messageProvider;
    JtaTransactionManager transactionManager;
    TransactionManager arjunaTransactionManager;
    AopProxyProvider aopProxyProvider;
    SpringMessageConsumerConfiguration configuration = new SpringMessageConsumerConfiguration();
    String username;
    String password;
    String componentName = "jmsConsumer";
    private Long receiveTimeout;

    public JmsConsumerBuilderImpl(JmsContainerConsumer jmsConsumer, JtaTransactionManager transactionManager, AopProxyProvider aopProxyProvider) {
        this.jmsConsumer = jmsConsumer;
        if (jmsConsumer == null) {
            throw new IllegalArgumentException("jmsConsumer cannot be 'null'");
        }
        this.transactionManager = transactionManager;
        this.arjunaTransactionManager = transactionManager.getTransactionManager();
        this.aopProxyProvider = aopProxyProvider;
    }

    @Override
    public JmsConsumerBuilder setConfiguredResourceId(String configuredResourceId) {
        this.jmsConsumer.setConfiguredResourceId(configuredResourceId);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConfiguration(SpringMessageConsumerConfiguration jmsConsumerConfiguration) {
        this.configuration = jmsConsumerConfiguration;
        return this;
    }

    @Override
    public JmsConsumerBuilder setTransactionManager(JtaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.arjunaTransactionManager = transactionManager.getTransactionManager();
        return this;
    }

    @Override
    public JmsConsumerBuilder setMessageProvider(MessageProvider messageProvider) {
        this.messageProvider = messageProvider;
        return this;
    }

    @Override
    public JmsConsumerBuilder setReceiveTimeout(Long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
        return this;
    }

    @Override
    public JmsConsumerBuilder setManagedIdentifierService(ManagedRelatedEventIdentifierService managedRelatedEventIdentifierService) {
        this.jmsConsumer.setManagedIdentifierService(managedRelatedEventIdentifierService);
        return this;
    }

    @Override
    public JmsConsumerBuilder setEventFactory(EventFactory eventFactory) {
        this.jmsConsumer.setEventFactory(eventFactory);
        return this;
    }

    @Override
    public JmsConsumerBuilder setDestinationJndiProperties(Map<String, String> destinationJndiProperties) {
        this.getConfiguration().setDestinationJndiProperties(destinationJndiProperties);
        return this;
    }

    @Override
    public JmsConsumerBuilder setDestinationJndiName(String destinationJndiName) {
        this.getConfiguration().setDestinationJndiName(destinationJndiName);
        return this;
    }

    @Override
    public JmsConsumerBuilder setDurableSubscriptionName(String durableSubscriptionName) {
        this.getConfiguration().setDurableSubscriptionName(durableSubscriptionName);
        return this;
    }

    @Override
    public JmsConsumerBuilder setDurable(Boolean durable) {
        this.getConfiguration().setDurable(durable);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConnectionFactoryJndiProperties(Map<String, String> connectionFactoryJndiProperties) {
        this.getConfiguration().setConnectionFactoryJndiProperties(connectionFactoryJndiProperties);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConnectionFactoryJndiPropertyProviderUrl(String providerUrl) {
        if (this.getConfiguration().getConnectionFactoryJndiProperties() == null) {
            this.getConfiguration().setConnectionFactoryJndiProperties(new HashMap());
        }
        this.getConfiguration().getConnectionFactoryJndiProperties().put("java.naming.provider.url", providerUrl);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConnectionFactoryJndiPropertyFactoryInitial(String initialFactory) {
        if (this.getConfiguration().getConnectionFactoryJndiProperties() == null) {
            this.getConfiguration().setConnectionFactoryJndiProperties(new HashMap());
        }
        this.getConfiguration().getConnectionFactoryJndiProperties().put("java.naming.factory.initial", initialFactory);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConnectionFactoryJndiPropertyUrlPkgPrefixes(String urlPkgPrefixes) {
        if (this.getConfiguration().getConnectionFactoryJndiProperties() == null) {
            this.getConfiguration().setConnectionFactoryJndiProperties(new HashMap());
        }
        this.getConfiguration().getConnectionFactoryJndiProperties().put("java.naming.factory.url.pkgs", urlPkgPrefixes);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConnectionFactoryJndiPropertySecurityCredentials(String securityCredentials) {
        if (this.getConfiguration().getConnectionFactoryJndiProperties() == null) {
            this.getConfiguration().setConnectionFactoryJndiProperties(new HashMap());
        }
        this.getConfiguration().getConnectionFactoryJndiProperties().put("java.naming.security.credentials", securityCredentials);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConnectionFactoryJndiPropertySecurityPrincipal(String securityPrincipal) {
        if (this.getConfiguration().getConnectionFactoryJndiProperties() == null) {
            this.getConfiguration().setConnectionFactoryJndiProperties(new HashMap());
        }
        this.getConfiguration().getConnectionFactoryJndiProperties().put("java.naming.security.principal", securityPrincipal);
        return this;
    }

    @Override
    public JmsConsumerBuilder setDestinationJndiPropertyProviderUrl(String providerUrl) {
        if (this.getConfiguration().getDestinationJndiProperties() == null) {
            this.getConfiguration().setDestinationJndiProperties(new HashMap());
        }
        this.getConfiguration().getDestinationJndiProperties().put("java.naming.provider.url", providerUrl);
        return this;
    }

    @Override
    public JmsConsumerBuilder setDestinationJndiPropertyFactoryInitial(String initialFactory) {
        if (this.getConfiguration().getDestinationJndiProperties() == null) {
            this.getConfiguration().setDestinationJndiProperties(new HashMap());
        }
        this.getConfiguration().getDestinationJndiProperties().put("java.naming.factory.initial", initialFactory);
        return this;
    }

    @Override
    public JmsConsumerBuilder setDestinationJndiPropertyUrlPkgPrefixes(String urlPkgPrefixes) {
        if (this.getConfiguration().getDestinationJndiProperties() == null) {
            this.getConfiguration().setDestinationJndiProperties(new HashMap());
        }
        this.getConfiguration().getDestinationJndiProperties().put("java.naming.factory.url.pkgs", urlPkgPrefixes);
        return this;
    }

    @Override
    public JmsConsumerBuilder setDestinationJndiPropertySecurityCredentials(String securityCredentials) {
        if (this.getConfiguration().getDestinationJndiProperties() == null) {
            this.getConfiguration().setDestinationJndiProperties(new HashMap());
        }
        this.getConfiguration().getDestinationJndiProperties().put("java.naming.security.credentials", securityCredentials);
        return this;
    }

    @Override
    public JmsConsumerBuilder setDestinationJndiPropertySecurityPrincipal(String securityPrincipal) {
        if (this.getConfiguration().getDestinationJndiProperties() == null) {
            this.getConfiguration().setDestinationJndiProperties(new HashMap());
        }
        this.getConfiguration().getDestinationJndiProperties().put("java.naming.security.principal", securityPrincipal);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConnectionFactoryUsername(String username) {
        this.getConfiguration().setConnectionFactoryUsername(username);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConnectionFactoryPassword(String password) {
        this.getConfiguration().setConnectionFactoryPassword(password);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConnectionFactoryName(String connectionFactoryName) {
        this.getConfiguration().setConnectionFactoryName(connectionFactoryName);
        return this;
    }

    @Override
    public JmsConsumerBuilder setAutoContentConversion(boolean autoContentConversion) {
        this.getConfiguration().setAutoContentConversion(autoContentConversion);
        return this;
    }

    @Override
    public JmsConsumerBuilder setAutoSplitBatch(boolean autoSplitBatch) {
        this.getConfiguration().setAutoSplitBatch(autoSplitBatch);
        return this;
    }

    @Override
    public JmsConsumerBuilder setBatchMode(boolean batchMode) {
        this.getConfiguration().setBatchMode(batchMode);
        return this;
    }

    @Override
    public JmsConsumerBuilder setCacheLevel(int cacheLevel) {
        this.getConfiguration().setCacheLevel(cacheLevel);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConcurrentConsumers(int concurrentConsumers) {
        this.getConfiguration().setConcurrentConsumers(concurrentConsumers);
        return this;
    }

    @Override
    public JmsConsumerBuilder setBatchSize(int batchSize) {
        this.getConfiguration().setBatchSize(batchSize);
        return this;
    }

    @Override
    public JmsConsumerBuilder setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.getConfiguration().setMaxConcurrentConsumers(maxConcurrentConsumers);
        return this;
    }

    @Override
    public JmsConsumerBuilder setPubSubDomain(Boolean pubSubDomain) {
        this.getConfiguration().setPubSubDomain(pubSubDomain);
        return this;
    }

    @Override
    public JmsConsumerBuilder setSessionTransacted(Boolean sessionTransacted) {
        this.getConfiguration().setSessionTransacted(sessionTransacted);
        return this;
    }

    @Override
    public JmsConsumerBuilder setSessionAcknowledgeMode(Integer sessionAcknowledgeMode) {
        this.getConfiguration().setSessionAcknowledgeMode(sessionAcknowledgeMode);
        return this;
    }

    @Override
    public JmsConsumerBuilder setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    private SpringMessageConsumerConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new SpringMessageConsumerConfiguration();
        }
        return this.configuration;
    }

    @Override
    public JmsConsumerBuilder setConnectionUsername(String username) {
        this.username = username;
        return this;
    }

    @Override
    public JmsConsumerBuilder setConnectionPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public JmsContainerConsumer build() {
        Object aopProxiedMessageListener = null;
        aopProxiedMessageListener = this.aopProxyProvider != null ? (MessageListener)this.aopProxyProvider.applyPointcut(this.componentName, this.jmsConsumer) : this.jmsConsumer;
        if (this.messageProvider != null) {
            if (this.messageProvider instanceof IkasanMessageListenerContainer) {
                ((IkasanMessageListenerContainer)this.messageProvider).setConnectionFactory(this.getConnectionFactory(this.connectionFactory, this.username, this.password));
                ((ArjunaIkasanMessageListenerContainer)this.messageProvider).setMessageListener(aopProxiedMessageListener);
                ((ArjunaIkasanMessageListenerContainer)this.messageProvider).setErrorHandler((ErrorHandler)this.jmsConsumer);
                ((ArjunaIkasanMessageListenerContainer)this.messageProvider).setExceptionListener((ExceptionListener)this.jmsConsumer);
                if (this.receiveTimeout != null) {
                    ((ArjunaIkasanMessageListenerContainer)this.messageProvider).setReceiveTimeout(this.receiveTimeout.longValue());
                }
            }
            this.jmsConsumer.setMessageProvider(this.messageProvider);
        } else {
            ArjunaIkasanMessageListenerContainer messageListenerContainer = new ArjunaIkasanMessageListenerContainer();
            messageListenerContainer.setConnectionFactory(this.getConnectionFactory(this.connectionFactory, this.username, this.password));
            messageListenerContainer.setMessageListener(aopProxiedMessageListener);
            messageListenerContainer.setErrorHandler((ErrorHandler)this.jmsConsumer);
            messageListenerContainer.setExceptionListener((ExceptionListener)this.jmsConsumer);
            messageListenerContainer.setTransactionManager((PlatformTransactionManager)this.transactionManager);
            messageListenerContainer.setLocalTransactionManager(this.arjunaTransactionManager);
            if (this.receiveTimeout != null) {
                messageListenerContainer.setReceiveTimeout(this.receiveTimeout.longValue());
            }
            this.jmsConsumer.setMessageProvider((MessageProvider)messageListenerContainer);
        }
        if (this.configuration != null && this.jmsConsumer.getConfiguration() == null) {
            this.jmsConsumer.setConfiguration(this.configuration);
        }
        return this.jmsConsumer;
    }

    private ConnectionFactory getConnectionFactory(ConnectionFactory connectionFactory, String username, String password) {
        if (connectionFactory != null && username != null) {
            UserCredentialsConnectionFactoryAdapter cfCredentialsAdapter = this.getUserCredentialsConnectionFactoryAdapter();
            cfCredentialsAdapter.setTargetConnectionFactory(connectionFactory);
            cfCredentialsAdapter.setUsername(username);
            cfCredentialsAdapter.setPassword(password);
            return cfCredentialsAdapter;
        }
        return connectionFactory;
    }

    @Override
    public void setAopProxyProvider(AopProxyProvider aopProxyProvider) {
        this.aopProxyProvider = aopProxyProvider;
    }

    protected UserCredentialsConnectionFactoryAdapter getUserCredentialsConnectionFactoryAdapter() {
        return new UserCredentialsConnectionFactoryAdapter();
    }
}

