/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder.component.endpoint;

import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.transaction.TransactionManager;
import org.ikasan.builder.component.endpoint.JmsProducerBuilder;
import org.ikasan.component.endpoint.jms.producer.PostProcessor;
import org.ikasan.component.endpoint.jms.spring.producer.ArjunaJmsTemplateProducer;
import org.ikasan.component.endpoint.jms.spring.producer.JmsTemplateProducer;
import org.ikasan.component.endpoint.jms.spring.producer.SpringMessageProducerConfiguration;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jms.core.IkasanJmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.transaction.jta.JtaTransactionManager;

public class JmsProducerBuilderImpl
implements JmsProducerBuilder {
    IkasanJmsTemplate ikasanJmsTemplate;
    TransactionManager arjunaTransactionManager;
    SpringMessageProducerConfiguration configuration = new SpringMessageProducerConfiguration();
    String configuredResourceId;
    String username;
    String password;

    public JmsProducerBuilderImpl(IkasanJmsTemplate ikasanJmsTemplate, JtaTransactionManager transactionManager) {
        this.ikasanJmsTemplate = ikasanJmsTemplate;
        if (ikasanJmsTemplate == null) {
            throw new IllegalArgumentException("ikasanJmsTemplate cannot be 'null'");
        }
        this.arjunaTransactionManager = transactionManager.getTransactionManager();
    }

    @Override
    public JmsProducerBuilder setConfiguredResourceId(String configuredResourceId) {
        this.configuredResourceId = configuredResourceId;
        return this;
    }

    @Override
    public JmsProducerBuilder setConfiguration(SpringMessageProducerConfiguration jmsProducerConfiguration) {
        this.configuration = jmsProducerConfiguration;
        return this;
    }

    @Override
    public JmsProducerBuilder setTransactionManager(JtaTransactionManager transactionManager) {
        this.arjunaTransactionManager = transactionManager.getTransactionManager();
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionFactoryJndiPropertyProviderUrl(String providerUrl) {
        if (this.configuration.getConnectionFactoryJndiProperties() == null) {
            this.configuration.setConnectionFactoryJndiProperties(new HashMap());
        }
        this.configuration.getConnectionFactoryJndiProperties().put("java.naming.provider.url", providerUrl);
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionFactoryJndiPropertyFactoryInitial(String initialFactory) {
        if (this.configuration.getConnectionFactoryJndiProperties() == null) {
            this.configuration.setConnectionFactoryJndiProperties(new HashMap());
        }
        this.configuration.getConnectionFactoryJndiProperties().put("java.naming.factory.initial", initialFactory);
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionFactoryJndiPropertyUrlPkgPrefixes(String urlPackage) {
        if (this.configuration.getConnectionFactoryJndiProperties() == null) {
            this.configuration.setConnectionFactoryJndiProperties(new HashMap());
        }
        this.configuration.getConnectionFactoryJndiProperties().put("java.naming.factory.url.pkgs", urlPackage);
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionFactoryJndiPropertySecurityCredentials(String securityCredentials) {
        if (this.configuration.getConnectionFactoryJndiProperties() == null) {
            this.configuration.setConnectionFactoryJndiProperties(new HashMap());
        }
        this.configuration.getConnectionFactoryJndiProperties().put("java.naming.security.credentials", securityCredentials);
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionFactoryJndiPropertySecurityPrincipal(String securityPrincipal) {
        if (this.configuration.getConnectionFactoryJndiProperties() == null) {
            this.configuration.setConnectionFactoryJndiProperties(new HashMap());
        }
        this.configuration.getConnectionFactoryJndiProperties().put("java.naming.security.principal", securityPrincipal);
        return this;
    }

    @Override
    public JmsProducerBuilder setDestinationJndiPropertyProviderUrl(String providerUrl) {
        if (this.configuration.getDestinationJndiProperties() == null) {
            this.configuration.setDestinationJndiProperties(new HashMap());
        }
        this.configuration.getDestinationJndiProperties().put("java.naming.provider.url", providerUrl);
        return this;
    }

    @Override
    public JmsProducerBuilder setDestinationJndiPropertyFactoryInitial(String initialFactory) {
        if (this.configuration.getDestinationJndiProperties() == null) {
            this.configuration.setDestinationJndiProperties(new HashMap());
        }
        this.configuration.getDestinationJndiProperties().put("java.naming.factory.initial", initialFactory);
        return this;
    }

    @Override
    public JmsProducerBuilder setDestinationJndiPropertyUrlPkgPrefixes(String initialFactory) {
        if (this.configuration.getDestinationJndiProperties() == null) {
            this.configuration.setDestinationJndiProperties(new HashMap());
        }
        this.configuration.getDestinationJndiProperties().put("java.naming.factory.url.pkgs", initialFactory);
        return this;
    }

    @Override
    public JmsProducerBuilder setDestinationJndiPropertySecurityCredentials(String securityCredentials) {
        if (this.configuration.getDestinationJndiProperties() == null) {
            this.configuration.setDestinationJndiProperties(new HashMap());
        }
        this.configuration.getDestinationJndiProperties().put("java.naming.security.credentials", securityCredentials);
        return this;
    }

    @Override
    public JmsProducerBuilder setDestinationJndiPropertySecurityPrincipal(String securityPrincipal) {
        if (this.configuration.getDestinationJndiProperties() == null) {
            this.configuration.setDestinationJndiProperties(new HashMap());
        }
        this.configuration.getDestinationJndiProperties().put("java.naming.security.principal", securityPrincipal);
        return this;
    }

    @Override
    public JmsProducerBuilder setDestinationJndiProperties(Map<String, String> destinationJndiProperties) {
        this.configuration.setDestinationJndiProperties(destinationJndiProperties);
        return this;
    }

    @Override
    public JmsProducerBuilder setDestinationJndiName(String destinationJndiName) {
        this.configuration.setDestinationJndiName(destinationJndiName);
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionFactoryJndiProperties(Map<String, String> connectionFactoryJndiProperties) {
        this.configuration.setConnectionFactoryJndiProperties(connectionFactoryJndiProperties);
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionFactoryName(String connectionFactoryName) {
        this.configuration.setConnectionFactoryName(connectionFactoryName);
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionFactoryUsername(String connectionFactoryUsername) {
        this.configuration.setConnectionFactoryUsername(connectionFactoryUsername);
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionFactoryPassword(String connectionFactoryPassword) {
        this.configuration.setConnectionFactoryPassword(connectionFactoryPassword);
        return this;
    }

    @Override
    public JmsProducerBuilder setPubSubDomain(Boolean pubSubDomain) {
        this.configuration.setPubSubDomain(pubSubDomain);
        return this;
    }

    @Override
    public JmsProducerBuilder setDeliveryPersistent(Boolean deliveryPersistent) {
        this.configuration.setDeliveryPersistent(deliveryPersistent);
        return this;
    }

    @Override
    public JmsProducerBuilder setDeliveryMode(Integer deliveryMode) {
        this.configuration.setDeliveryMode(deliveryMode);
        return this;
    }

    @Override
    public JmsProducerBuilder setSessionTransacted(Boolean sessionTransacted) {
        this.configuration.setSessionTransacted(sessionTransacted);
        return this;
    }

    @Override
    public JmsProducerBuilder setExplicitQosEnabled(Boolean explicitQosEnabled) {
        this.configuration.setExplicitQosEnabled(explicitQosEnabled);
        return this;
    }

    @Override
    public JmsProducerBuilder setMessageIdEnabled(Boolean messageIdEnabled) {
        this.configuration.setMessageIdEnabled(messageIdEnabled);
        return this;
    }

    @Override
    public JmsProducerBuilder setMessageTimestampEnabled(Boolean messageTimestampEnabled) {
        this.configuration.setMessageTimestampEnabled(messageTimestampEnabled);
        return this;
    }

    @Override
    public JmsProducerBuilder setPriority(Integer priority) {
        this.configuration.setPriority(priority);
        return this;
    }

    @Override
    public JmsProducerBuilder setPubSubNoLocal(Boolean pubSubNoLocal) {
        this.configuration.setPubSubNoLocal(pubSubNoLocal);
        return this;
    }

    @Override
    public JmsProducerBuilder setReceiveTimeout(Long receiveTimeout) {
        this.configuration.setReceiveTimeout(receiveTimeout);
        return this;
    }

    @Override
    public JmsProducerBuilder setSessionAcknowledgeMode(Integer sessionAcknowledgeMode) {
        this.configuration.setSessionAcknowledgeMode(sessionAcknowledgeMode);
        return this;
    }

    @Override
    public JmsProducerBuilder setSessionAcknowledgeModeName(String sessionAcknowledgeModeName) {
        this.configuration.setSessionAcknowledgeModeName(sessionAcknowledgeModeName);
        return this;
    }

    @Override
    public JmsProducerBuilder setTimeToLive(Long timeToLive) {
        this.configuration.setTimeToLive(timeToLive);
        return this;
    }

    @Override
    public JmsProducerBuilder setPostProcessor(PostProcessor<?, ?> postProcessor) {
        this.ikasanJmsTemplate.setPostProcessor(postProcessor);
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionFactory(ConnectionFactory connectionFactory) {
        this.ikasanJmsTemplate.setConnectionFactory(connectionFactory);
        return this;
    }

    @Override
    public JmsProducerBuilder setMessageConverter(MessageConverter messageConverter) {
        this.ikasanJmsTemplate.setMessageConverter(messageConverter);
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionUsername(String username) {
        this.username = username;
        return this;
    }

    @Override
    public JmsProducerBuilder setConnectionPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public JmsTemplateProducer build() {
        JmsTemplateProducer jmsProducer = this.getJmsTemplateProducer(this.ikasanJmsTemplate);
        jmsProducer.setConfiguration(this.configuration);
        jmsProducer.setConfiguredResourceId(this.configuredResourceId);
        this.ikasanJmsTemplate.setConnectionFactory(this.getConnectionFactory(this.ikasanJmsTemplate.getConnectionFactory(), this.username, this.password));
        if (jmsProducer instanceof ArjunaJmsTemplateProducer) {
            ((ArjunaJmsTemplateProducer)jmsProducer).setLocalTransactionManager(this.arjunaTransactionManager);
        }
        return jmsProducer;
    }

    private ConnectionFactory getConnectionFactory(ConnectionFactory connectionFactory, String username, String password) {
        if (connectionFactory != null && username != null) {
            UserCredentialsConnectionFactoryAdapter cfCredentialsAdapter = this.getUserCredentialsConnectionFactoryAdapter();
            cfCredentialsAdapter.setTargetConnectionFactory(connectionFactory);
            cfCredentialsAdapter.setUsername(username);
            cfCredentialsAdapter.setPassword(password);
            return cfCredentialsAdapter;
        }
        return connectionFactory;
    }

    protected UserCredentialsConnectionFactoryAdapter getUserCredentialsConnectionFactoryAdapter() {
        return new UserCredentialsConnectionFactoryAdapter();
    }

    protected JmsTemplateProducer getJmsTemplateProducer(IkasanJmsTemplate ikasanJmsTemplate) {
        return new ArjunaJmsTemplateProducer(ikasanJmsTemplate);
    }
}

