/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder.component.endpoint;

import org.ikasan.builder.component.endpoint.SftpProducerBuilder;
import org.ikasan.connector.base.command.TransactionalResourceCommandDAO;
import org.ikasan.connector.basefiletransfer.outbound.persistence.BaseFileTransferDao;
import org.ikasan.connector.util.chunking.model.dao.FileChunkDao;
import org.ikasan.endpoint.sftp.producer.SftpProducer;
import org.ikasan.endpoint.sftp.producer.SftpProducerConfiguration;
import org.ikasan.spec.management.ManagedResourceRecoveryManager;
import org.springframework.transaction.jta.JtaTransactionManager;

public class SftpProducerBuilderImpl
implements SftpProducerBuilder {
    private TransactionalResourceCommandDAO transactionalResourceCommandDAO;
    private FileChunkDao fileChunkDao;
    private BaseFileTransferDao baseFileTransferDao;
    private JtaTransactionManager transactionManager;
    private SftpProducerConfiguration configuration;
    private ManagedResourceRecoveryManager managedResourceRecoveryManager;
    private String configuredResourceId;
    private boolean criticalOnStartup;

    public SftpProducerBuilderImpl(JtaTransactionManager transactionManager, BaseFileTransferDao baseFileTransferDao, FileChunkDao fileChunkDao, TransactionalResourceCommandDAO transactionalResourceCommandDAO) {
        this.transactionManager = transactionManager;
        this.baseFileTransferDao = baseFileTransferDao;
        this.fileChunkDao = fileChunkDao;
        this.transactionalResourceCommandDAO = transactionalResourceCommandDAO;
    }

    @Override
    public SftpProducerBuilder setCriticalOnStartup(boolean criticalOnStartup) {
        this.criticalOnStartup = criticalOnStartup;
        return this;
    }

    @Override
    public SftpProducerBuilder setConfiguredResourceId(String configuredResourceId) {
        this.configuredResourceId = configuredResourceId;
        return this;
    }

    @Override
    public SftpProducerBuilder setConfiguration(SftpProducerConfiguration sftpProducerConfiguration) {
        this.configuration = sftpProducerConfiguration;
        return this;
    }

    @Override
    public SftpProducerBuilder setTransactionManager(JtaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        return this;
    }

    @Override
    public SftpProducerBuilder setManagedResourceRecoveryManager(ManagedResourceRecoveryManager managedResourceRecoveryManager) {
        this.managedResourceRecoveryManager = managedResourceRecoveryManager;
        return this;
    }

    @Override
    public SftpProducerBuilder setOutputDirectory(String outputDirectory) {
        this.getConfiguration().setOutputDirectory(outputDirectory);
        return this;
    }

    @Override
    public SftpProducerBuilder setRenameExtension(String renameExtension) {
        this.getConfiguration().setRenameExtension(renameExtension);
        return this;
    }

    @Override
    public SftpProducerBuilder setTempFileName(String tempFileName) {
        this.getConfiguration().setTempFileName(tempFileName);
        return this;
    }

    @Override
    public SftpProducerBuilder setChecksumDelivered(Boolean checksumDelivered) {
        this.getConfiguration().setChecksumDelivered(checksumDelivered);
        return this;
    }

    @Override
    public SftpProducerBuilder setCleanUpChunks(Boolean cleanUpChunks) {
        this.getConfiguration().setCleanUpChunks(cleanUpChunks);
        return this;
    }

    @Override
    public SftpProducerBuilder setClientID(String clientID) {
        this.getConfiguration().setClientID(clientID);
        return this;
    }

    @Override
    public SftpProducerBuilder setCleanupJournalOnComplete(Boolean cleanupJournalOnComplete) {
        this.getConfiguration().setCleanupJournalOnComplete(cleanupJournalOnComplete);
        return this;
    }

    @Override
    public SftpProducerBuilder setCreateParentDirectory(Boolean createParentDirectory) {
        this.getConfiguration().setCreateParentDirectory(createParentDirectory);
        return this;
    }

    @Override
    public SftpProducerBuilder setOverwrite(Boolean overwrite) {
        this.getConfiguration().setOverwrite(overwrite);
        return this;
    }

    @Override
    public SftpProducerBuilder setUnzip(Boolean unzip) {
        this.getConfiguration().setUnzip(unzip);
        return this;
    }

    @Override
    public SftpProducerBuilder setRemoteHost(String remoteHost) {
        this.getConfiguration().setRemoteHost(remoteHost);
        return this;
    }

    @Override
    public SftpProducerBuilder setPrivateKeyFilename(String privateKeyFilename) {
        this.getConfiguration().setPrivateKeyFilename(privateKeyFilename);
        return this;
    }

    @Override
    public SftpProducerBuilder setMaxRetryAttempts(Integer maxRetryAttempts) {
        this.getConfiguration().setMaxRetryAttempts(maxRetryAttempts);
        return this;
    }

    @Override
    public SftpProducerBuilder setRemotePort(Integer remotePort) {
        this.getConfiguration().setRemotePort(remotePort);
        return this;
    }

    @Override
    public SftpProducerBuilder setKnownHostsFilename(String knownHostsFilename) {
        this.getConfiguration().setKnownHostsFilename(knownHostsFilename);
        return this;
    }

    @Override
    public SftpProducerBuilder setUsername(String username) {
        this.getConfiguration().setUsername(username);
        return this;
    }

    @Override
    public SftpProducerBuilder setPassword(String password) {
        this.getConfiguration().setPassword(password);
        return this;
    }

    @Override
    public SftpProducerBuilder setConnectionTimeout(Integer connectionTimeout) {
        this.getConfiguration().setConnectionTimeout(connectionTimeout);
        return this;
    }

    @Override
    public SftpProducerBuilder setPreferredKeyExchangeAlgorithm(String preferredKeyExchangeAlgorithm) {
        this.getConfiguration().setPreferredKeyExchangeAlgorithm(preferredKeyExchangeAlgorithm);
        return this;
    }

    private SftpProducerConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new SftpProducerConfiguration();
        }
        return this.configuration;
    }

    @Override
    public SftpProducer build() {
        SftpProducer sftpProducer = new SftpProducer(this.transactionManager, this.baseFileTransferDao, this.fileChunkDao, this.transactionalResourceCommandDAO);
        sftpProducer.setConfiguration(this.configuration);
        sftpProducer.setConfiguredResourceId(this.configuredResourceId);
        if (this.criticalOnStartup) {
            sftpProducer.setCriticalOnStartup(this.criticalOnStartup);
        }
        if (this.managedResourceRecoveryManager != null) {
            sftpProducer.setManagedResourceRecoveryManager(this.managedResourceRecoveryManager);
        }
        return sftpProducer;
    }
}

