/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.builder.component.filter;

import org.ikasan.builder.component.filter.MessageFilterBuilder;
import org.ikasan.filter.DefaultMessageFilter;
import org.ikasan.filter.duplicate.IsDuplicateFilterRule;
import org.ikasan.filter.duplicate.model.DefaultFilterEntry;
import org.ikasan.filter.duplicate.model.FilterEntry;
import org.ikasan.filter.duplicate.model.FilterEntryConverter;
import org.ikasan.filter.duplicate.model.FilterEntryConverterException;
import org.ikasan.filter.duplicate.service.DuplicateFilterService;
import org.ikasan.spec.component.filter.Filter;
import org.ikasan.spec.component.filter.FilterRule;

public class MessageFilterBuilderImpl
implements MessageFilterBuilder {
    DuplicateFilterService duplicateFilterService;
    String configuredResourceId;
    Object filterPojoConfiguration;
    FilterEntryConverter filterEntryConverter;
    int filterTimeToLive = 30;
    FilterEntryConverter objectHashingFilterEntryConverter = new ObjectHashingFilterEntryConverter();

    public MessageFilterBuilderImpl(DuplicateFilterService duplicateFilterService) {
        this.duplicateFilterService = duplicateFilterService;
        if (duplicateFilterService == null) {
            throw new IllegalArgumentException("duplicateFilterService cannot be 'null'");
        }
    }

    @Override
    public Filter build() {
        this.validateBuilderConfiguration();
        IsDuplicateFilterRule duplicateFilterRule = new IsDuplicateFilterRule(this.duplicateFilterService, this.filterEntryConverter);
        DefaultMessageFilter filter = new DefaultMessageFilter((FilterRule)duplicateFilterRule);
        if (this.filterPojoConfiguration != null) {
            filter.setConfiguration(this.filterPojoConfiguration);
        }
        filter.setConfiguredResourceId(this.configuredResourceId);
        return filter;
    }

    protected void validateBuilderConfiguration() {
        if (this.filterEntryConverter == null) {
            throw new IllegalArgumentException("filterEntryConverter is a required property for the defaultMessageFilter and cannot be 'null'");
        }
    }

    @Override
    public MessageFilterBuilder setConfiguredResourceId(String configuredResourceId) {
        this.configuredResourceId = configuredResourceId;
        return this;
    }

    @Override
    public MessageFilterBuilder setConfiguration(Object filterPojoConfiguration) {
        this.filterPojoConfiguration = filterPojoConfiguration;
        return this;
    }

    @Override
    public MessageFilterBuilder setFilterEntryConverter(FilterEntryConverter filterEntryConverter) {
        this.filterEntryConverter = filterEntryConverter;
        return this;
    }

    @Override
    public MessageFilterBuilder setFilterEntryTimeToLive(int filterTimeToLive) {
        this.filterTimeToLive = filterTimeToLive;
        return this;
    }

    @Override
    public MessageFilterBuilder setObjectHashingFilterEntryConverter() {
        this.filterEntryConverter = this.objectHashingFilterEntryConverter;
        return this;
    }

    class ObjectHashingFilterEntryConverter<T>
    implements FilterEntryConverter<T> {
        ObjectHashingFilterEntryConverter() {
        }

        public FilterEntry convert(T message) throws FilterEntryConverterException {
            Integer criteria = message.hashCode();
            return new DefaultFilterEntry(criteria, MessageFilterBuilderImpl.this.configuredResourceId, MessageFilterBuilderImpl.this.filterTimeToLive);
        }
    }
}

