package org.ikasan.component.converter.xml;

 /*
 * $Id$
 * $URL$
 *
 * ====================================================================
 * Ikasan Enterprise Integration Platform
 *
 * Distributed under the Modified BSD License.
 * Copyright notice: The copyright for this software and a full listing
 * of individual contributors are as shown in the packaged copyright.txt
 * file.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  - Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  - Neither the name of the ORGANIZATION nor the names of its contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 */

import java.util.Map;

/**
 * A wrapper class that provides static access to a ThreadLocal controlled map of beans
 *
 * Threads that call setBeans should later be able to call getBeans to retireve the same
 * map of beans, regardless of what any other thread may do in the meantime
 *
 * @author Ikasan Development Team
 *
 */
public class ThreadLocalBeansWrapper {

    /**
     * A ThreadLocal map of beans
     */
    private static ThreadLocal<Map<String, Object>> beansWrapper = new ThreadLocal<Map<String, Object>>();

    /**
     * Provides access to beans previously set by this thread
     *
     * @return Map of named java beans
     */
    public static Map<String, Object> getBeans(){
        return beansWrapper.get();
    }
    /**
     * Allows the current thread to set its own private beans for later retrieval
     *
     * @param beans Map of named java beans
     */
    public static void setBeans(Map<String, Object> beans){
        beansWrapper.set(beans);
    }

    /**
     * Clears the threadlocal
     */
    public static void remove() {
        beansWrapper.remove();

    }
}