/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector;

import org.apache.log4j.Logger;
import org.ikasan.common.ExceptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConnectorExceptionType implements ExceptionType
{
    MISSING_RESOURCE("The connector is missing a resource required at runtime, ie Session.properties", 3000),
    UNKNOWN_ERROR("The connector was not able to recognise this error type", 3001),
    CONNECTION_RESET_BY_PEER("The connector was reset by peer", 3002),
    CONNECTION_RESET_BY_CONNECTOR("The connector reset this connection", 3003),
    CONNECTION_TIMED_OUT("The connection timed out", 3004);

    private Logger logger = Logger.getLogger(ConnectorExceptionType.class);
    private String description = null;
    private int id = 0;

    private ConnectorExceptionType(String description, int id) {
        this.description = description;
        this.id = id;
        this.logger.debug((Object)("ConnectorExceptionType constructor created id [" + this.id + "]."));
    }

    public String getDescription() {
        this.logger.debug((Object)("Returning description [" + this.description + "]..."));
        return this.description;
    }

    public int getId() {
        this.logger.debug((Object)("Returning ID [" + this.id + "]..."));
        return this.id;
    }

    public static ExceptionType[] getExceptionTypes() {
        return ConnectorExceptionType.values();
    }

    public String getName() {
        return this.name();
    }

    public boolean equals(ExceptionType exceptionType) {
        if (exceptionType == null) {
            return false;
        }
        return exceptionType.getName().equals(this.name());
    }

    public static void main(String[] args) {
        for (ExceptionType exceptionType : ConnectorExceptionType.getExceptionTypes()) {
            System.out.println(exceptionType);
        }
        System.exit(0);
    }
}

