/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base;

import java.util.Timer;
import java.util.TimerTask;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Logger;

public abstract class AbstractResourceAdapter
implements ResourceAdapter {
    private static Logger logger = Logger.getLogger(AbstractResourceAdapter.class);
    private BootstrapContext bootCtx = null;
    private WorkManager workManager = null;
    private Timer timer = null;
    private XATerminator xaTerminator = null;

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        logger.info((Object)"Starting the resource adapter...");
        this.setBootstrapContext(ctx);
        this.setXATerminator(this.bootCtx.getXATerminator());
        this.setWorkManager(this.bootCtx.getWorkManager());
        try {
            this.timer = this.bootCtx.createTimer();
        }
        catch (UnavailableException e) {
            String err = "Exception while creating the timer.";
            logger.fatal((Object)err, (Throwable)e);
            throw new ResourceAdapterInternalException(err, (Throwable)e);
        }
    }

    private void setXATerminator(XATerminator terminator) {
        this.xaTerminator = terminator;
        logger.debug((Object)"XATerminator set.");
    }

    private void setBootstrapContext(BootstrapContext ctx) {
        this.bootCtx = ctx;
        logger.debug((Object)"BootStrapContext set.");
    }

    public void stop() {
        logger.info((Object)"Stopping the resource adapter and releasing the resources...");
        this.bootCtx = null;
        this.workManager = null;
        this.timer.cancel();
        this.timer = null;
        logger.info((Object)"Resource adapter is stopped and resources are released.");
    }

    public WorkManager getWorkManager() {
        logger.debug((Object)"Returning WorkManager...");
        return this.workManager;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
        logger.debug((Object)"WorkManager set.");
    }

    public Timer getTimer() {
        logger.debug((Object)"Returning Timer...");
        return this.timer;
    }

    public abstract void endpointActivation(MessageEndpointFactory var1, ActivationSpec var2) throws ResourceException;

    public abstract void endpointDeactivation(MessageEndpointFactory var1, ActivationSpec var2);

    public abstract XAResource[] getXAResources(ActivationSpec[] var1) throws ResourceException;

    public void schedule(TimerTask task) {
        logger.debug((Object)"Scheduling timer task...");
        this.getTimer().schedule(task, 0L);
    }
}

