/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base;

import java.io.Serializable;
import org.apache.log4j.Logger;

public class ConnectionState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ConnectionState.class);
    protected final Integer id;
    protected final String state;
    protected final String description;
    public static ConnectionState UNKNOWN = new ConnectionState(new Integer(0), "Unknown", "Cannot determine component status");
    public static ConnectionState DISCONNECTED = new ConnectionState(new Integer(1), "Disconnected", "Physical connection is not established");
    public static ConnectionState CONNECTED = new ConnectionState(new Integer(2), "Connected", "Physical connection is established, but without a session");
    public static ConnectionState SESSION_OPEN = new ConnectionState(new Integer(3), "Session Open", "Physical connection and session established");
    public static ConnectionState SESSION_CLOSED = new ConnectionState(new Integer(2), "Session Closed", "Physical connection is established, but without a session");

    protected ConnectionState(Integer id, String state, String description) {
        this.id = id;
        this.state = state;
        this.description = description;
    }

    public Integer getId() {
        logger.debug((Object)("Getting id [" + this.id + "]..."));
        return this.id;
    }

    public String getState() {
        logger.debug((Object)("Getting state [" + this.state + "]..."));
        return this.state;
    }

    public String getDescription() {
        logger.debug((Object)("Getting description [" + this.description + "]..."));
        return this.description;
    }

    public boolean isDisconnected() {
        return this.id == DISCONNECTED.getId();
    }

    public boolean isConnectionOpen() {
        return this.id >= CONNECTED.getId();
    }

    public boolean isSessionOpen() {
        return this.id >= SESSION_OPEN.getId();
    }

    public boolean isSessionClosed() {
        return this.id < SESSION_OPEN.getId();
    }

    public boolean isConnectionClosed() {
        return this.id < CONNECTED.getId();
    }
}

