/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base.command;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.resource.ResourceException;
import javax.transaction.xa.Xid;
import org.apache.log4j.Logger;
import org.ikasan.connector.base.command.ExecutionContext;
import org.ikasan.connector.base.command.ExecutionOutput;
import org.ikasan.connector.base.command.TransactionalResource;
import org.ikasan.connector.base.command.TransactionalResourceCommand;
import org.ikasan.connector.base.command.XidImpl;
import org.ikasan.connector.base.command.state.State;
import org.ikasan.connector.base.command.state.StateManager;
import org.ikasan.connector.base.command.state.Transition;
import org.ikasan.connector.base.journal.TransactionJournal;
import org.ikasan.connector.base.journal.TransactionJournalingException;
import org.springframework.beans.factory.BeanFactory;

public abstract class AbstractTransactionalResourceCommand
implements TransactionalResourceCommand {
    private static Logger logger = Logger.getLogger(AbstractTransactionalResourceCommand.class);
    private BeanFactory beanFactory;
    protected TransactionalResource transactionalResource;
    private static final SimpleDateFormat timestampFormat = new SimpleDateFormat("dd/MM/yyyy kk:mm:ss.SSSS");
    protected ExecutionContext executionContext;
    private TransactionJournal transactionJournal;
    public static final State INITIALISED_STATE = new State("Initialised");
    public static final State EXECUTION_IN_PROGRESS = new State("ExecutionInProgress");
    public static final State EXECUTED_STATE = new State("Executed");
    public static final State COMMIT_IN_PROGRESS = new State("CommitInProgress");
    public static final State COMPLETED_COMMITTING = new State("CompletedComitting");
    public static final State ROLLBACK_IN_PROGRESS = new State("RollbackInProgress");
    public static final State ROLLED_BACK_STATE = new State("RolledBack");
    private static final String BEGIN_EXECUTE_ACTION = "beginExecuteAction";
    private static final String COMPLETE_EXECUTE_ACTION = "completeExecuteAction";
    private static final String BEGIN_COMMIT_ACTION = "beginCommitAction";
    private static final String COMPLETE_COMMIT_ACTION = "completeCommitAction";
    private static final String BEGIN_ROLLBACK_ACTION = "beginRollbackAction";
    private static final String COMPLETE_ROLLBACK_ACTION = "completeRollbackAction";
    private static final StateManager stateManager = new StateManager();
    private XidImpl xid;
    private String executionTimestamp;
    private State state = INITIALISED_STATE;
    private Long id;

    public void commit() throws ResourceException {
        this.attemptAction(BEGIN_COMMIT_ACTION);
        this.doCommit();
        this.attemptAction(COMPLETE_COMMIT_ACTION);
    }

    private void attemptAction(String action) throws ResourceException {
        if (!stateManager.isValidTransition(this.state, action)) {
            this.reportIllegalTransition(action);
        }
        this.state = stateManager.getEndState(this.state, action);
        try {
            this.transactionJournal.notifyUpdate(this);
        }
        catch (TransactionJournalingException e) {
            throw new ResourceException("Exception notifying transaction journal", e.getCause());
        }
    }

    public ExecutionOutput execute(TransactionalResource resource, Xid executingXid) throws ResourceException {
        logger.debug((Object)("execute called with xid [" + executingXid + "]"));
        if (this.transactionJournal == null) {
            throw new ResourceException("Command must have a TransactionJournal set prior to execution");
        }
        try {
            this.setXid(this.transactionJournal.resolveXid(executingXid));
        }
        catch (TransactionJournalingException e) {
            throw new ResourceException("Exception resolving Xid", (Throwable)e);
        }
        ExecutionOutput result = null;
        this.attemptAction(BEGIN_EXECUTE_ACTION);
        this.setExecutionTimestamp(timestampFormat.format(new Date()));
        result = this.doExecute(resource);
        this.attemptAction(COMPLETE_EXECUTE_ACTION);
        return result;
    }

    public void rollback() throws ResourceException {
        this.attemptAction(BEGIN_ROLLBACK_ACTION);
        this.doRollback();
        this.attemptAction(COMPLETE_ROLLBACK_ACTION);
    }

    private void reportIllegalTransition(String action) {
        throw new RuntimeException("Invalid state transition!!, [" + action + "] should not be called whilst in state [" + this.state.getName() + "] object is [" + this + "]");
    }

    public String getState() {
        return this.state.getName();
    }

    protected abstract ExecutionOutput doExecute(TransactionalResource var1) throws ResourceException;

    protected abstract void doCommit() throws ResourceException;

    protected abstract void doRollback() throws ResourceException;

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    private void setState(String stateString) {
        this.state = stateManager.getState(stateString);
    }

    public String getExecutionTimestamp() {
        return this.executionTimestamp;
    }

    private void setExecutionTimestamp(String executionTimestamp) {
        this.executionTimestamp = executionTimestamp;
    }

    public void setTransactionJournal(TransactionJournal transactionJournal) {
        this.transactionJournal = transactionJournal;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setTransactionalResource(TransactionalResource transactionalResource) {
        this.transactionalResource = transactionalResource;
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public void setXid(XidImpl xid) {
        this.xid = xid;
        xid.addCommand(this);
    }

    static {
        logger.debug((Object)"StateManager initialisation");
        stateManager.addTransition(new Transition(INITIALISED_STATE, BEGIN_EXECUTE_ACTION, EXECUTION_IN_PROGRESS));
        stateManager.addTransition(new Transition(EXECUTION_IN_PROGRESS, COMPLETE_EXECUTE_ACTION, EXECUTED_STATE));
        stateManager.addTransition(new Transition(EXECUTION_IN_PROGRESS, BEGIN_ROLLBACK_ACTION, ROLLBACK_IN_PROGRESS));
        stateManager.addTransition(new Transition(EXECUTED_STATE, BEGIN_COMMIT_ACTION, COMMIT_IN_PROGRESS));
        stateManager.addTransition(new Transition(EXECUTED_STATE, BEGIN_ROLLBACK_ACTION, ROLLBACK_IN_PROGRESS));
        stateManager.addTransition(new Transition(COMMIT_IN_PROGRESS, COMPLETE_COMMIT_ACTION, COMPLETED_COMMITTING));
        stateManager.addTransition(new Transition(COMMIT_IN_PROGRESS, BEGIN_ROLLBACK_ACTION, ROLLBACK_IN_PROGRESS));
        stateManager.addTransition(new Transition(COMPLETED_COMMITTING, BEGIN_ROLLBACK_ACTION, ROLLBACK_IN_PROGRESS));
        stateManager.addTransition(new Transition(ROLLBACK_IN_PROGRESS, COMPLETE_ROLLBACK_ACTION, ROLLED_BACK_STATE));
    }
}

