/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base.command;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.transaction.xa.Xid;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.ikasan.connector.ConnectorContext;
import org.ikasan.connector.ResourceLoader;
import org.ikasan.connector.base.command.TransactionalResourceCommand;
import org.ikasan.connector.base.command.TransactionalResourceCommandDAO;
import org.ikasan.connector.base.command.TransactionalResourceCommandPersistenceException;
import org.ikasan.connector.base.command.XidImpl;
import org.ikasan.connector.base.command.state.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateTransactionalResourceCommandDAO
implements TransactionalResourceCommandDAO {
    private static final String GLOBAL_TRANSACTION_ID_PARAMETER = "globalTransactionIdParam";
    private static final String BRANCH_TRANSACTION_ID_PARAMETER = "branchTransactionIdParam";
    private static final String STATE_PARAMETER = "stateParam";
    private static final String FIND_XID_BY_XID = " from XidImpl c where c.globalTransactionIdString = :globalTransactionIdParam and c.branchQualifierString = :branchTransactionIdParam";
    private static final String FIND_XID_BY_STATE = " from XidImpl c where c.state = :stateParam";
    private static final String FIND_COMMANDS_BY_STATE = " from AbstractTransactionalResourceCommand c where c.state = :stateParam";
    private static Logger logger = Logger.getLogger(HibernateTransactionalResourceCommandDAO.class);
    private SessionFactory sessionFactory;
    protected ConnectorContext context = ResourceLoader.getInstance().newContext();

    @Deprecated
    public HibernateTransactionalResourceCommandDAO(String sessionFactoryServicePath) throws ResourceException {
        try {
            this.sessionFactory = (SessionFactory)this.context.lookup(sessionFactoryServicePath);
            if (this.sessionFactory == null) {
                throw new ResourceException("SessionFactory lookup of [" + sessionFactoryServicePath + "] returned null");
            }
        }
        catch (NamingException e) {
            throw new ResourceException("Failed to get SessionFactory from [" + sessionFactoryServicePath + "].", (Throwable)e);
        }
    }

    public HibernateTransactionalResourceCommandDAO(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void save(TransactionalResourceCommand command) throws TransactionalResourceCommandPersistenceException {
        logger.debug((Object)("save called with command [" + command + "]"));
        Session session = null;
        try {
            session = this.startSession();
            session.saveOrUpdate((Object)command);
            session.flush();
            session.getTransaction().commit();
        }
        catch (HibernateException e) {
            if (session != null) {
                session.getTransaction().rollback();
            }
            throw new TransactionalResourceCommandPersistenceException(e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    @Override
    public List<TransactionalResourceCommand> findCommandsByTransaction(Xid xid) throws TransactionalResourceCommandPersistenceException {
        ArrayList<TransactionalResourceCommand> result = new ArrayList();
        XidImpl xidImpl = this.find(xid);
        if (xidImpl == null) {
            throw new TransactionalResourceCommandPersistenceException("Could not find commands for Transaction because Xid cannot be found!!");
        }
        logger.debug((Object)("found xidImpl [" + xidImpl + "], now looking for associated commands..."));
        Session session = null;
        try {
            session = this.startSession();
            String xidParam = "xidParam";
            Query query = session.createQuery("from AbstractTransactionalResourceCommand c where c.xid.id = :" + xidParam);
            query.setParameter(xidParam, (Object)xidImpl.getId());
            result = query.list();
            session.getTransaction().commit();
        }
        catch (HibernateException e) {
            logger.error((Object)e);
            throw new TransactionalResourceCommandPersistenceException(e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return result;
    }

    private Session startSession() {
        Session session = this.sessionFactory.openSession();
        session.beginTransaction();
        return session;
    }

    @Override
    public List<TransactionalResourceCommand> findCommandsByState(State state) throws TransactionalResourceCommandPersistenceException {
        ArrayList<TransactionalResourceCommand> result = new ArrayList();
        Session session = null;
        try {
            session = this.startSession();
            Query query = session.createQuery(FIND_COMMANDS_BY_STATE);
            query.setParameter(STATE_PARAMETER, (Object)state.getName());
            result = query.list();
            session.getTransaction().commit();
        }
        catch (HibernateException e) {
            logger.error((Object)e);
            throw new TransactionalResourceCommandPersistenceException(e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return result;
    }

    @Override
    public XidImpl find(Xid xid) throws TransactionalResourceCommandPersistenceException {
        long startTime = System.currentTimeMillis();
        logger.debug((Object)("looking for Xid matching [" + xid + "]"));
        XidImpl result = null;
        Session session = null;
        try {
            session = this.startSession();
            Query query = session.createQuery(FIND_XID_BY_XID);
            query.setParameter(GLOBAL_TRANSACTION_ID_PARAMETER, (Object)new String(xid.getGlobalTransactionId()));
            query.setParameter(BRANCH_TRANSACTION_ID_PARAMETER, (Object)new String(xid.getBranchQualifier()));
            List xids = query.list();
            if (xids.size() > 1) {
                for (XidImpl xidImpl : xids) {
                    logger.debug((Object)("found non unique XidImpl [" + xidImpl + "]"));
                }
                throw new NonUniqueResultException(xids.size());
            }
            if (xids.size() == 1) {
                result = (XidImpl)xids.get(0);
            }
            session.getTransaction().commit();
        }
        catch (HibernateException e) {
            logger.error((Object)e);
            throw new TransactionalResourceCommandPersistenceException(e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        long endTime = System.currentTimeMillis();
        logger.debug((Object)("found [" + xid + "] in [" + (endTime - startTime) + "] ms"));
        return result;
    }

    @Override
    public void save(XidImpl xid) throws TransactionalResourceCommandPersistenceException {
        logger.debug((Object)("save called with xid [" + xid + "]"));
        Session session = null;
        try {
            session = this.startSession();
            session.saveOrUpdate((Object)xid);
            session.flush();
            session.getTransaction().commit();
        }
        catch (HibernateException e) {
            if (session != null) {
                session.getTransaction().rollback();
            }
            throw new TransactionalResourceCommandPersistenceException(e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    @Override
    public List<XidImpl> findXidbyState(String state) throws TransactionalResourceCommandPersistenceException {
        ArrayList<XidImpl> result = new ArrayList();
        Session session = null;
        try {
            session = this.startSession();
            Query query = session.createQuery(FIND_XID_BY_STATE);
            query.setParameter(STATE_PARAMETER, (Object)state);
            result = query.list();
            session.getTransaction().commit();
        }
        catch (HibernateException e) {
            logger.error((Object)e);
            throw new TransactionalResourceCommandPersistenceException(e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return result;
    }

    @Override
    public void deleteCommand(TransactionalResourceCommand command) throws TransactionalResourceCommandPersistenceException {
        this.delete(command);
    }

    @Override
    public void deleteXid(XidImpl xid) throws TransactionalResourceCommandPersistenceException {
        logger.debug((Object)("delete called with Xid [" + xid + "]"));
        this.delete(xid);
    }

    private void delete(Object obj) throws TransactionalResourceCommandPersistenceException {
        Session session = null;
        try {
            session = this.startSession();
            session.delete(obj);
            session.flush();
            session.getTransaction().commit();
        }
        catch (HibernateException e) {
            if (session != null) {
                session.getTransaction().rollback();
            }
            throw new TransactionalResourceCommandPersistenceException(e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }
}

