/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.resource.ResourceException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.log4j.Logger;
import org.ikasan.connector.base.command.ExecutionOutput;
import org.ikasan.connector.base.command.TransactionalResource;
import org.ikasan.connector.base.command.TransactionalResourceCommand;
import org.ikasan.connector.base.journal.TransactionJournal;
import org.ikasan.connector.base.journal.TransactionJournalingException;
import org.ikasan.connector.base.outbound.xa.EISXALRCOManagedConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionalCommandConnection
extends EISXALRCOManagedConnection {
    private static Logger logger = Logger.getLogger(TransactionalCommandConnection.class);
    private List<String> methodCalls = new ArrayList<String>();
    protected Xid xid;
    protected TransactionJournal transactionJournal;
    protected static int instanceCount = 0;
    protected Integer instanceOrdinal = null;

    @Override
    public final void start(Xid pXid, int flag) throws XAException {
        boolean tmresume;
        this.methodCalls.add("start " + new String(pXid.getBranchQualifier()) + " instance [" + this.instanceOrdinal + "] of [" + instanceCount + "]");
        boolean tmjoin = flag == 0x200000;
        boolean bl = tmresume = flag == 0x8000000;
        if (this.xid != null) {
            logger.warn((Object)("in XAResource.start, but the xid is already set as [" + this.xid + "]"));
            for (String methodCall : this.methodCalls) {
                logger.warn((Object)("method call:" + methodCall));
            }
        }
        logger.debug((Object)("in start, got xid [" + pXid + "] and arg1 [" + flag + "] tmjoin =[" + tmjoin + "] tmresume =[" + tmresume + "]"));
        if (!tmresume) {
            this.setXid(pXid);
            logger.debug((Object)"We are not resuming a previous txn, this is a brand new one.");
            try {
                this.transactionJournal.onXAEvent(this.xid, "start");
            }
            catch (TransactionJournalingException e) {
                logger.error((Object)e);
                throw new XAException("Exception caught on XA.start :" + e.getMessage());
            }
        } else {
            logger.info((Object)("attempt made to resume with xid [" + this.xid + "]"));
        }
    }

    @Override
    public final void end(Xid arg0, int flag) throws XAException {
        boolean tmsuccess = flag == 0x4000000;
        boolean tmfail = flag == 0x20000000;
        boolean tmsuspend = flag == 0x2000000;
        this.methodCalls.add("end " + new String(arg0.getBranchQualifier()) + " storedXid=[" + this.xid + "] tmsuccess =[" + tmsuccess + "] tmfail=[" + tmfail + "] tmsuspend=[" + tmsuspend + "]");
        this.testXidArg(arg0, this.xid);
        logger.debug((Object)("in end, xid=[" + arg0 + "]" + "] flag=[" + flag + "] tmsuccess =[" + tmsuccess + "] tmfail=[" + tmfail + "] tmsuspend=[" + tmsuspend + "]"));
        try {
            this.transactionJournal.onXAEvent(this.xid, "end");
        }
        catch (TransactionJournalingException e) {
            logger.error((Object)e);
            throw new XAException("Exception caught on XA.end :" + e.getMessage());
        }
    }

    private void testXidArg(Xid receivedXid, Xid storedXid) {
        byte[] recievedXidGlobalTxnId = receivedXid.getGlobalTransactionId();
        byte[] storedXidGlobalTxnId = storedXid.getGlobalTransactionId();
        byte[] recievedXidBranchQualifier = receivedXid.getBranchQualifier();
        byte[] storedXidBranchQualifer = storedXid.getBranchQualifier();
        if (!Arrays.equals(recievedXidGlobalTxnId, storedXidGlobalTxnId) || !Arrays.equals(recievedXidBranchQualifier, storedXidBranchQualifer) || receivedXid.getFormatId() != storedXid.getFormatId()) {
            logger.warn((Object)("Received a different xid [" + receivedXid + "] than that recorded during start [" + storedXid + "]"));
            for (String methodCall : this.methodCalls) {
                logger.warn((Object)("method call:" + methodCall));
            }
        }
    }

    public ExecutionOutput executeCommand(TransactionalResourceCommand command) throws ResourceException {
        this.methodCalls.add("executeCommand stored xid =[" + this.xid + "]");
        ExecutionOutput result = null;
        try {
            if (this.transactionJournal == null) {
                throw new ResourceException("transactionJournal should not be null");
            }
            command.setTransactionJournal(this.transactionJournal);
            TransactionalResource transactionalResource = this.getTransactionalResource();
            transactionalResource.ensureConnection();
            result = command.execute(transactionalResource, this.xid);
        }
        catch (ResourceException re) {
            this.sendErrorEvent(re);
            this.methodCalls.add("exception in executeCommand stored xid =[" + this.xid + "]");
            logger.error((Object)("Exception caught when executing command: [" + command + "]"), (Throwable)re);
            throw re;
        }
        this.methodCalls.add("end of executeCommand stored xid =[" + this.xid + "]");
        return result;
    }

    @Override
    public void rollback(Xid pXid) throws XAException {
        this.methodCalls.add("rollback stored Xid =[" + new String(this.xid.getBranchQualifier()) + "] received Xid=[" + new String(pXid.getBranchQualifier() + "]"));
        logger.debug((Object)("rollback called with xid [" + pXid + "]"));
        this.testXidArg(pXid, this.xid);
        this.preRollback(pXid);
        try {
            this.rollbackCommands();
        }
        catch (ResourceException e) {
            logger.warn((Object)"Received a ResourceException in the rollback, wrapping message inside a XAException and throwing that", (Throwable)e);
            throw new XAException(e.getMessage());
        }
        this.postRollback(pXid);
        try {
            this.transactionJournal.onXAEvent(this.xid, "rollback");
        }
        catch (TransactionJournalingException e) {
            logger.error((Object)e);
            throw new XAException("Exception caught on XA.rollback :" + e.getMessage());
        }
        if (this.cleanupJournalOnComplete()) {
            try {
                this.transactionJournal.cleanup(this.xid);
            }
            catch (TransactionJournalingException e) {
                logger.error((Object)"Exception caught in postRollback, cannot do anything with this!", (Throwable)e);
            }
        }
        this.setXid(null);
    }

    private void setXid(Xid xid) {
        logger.debug((Object)("setXid called with [" + xid + "] was previously [" + this.xid + "]"));
        this.xid = xid;
    }

    @Override
    public void commit(Xid resourceId, boolean flag) throws XAException {
        logger.debug((Object)("in commit, got xid [" + resourceId + "] and flag [" + flag + "]"));
        this.methodCalls.add("commit " + new String(resourceId.getBranchQualifier()));
        this.testXidArg(resourceId, this.xid);
        this.preCommit(resourceId);
        try {
            this.commitCommands();
        }
        catch (ResourceException e) {
            logger.warn((Object)"Received a  ResourceException in the commit, wrapping message inside a XAException and throwing that", (Throwable)e);
            throw new XAException(e.getMessage());
        }
        this.postCommit(resourceId);
        try {
            this.transactionJournal.onXAEvent(this.xid, "commit");
        }
        catch (TransactionJournalingException e) {
            logger.error((Object)e);
            throw new XAException("Exception caught on XA.commit :" + e.getMessage());
        }
        if (this.cleanupJournalOnComplete()) {
            try {
                this.transactionJournal.cleanup(this.xid);
            }
            catch (TransactionJournalingException e) {
                logger.error((Object)"Exception caught in postCommit, cannot do anything with this!", (Throwable)e);
            }
        }
        this.setXid(null);
    }

    protected boolean cleanupJournalOnComplete() {
        return false;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        logger.debug((Object)"in recover");
        Xid[] result = new Xid[]{};
        switch (flag) {
            case 0: 
            case 0x1000000: {
                try {
                    result = this.transactionJournal.getExecutedTransactions();
                    break;
                }
                catch (TransactionJournalingException e) {
                    throw new XAException("Exception caught retrieving executed transactions from Transaction Journal. " + e.getMessage());
                }
            }
            case 0x800000: {
                break;
            }
            default: {
                throw new XAException("Unsupported flag passed to recover method [" + flag + "]");
            }
        }
        return result;
    }

    protected void commitCommands() throws ResourceException {
        TransactionalResource transactionalResource = this.getTransactionalResource();
        for (TransactionalResourceCommand command : this.getCommands()) {
            logger.debug((Object)("about to call commit on command [" + command + "]"));
            command.setTransactionalResource(transactionalResource);
            command.commit();
        }
    }

    private List<TransactionalResourceCommand> getCommands() throws ResourceException {
        List<TransactionalResourceCommand> commands;
        try {
            commands = this.transactionJournal.getCommands(this.xid);
        }
        catch (TransactionJournalingException e) {
            throw new ResourceException("Exception finding command history in journal for tx [" + this.xid + "]", (Throwable)e);
        }
        return commands;
    }

    protected void rollbackCommands() throws ResourceException {
        ArrayList<TransactionalResourceCommand> reverseCommands = new ArrayList<TransactionalResourceCommand>();
        TransactionalResource transactionalResource = this.getTransactionalResource();
        reverseCommands.addAll(this.getCommands());
        Collections.reverse(reverseCommands);
        for (TransactionalResourceCommand command : reverseCommands) {
            command.setTransactionalResource(transactionalResource);
            command.rollback();
        }
    }

    protected abstract TransactionalResource getTransactionalResource();

    protected void preRollback(Xid arg0) {
        logger.debug((Object)("preRollback with: [" + arg0 + "]"));
    }

    protected void preCommit(Xid arg0) {
        logger.debug((Object)("In preCommit with: [" + arg0 + "]"));
    }

    protected void postRollback(Xid arg0) {
        logger.debug((Object)("postRollback with: [" + arg0 + "]"));
    }

    protected void postCommit(Xid arg0) {
        logger.debug((Object)("In postCommit with: [" + arg0 + "]"));
    }

    public void setTransactionJournal(TransactionJournal transactionJournal) {
        this.transactionJournal = transactionJournal;
    }

    @Override
    public int prepare(Xid arg0) throws XAException {
        this.methodCalls.add("prepare " + new String(arg0.getBranchQualifier()));
        logger.debug((Object)("in prepare with [" + arg0 + "]"));
        this.testXidArg(arg0, this.xid);
        try {
            this.transactionJournal.onXAEvent(this.xid, "prepare");
        }
        catch (TransactionJournalingException e) {
            logger.error((Object)e);
            throw new XAException("Exception caught on XA.prepare :" + e.getMessage());
        }
        return 0;
    }

    public boolean transactionInProgress() {
        return this.xid != null;
    }
}

